/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.interceptor;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.collection.IsMapContaining;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsSame;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.interception.InterceptionAction;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.mule.runtime.api.interception.ProcessorParameterValue;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.component.ComponentAnnotations;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.processor.ParametersResolverProcessor;
import org.mule.runtime.core.internal.processor.interceptor.DefaultProcessorInterceptorManager;
import org.mule.runtime.core.internal.processor.interceptor.InterceptionException;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.matcher.EventMatcher;
import org.mule.tck.junit4.matcher.MessagingExceptionMatcher;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.size.SmallTest;
import org.mule.tck.util.MuleContextUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@SmallTest
@RunWith(value=Parameterized.class)
public class ReactiveInterceptorAdapterTestCase
extends AbstractMuleContextTestCase {
    private final boolean useMockInterceptor;
    private final Processor processor;
    @Inject
    private DefaultProcessorInterceptorManager processorInterceptiorManager;
    private Flow flow;
    @Rule
    public ExpectedException expected = ExpectedException.none();

    public ReactiveInterceptorAdapterTestCase(boolean useMockInterceptor, Processor processor) {
        this.useMockInterceptor = useMockInterceptor;
        this.processor = (Processor)Mockito.spy((Object)processor);
    }

    protected boolean doTestClassInjection() {
        return true;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({true, new ProcessorInApp()}, {true, new OperationProcessorInApp()}, {false, new ProcessorInApp()}, {false, new OperationProcessorInApp()});
    }

    @Before
    public void before() throws MuleException {
        this.flow = Flow.builder((String)"flow", (MuleContext)muleContext).processors(new Processor[]{this.processor}).build();
    }

    @After
    public void after() throws MuleException {
        this.flow.stop();
        this.flow.dispose();
    }

    private ProcessorInterceptor prepareInterceptor(ProcessorInterceptor interceptor) {
        if (this.useMockInterceptor) {
            return (ProcessorInterceptor)Mockito.spy((Object)interceptor);
        }
        return interceptor;
    }

    @Test
    public void interceptorApplied() throws Exception {
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){});
        this.startFlowWithInterceptors(interceptor);
        CoreEvent result = this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)""));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.eq((Object)((Component)this.processor).getLocation()), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.eq((Object)((Component)this.processor).getLocation()), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.hasPayloadValue("")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.eq((Object)((Component)this.processor).getLocation()), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(((InternalEvent)result).getInternalParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    @Test
    public void interceptorMutatesEventBefore() throws Exception {
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){

            public void before(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event) {
                event.message(Message.of((Object)"test"));
            }
        });
        this.startFlowWithInterceptors(interceptor);
        CoreEvent result = this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"test"));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", "test"), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.hasPayloadValue("test")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(((InternalEvent)result).getInternalParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)2));
        }
    }

    @Test
    public void interceptorMutatesEventAfter() throws Exception {
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){

            public void after(ComponentLocation location, InterceptionEvent event, Optional<Throwable> thrown) {
                event.message(Message.of((Object)"test"));
            }
        });
        this.startFlowWithInterceptors(interceptor);
        CoreEvent result = this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"test"));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.hasPayloadValue("")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(((InternalEvent)result).getInternalParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    @Test
    public void interceptorMutatesEventAroundBeforeProceed() throws Exception {
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
                event.message(Message.of((Object)"test"));
                return action.proceed();
            }
        });
        this.startFlowWithInterceptors(interceptor);
        CoreEvent result = this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"test"));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.hasPayloadValue("test")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(((InternalEvent)result).getInternalParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    @Test
    public void interceptorMutatesEventAroundAfterProceed() throws Exception {
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
                action.proceed();
                return CompletableFuture.supplyAsync(() -> {
                    event.message(Message.of((Object)"test"));
                    return event;
                });
            }
        });
        this.startFlowWithInterceptors(interceptor);
        CoreEvent result = this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"test"));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.hasPayloadValue("")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(((InternalEvent)result).getInternalParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    @Test
    public void interceptorMutatesEventAroundBeforeSkip() throws Exception {
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
                event.message(Message.of((Object)"test"));
                return action.skip();
            }
        });
        this.startFlowWithInterceptors(interceptor);
        CoreEvent result = this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"test"));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((CoreEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(((InternalEvent)result).getInternalParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    @Test
    public void interceptorMutatesEventAroundAfterSkip() throws Exception {
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
                action.skip();
                return CompletableFuture.supplyAsync(() -> {
                    event.message(Message.of((Object)"test"));
                    return event;
                });
            }
        });
        this.startFlowWithInterceptors(interceptor);
        CoreEvent result = this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"test"));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((CoreEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(((InternalEvent)result).getInternalParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void interceptorMutatesEventAroundAfterFailWithErrorType() throws Exception {
        final ErrorType errorTypeMock = (ErrorType)Mockito.mock(ErrorType.class);
        Mockito.when((Object)errorTypeMock.getIdentifier()).thenReturn((Object)"ID");
        Mockito.when((Object)errorTypeMock.getNamespace()).thenReturn((Object)"NS");
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
                event.message(Message.of((Object)"test"));
                return action.fail(errorTypeMock);
            }
        });
        this.startFlowWithInterceptors(interceptor);
        this.expected.expect(MessagingException.class);
        this.expected.expect((Matcher)MessagingExceptionMatcher.withEventThat((EventMatcher)EventMatcher.hasErrorTypeThat((Matcher)IsSame.sameInstance((Object)errorTypeMock))));
        this.expected.expectCause(org.hamcrest.Matchers.instanceOf(InterceptionException.class));
        try {
            this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((CoreEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.argThat((Matcher)org.hamcrest.Matchers.not(Optional.empty())));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((CoreEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.argThat((Matcher)org.hamcrest.Matchers.not(Optional.empty())));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void interceptorMutatesEventAroundAfterFailWithCause() throws Exception {
        final RuntimeException cause = new RuntimeException("");
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
                event.message(Message.of((Object)"test"));
                return action.fail(cause);
            }
        });
        this.startFlowWithInterceptors(interceptor);
        this.expected.expectCause(IsSame.sameInstance((Object)cause));
        try {
            this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((CoreEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.of(cause)));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((CoreEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.of(cause)));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void interceptorThrowsExceptionBefore() throws Exception {
        final RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){

            public void before(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event) {
                throw expectedException;
            }
        });
        this.startFlowWithInterceptors(interceptor);
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor, Mockito.never())).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((CoreEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor, Mockito.never())).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((CoreEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void interceptorThrowsExceptionAfter() throws Exception {
        final RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){

            public void after(ComponentLocation location, InterceptionEvent event, Optional<Throwable> thrown) {
                throw expectedException;
            }
        });
        this.startFlowWithInterceptors(interceptor);
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.hasPayloadValue("")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.hasPayloadValue("")));
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void interceptorThrowsExceptionAround() throws Exception {
        final RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
                throw expectedException;
            }
        });
        this.startFlowWithInterceptors(interceptor);
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((CoreEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((CoreEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void interceptorThrowsExceptionAroundAfterProceed() throws Exception {
        final RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
                action.proceed();
                throw expectedException;
            }
        });
        this.startFlowWithInterceptors(interceptor);
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void interceptorThrowsExceptionAroundAfterProceedInCallback() throws Exception {
        final RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
                action.proceed();
                return CompletableFuture.supplyAsync(() -> {
                    throw expectedException;
                });
            }
        });
        this.startFlowWithInterceptors(interceptor);
        this.expected.expect(MessagingException.class);
        this.expected.expect((Matcher)MessagingExceptionMatcher.withEventThat((EventMatcher)EventMatcher.hasErrorType((String)Errors.ComponentIdentifiers.Handleable.UNKNOWN.getNamespace(), (String)Errors.ComponentIdentifiers.Handleable.UNKNOWN.getName())));
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void interceptorThrowsExceptionAroundAfterProceedInCallbackChained() throws Exception {
        final RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
                return action.proceed().thenApplyAsync(e -> {
                    throw expectedException;
                });
            }
        });
        this.startFlowWithInterceptors(interceptor);
        this.expected.expect(MessagingException.class);
        this.expected.expect((Matcher)MessagingExceptionMatcher.withEventThat((EventMatcher)EventMatcher.hasErrorType((String)Errors.ComponentIdentifiers.Handleable.UNKNOWN.getNamespace(), (String)Errors.ComponentIdentifiers.Handleable.UNKNOWN.getName())));
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void interceptorThrowsExceptionAroundAfterSkipInCallback() throws Exception {
        final RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
                action.skip();
                return CompletableFuture.supplyAsync(() -> {
                    throw expectedException;
                });
            }
        });
        this.startFlowWithInterceptors(interceptor);
        this.expected.expect(MessagingException.class);
        this.expected.expect((Matcher)MessagingExceptionMatcher.withEventThat((EventMatcher)EventMatcher.hasErrorType((String)Errors.ComponentIdentifiers.Handleable.UNKNOWN.getNamespace(), (String)Errors.ComponentIdentifiers.Handleable.UNKNOWN.getName())));
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((CoreEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((CoreEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void interceptorThrowsExceptionAroundAfterSkipInCallbackChained() throws Exception {
        final RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
                return action.skip().thenApplyAsync(e -> {
                    throw expectedException;
                });
            }
        });
        this.startFlowWithInterceptors(interceptor);
        this.expected.expect(MessagingException.class);
        this.expected.expect((Matcher)MessagingExceptionMatcher.withEventThat((EventMatcher)EventMatcher.hasErrorType((String)Errors.ComponentIdentifiers.Handleable.UNKNOWN.getNamespace(), (String)Errors.ComponentIdentifiers.Handleable.UNKNOWN.getName())));
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((CoreEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((CoreEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void interceptedThrowsException() throws Exception {
        RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){});
        this.startFlowWithInterceptors(interceptor);
        Mockito.when((Object)this.processor.process((CoreEvent)Matchers.any())).thenThrow(new Throwable[]{expectedException});
        this.expected.expect(MessagingException.class);
        this.expected.expect((Matcher)MessagingExceptionMatcher.withEventThat((EventMatcher)EventMatcher.hasErrorType((String)Errors.ComponentIdentifiers.Handleable.UNKNOWN.getNamespace(), (String)Errors.ComponentIdentifiers.Handleable.UNKNOWN.getName())));
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    @Test
    public void interceptorSkipsProcessor() throws Exception {
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
                return action.skip();
            }
        });
        this.startFlowWithInterceptors(interceptor);
        CoreEvent result = this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)""));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((CoreEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(((InternalEvent)result).getInternalParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    @Test
    public void firstInterceptorMutatesEventBefore() throws Exception {
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new TestProcessorInterceptor("outer"){

            public void before(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event) {
                event.message(Message.of((Object)"test"));
            }
        });
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new TestProcessorInterceptor("inner"){});
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        CoreEvent result = this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"test"));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", "test"), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", "test"), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", "test"), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.hasPayloadValue("test")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(((InternalEvent)result).getInternalParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)2));
        }
    }

    @Test
    public void secondInterceptorMutatesEventBefore() throws Exception {
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new TestProcessorInterceptor("outer"){});
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new TestProcessorInterceptor("inner"){

            public void before(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event) {
                event.message(Message.of((Object)"test"));
            }
        });
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        CoreEvent result = this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"test"));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", "test"), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", "test"), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.hasPayloadValue("test")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(((InternalEvent)result).getInternalParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)2));
        }
    }

    @Test
    public void firstInterceptorMutatesEventAfter() throws Exception {
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new TestProcessorInterceptor("outer"){

            public void after(ComponentLocation location, InterceptionEvent event, Optional<Throwable> thrown) {
                event.message(Message.of((Object)"test"));
            }
        });
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new TestProcessorInterceptor("inner"){});
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        CoreEvent result = this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"test"));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.hasPayloadValue("")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(((InternalEvent)result).getInternalParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    @Test
    public void secondInterceptorMutatesEventAfter() throws Exception {
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new TestProcessorInterceptor("outer"){});
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new TestProcessorInterceptor("inner"){

            public void after(ComponentLocation location, InterceptionEvent event, Optional<Throwable> thrown) {
                event.message(Message.of((Object)"test"));
            }
        });
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        CoreEvent result = this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"test"));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.hasPayloadValue("")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(((InternalEvent)result).getInternalParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    @Test
    public void firstInterceptorMutatesEventAroundBeforeProceed() throws Exception {
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new TestProcessorInterceptor("outer"){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
                event.message(Message.of((Object)"test"));
                return action.proceed();
            }
        });
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new TestProcessorInterceptor("inner"){});
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        CoreEvent result = this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"test"));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", "test"), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.hasPayloadValue("test")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(((InternalEvent)result).getInternalParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)2));
        }
    }

    @Test
    public void secondInterceptorMutatesEventAroundBeforeProceed() throws Exception {
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new TestProcessorInterceptor("outer"){});
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new TestProcessorInterceptor("inner"){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
                event.message(Message.of((Object)"test"));
                return action.proceed();
            }
        });
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        CoreEvent result = this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"test"));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.hasPayloadValue("test")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(((InternalEvent)result).getInternalParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    @Test
    public void firstInterceptorMutatesEventAroundAfterProceed() throws Exception {
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new TestProcessorInterceptor("outer"){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
                action.proceed();
                return CompletableFuture.supplyAsync(() -> {
                    event.message(Message.of((Object)"test"));
                    return event;
                });
            }
        });
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new TestProcessorInterceptor("inner"){});
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        CoreEvent result = this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"test"));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.hasPayloadValue("")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(((InternalEvent)result).getInternalParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    @Test
    public void firstInterceptorMutatesEventAroundAfterProceedChained() throws Exception {
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new TestProcessorInterceptor("outer"){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
                return action.proceed().thenApplyAsync(e -> {
                    e.message(Message.of((Object)"test"));
                    return e;
                });
            }
        });
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new TestProcessorInterceptor("inner"){});
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        CoreEvent result = this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"test"));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.hasPayloadValue("")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(((InternalEvent)result).getInternalParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    @Test
    public void secondInterceptorMutatesEventAroundAfterProceed() throws Exception {
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new TestProcessorInterceptor("outer"){});
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new TestProcessorInterceptor("inner"){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
                action.proceed();
                return CompletableFuture.supplyAsync(() -> {
                    event.message(Message.of((Object)"test"));
                    return event;
                });
            }
        });
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        CoreEvent result = this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"test"));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.hasPayloadValue("")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(((InternalEvent)result).getInternalParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    @Test
    public void secondInterceptorMutatesEventAroundAfterProceedChained() throws Exception {
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new TestProcessorInterceptor("outer"){});
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new TestProcessorInterceptor("inner"){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
                return action.proceed().thenApplyAsync(e -> {
                    e.message(Message.of((Object)"test"));
                    return e;
                });
            }
        });
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        CoreEvent result = this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"test"));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.hasPayloadValue("")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(((InternalEvent)result).getInternalParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void firstInterceptorThrowsExceptionBefore() throws Exception {
        final RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new TestProcessorInterceptor("outer"){

            public void before(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event) {
                throw expectedException;
            }
        });
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new TestProcessorInterceptor("inner"){});
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1, Mockito.never())).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((CoreEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1, Mockito.never())).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((CoreEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void secondInterceptorThrowsExceptionBefore() throws Exception {
        final RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new TestProcessorInterceptor("outer"){});
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new TestProcessorInterceptor("inner"){

            public void before(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event) {
                throw expectedException;
            }
        });
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1, Mockito.never())).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((CoreEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1, Mockito.never())).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((CoreEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void firstInterceptorThrowsExceptionAfter() throws Exception {
        final RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new TestProcessorInterceptor("outer"){

            public void after(ComponentLocation location, InterceptionEvent event, Optional<Throwable> thrown) {
                throw expectedException;
            }
        });
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new TestProcessorInterceptor("inner"){});
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void secondInterceptorThrowsExceptionAfter() throws Exception {
        final RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new TestProcessorInterceptor("outer"){});
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new TestProcessorInterceptor("inner"){

            public void after(ComponentLocation location, InterceptionEvent event, Optional<Throwable> thrown) {
                throw expectedException;
            }
        });
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void firstInterceptorThrowsExceptionAround() throws Exception {
        final RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new TestProcessorInterceptor("outer"){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
                throw expectedException;
            }
        });
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new TestProcessorInterceptor("inner"){});
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((CoreEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((CoreEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void secondInterceptorThrowsExceptionAround() throws Exception {
        final RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new TestProcessorInterceptor("outer"){});
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new TestProcessorInterceptor("inner"){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
                throw expectedException;
            }
        });
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((CoreEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((CoreEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void firstInterceptorFailsAround() throws Exception {
        final RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new TestProcessorInterceptor("outer"){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
                return action.fail((Throwable)expectedException);
            }
        });
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new TestProcessorInterceptor("inner"){});
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((CoreEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((CoreEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void secondInterceptorFailsAround() throws Exception {
        final RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new TestProcessorInterceptor("outer"){});
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new TestProcessorInterceptor("inner"){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
                return action.fail((Throwable)expectedException);
            }
        });
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((CoreEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((CoreEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void firstInterceptorThrowsExceptionAroundAfterProceed() throws Exception {
        final RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new TestProcessorInterceptor("outer"){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
                action.proceed();
                throw expectedException;
            }
        });
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new TestProcessorInterceptor("inner"){});
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void secondInterceptorThrowsExceptionAroundAfterProceed() throws Exception {
        final RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new TestProcessorInterceptor("outer"){});
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new TestProcessorInterceptor("inner"){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
                action.proceed();
                throw expectedException;
            }
        });
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    @Test
    public void firstInterceptorSkipsProcessor() throws Exception {
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new TestProcessorInterceptor("outer"){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
                return action.skip();
            }
        });
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new TestProcessorInterceptor("inner"){});
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        CoreEvent result = this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)""));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((CoreEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(((InternalEvent)result).getInternalParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    @Test
    public void secondInterceptorSkipsProcessor() throws Exception {
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new TestProcessorInterceptor("outer"){});
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new TestProcessorInterceptor("inner"){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
                return action.skip();
            }
        });
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        CoreEvent result = this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)""));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((CoreEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(((InternalEvent)result).getInternalParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    @Test
    public void firstInterceptorDoesntApply() throws Exception {
        final ProcessorInterceptor interceptor1 = this.prepareInterceptor(new TestProcessorInterceptor("outer"){});
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new TestProcessorInterceptor("inner"){});
        this.startFlowWithInterceptorFactories(new ProcessorInterceptorFactory(){

            public boolean intercept(ComponentLocation location) {
                return false;
            }

            public ProcessorInterceptor get() {
                return interceptor1;
            }
        }, () -> interceptor2);
        CoreEvent result = this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)""));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1, Mockito.never())).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1, Mockito.never())).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1, Mockito.never())).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(((InternalEvent)result).getInternalParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    @Test
    public void secondInterceptorDoesntApply() throws Exception {
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new TestProcessorInterceptor("outer"){});
        final ProcessorInterceptor interceptor2 = this.prepareInterceptor(new TestProcessorInterceptor("inner"){});
        this.startFlowWithInterceptorFactories(() -> interceptor1, new ProcessorInterceptorFactory(){

            public boolean intercept(ComponentLocation location) {
                return false;
            }

            public ProcessorInterceptor get() {
                return interceptor2;
            }
        });
        CoreEvent result = this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)""));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(((InternalEvent)result).getInternalParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    @Test
    public void paramWithErrorExpression() throws Exception {
        Component annotatedProcessor = (Component)this.processor;
        HashMap annotations = new HashMap(annotatedProcessor.getAnnotations());
        HashMap<String, String> params = new HashMap<String, String>((Map)annotations.get(ComponentAnnotations.ANNOTATION_PARAMETERS));
        params.put("errorExpr", "#[notAnExpression]");
        annotations.put(ComponentAnnotations.ANNOTATION_PARAMETERS, params);
        ((Component)this.processor).setAnnotations(annotations);
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){});
        this.startFlowWithInterceptors(interceptor);
        this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithErrorEntry("errorExpr", (Matcher<Throwable>)org.hamcrest.Matchers.instanceOf(ExpressionRuntimeException.class)), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithErrorEntry("errorExpr", (Matcher<Throwable>)org.hamcrest.Matchers.instanceOf(ExpressionRuntimeException.class)), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((CoreEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.any());
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    @Test
    @io.qameta.allure.Description(value="Simulates the error handling scenario for XML SDK operations")
    public void interceptorErrorResumeAround() throws Exception {
        final Exception thrown = new Exception();
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
                Mono errorMono = Mono.error((Throwable)thrown);
                return Mono.from((Publisher)((BaseEventContext)event.getContext()).error((Throwable)thrown)).then(errorMono).toFuture();
            }

            public void after(ComponentLocation location, InterceptionEvent event, Optional<Throwable> thrown2) {
            }
        });
        this.startFlowWithInterceptors(interceptor);
        this.expected.expectCause(IsSame.sameInstance((Object)thrown));
        try {
            this.process((Processor)this.flow, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build());
        }
        finally {
            if (this.useMockInterceptor) {
                new PollingProber();
                PollingProber.probe(() -> {
                    ((ProcessorInterceptor)Mockito.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(thrown)));
                    return true;
                });
            }
        }
    }

    private void verifyParametersResolvedAndDisposed(VerificationMode times) {
        if (this.processor instanceof OperationProcessorInApp) {
            ((OperationProcessorInApp)((Object)Mockito.verify((Object)((Object)((OperationProcessorInApp)this.processor)), (VerificationMode)times))).resolveParameters((CoreEvent.Builder)Matchers.any(), (BiConsumer)Matchers.any());
            ((OperationProcessorInApp)((Object)Mockito.verify((Object)((Object)((OperationProcessorInApp)this.processor)), (VerificationMode)times))).disposeResolvedParameters((ExecutionContext)Matchers.any());
        }
    }

    private void startFlowWithInterceptors(ProcessorInterceptor ... interceptors) throws Exception {
        this.processorInterceptiorManager.setInterceptorFactories(Optional.of(Arrays.asList(interceptors).stream().map(interceptionHandler -> () -> interceptionHandler).collect(Collectors.toList())));
        this.flow.initialise();
        this.flow.start();
    }

    private void startFlowWithInterceptorFactories(ProcessorInterceptorFactory ... interceptorFactories) throws Exception {
        this.processorInterceptiorManager.setInterceptorFactories(Optional.of(Arrays.asList(interceptorFactories)));
        this.flow.initialise();
        this.flow.start();
    }

    private static DefaultComponentLocation buildLocation(String componentIdentifier) {
        TypedComponentIdentifier part = TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)componentIdentifier)).type(TypedComponentIdentifier.ComponentType.OPERATION).build();
        return new DefaultComponentLocation(Optional.of("flowName"), Collections.singletonList(new DefaultComponentLocation.DefaultLocationPart("0", Optional.of(part), Optional.empty(), Optional.empty())));
    }

    private static Map<String, ProcessorParameterValue> mapArgWithEntry(String key, Object value) {
        return ReactiveInterceptorAdapterTestCase.mapArgWithEntry(key, (Matcher<ProcessorParameterValue>)new ProcessorParameterValueMatcher((Matcher<Object>)org.hamcrest.Matchers.equalTo((Object)value)));
    }

    private static Map<String, ProcessorParameterValue> mapArgWithErrorEntry(String key, Matcher<Throwable> errorMatcher) {
        return ReactiveInterceptorAdapterTestCase.mapArgWithEntry(key, (Matcher<ProcessorParameterValue>)new ProcessorParameterValueErrorMatcher(errorMatcher));
    }

    private static Map<String, ProcessorParameterValue> mapArgWithEntry(String key, Matcher<ProcessorParameterValue> valueMatcher) {
        return (Map)Matchers.argThat((Matcher)IsMapContaining.hasEntry((Matcher)org.hamcrest.Matchers.equalTo((Object)key), valueMatcher));
    }

    private static EventPayloadMatcher hasPayloadValue(Object expectedPayload) {
        return new EventPayloadMatcher((Matcher<Object>)Is.is((Object)expectedPayload));
    }

    private static InterceptionPayloadMatcher interceptionHasPayloadValue(Object expectedPayload) {
        return new InterceptionPayloadMatcher((Matcher<Object>)Is.is((Object)expectedPayload));
    }

    private class TestProcessorInterceptor
    implements ProcessorInterceptor {
        private String name;

        public TestProcessorInterceptor(String name) {
            this.name = name;
        }

        public String toString() {
            return "TestProcessorInterceptor: " + this.name;
        }
    }

    private static final class InterceptionPayloadMatcher
    extends TypeSafeMatcher<InterceptionEvent> {
        private Matcher<Object> payloadMatcher;

        public InterceptionPayloadMatcher(Matcher<Object> payloadMatcher) {
            this.payloadMatcher = payloadMatcher;
        }

        public void describeTo(Description description) {
            this.payloadMatcher.describeTo(description);
        }

        protected boolean matchesSafely(InterceptionEvent item) {
            return this.payloadMatcher.matches(item.getMessage().getPayload().getValue());
        }
    }

    private static final class EventPayloadMatcher
    extends TypeSafeMatcher<CoreEvent> {
        private Matcher<Object> payloadMatcher;

        public EventPayloadMatcher(Matcher<Object> payloadMatcher) {
            this.payloadMatcher = payloadMatcher;
        }

        public void describeTo(Description description) {
            this.payloadMatcher.describeTo(description);
        }

        protected boolean matchesSafely(CoreEvent item) {
            return this.payloadMatcher.matches(item.getMessage().getPayload().getValue());
        }
    }

    private static final class ProcessorParameterValueErrorMatcher
    extends TypeSafeMatcher<ProcessorParameterValue> {
        private Matcher<Throwable> resolutionErrorMatcher;

        public ProcessorParameterValueErrorMatcher(Matcher<Throwable> resolutionErrorMatcher) {
            this.resolutionErrorMatcher = resolutionErrorMatcher;
        }

        public void describeTo(Description description) {
            this.resolutionErrorMatcher.describeTo(description);
        }

        protected boolean matchesSafely(ProcessorParameterValue item) {
            try {
                item.resolveValue();
                return false;
            }
            catch (Throwable t) {
                return this.resolutionErrorMatcher.matches((Object)t);
            }
        }
    }

    private static final class ProcessorParameterValueMatcher
    extends TypeSafeMatcher<ProcessorParameterValue> {
        private Matcher<Object> resolvedValueMatcher;
        private Throwable thrown;

        public ProcessorParameterValueMatcher(Matcher<Object> resolvedValueMatcher) {
            this.resolvedValueMatcher = resolvedValueMatcher;
        }

        public void describeTo(Description description) {
            if (this.thrown != null) {
                description.appendText("but resolvedValue() was ");
                this.resolvedValueMatcher.describeTo(description);
            } else {
                description.appendText("but resolvedValue() threw ");
                description.appendValue((Object)this.thrown);
            }
        }

        protected boolean matchesSafely(ProcessorParameterValue item) {
            try {
                return this.resolvedValueMatcher.matches(item.resolveValue());
            }
            catch (Throwable e) {
                this.thrown = e;
                return false;
            }
        }
    }

    private static class OperationProcessorInApp
    extends AbstractComponent
    implements ParametersResolverProcessor<ComponentModel>,
    Processor {
        private final ExecutionContext executionContext = (ExecutionContext)Mockito.mock(ExecutionContext.class);

        public OperationProcessorInApp() {
            this.setAnnotations((Map)ImmutableMap.builder().put((Object)ComponentAnnotations.ANNOTATION_PARAMETERS, Collections.singletonMap("param", "#[payload]")).put((Object)LOCATION_KEY, (Object)ReactiveInterceptorAdapterTestCase.buildLocation("test:operationProcessor")).build());
        }

        public CoreEvent process(CoreEvent event) throws MuleException {
            return event;
        }

        public void disposeResolvedParameters(ExecutionContext executionContext) {
            Assert.assertThat((Object)executionContext, (Matcher)IsSame.sameInstance((Object)this.executionContext));
        }

        public void resolveParameters(CoreEvent.Builder eventBuilder, BiConsumer<Map<String, LazyValue<Object>>, ExecutionContext> afterConfigurer) {
            afterConfigurer.accept(Collections.singletonMap("operationParam", new LazyValue((Object)new ProcessorParameterValue(){

                public String parameterName() {
                    return "operationParam";
                }

                public String providedValue() {
                    return "operationParamValue";
                }

                public Object resolveValue() {
                    return "operationParamValue";
                }
            })), this.executionContext);
        }
    }

    private static class ProcessorInApp
    extends AbstractComponent
    implements Processor {
        public ProcessorInApp() {
            this.setAnnotations((Map)ImmutableMap.builder().put((Object)ComponentAnnotations.ANNOTATION_PARAMETERS, Collections.singletonMap("param", "#[payload]")).put((Object)LOCATION_KEY, (Object)ReactiveInterceptorAdapterTestCase.buildLocation("test:processor")).build());
        }

        public CoreEvent process(CoreEvent event) throws MuleException {
            return event;
        }
    }
}

