/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.simple;

import java.io.IOException;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.internal.processor.simple.ParseTemplateProcessor;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class ParseTemplateProcessorTestCase
extends AbstractMuleTestCase {
    private static final String LOCATION = "error.html";
    private static final String INVALID_LOCATION = "wrong_error.html";
    private ParseTemplateProcessor parseTemplateProcessor;
    private CoreEvent event;
    private InternalMessage mockMuleMessage = (InternalMessage)Mockito.mock(InternalMessage.class);
    private MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class);
    private ExtendedExpressionManager mockExpressionManager = (ExtendedExpressionManager)Mockito.mock(ExtendedExpressionManager.class);

    @Before
    public void setUp() throws MuleException {
        this.event = this.getEventBuilder().message((Message)this.mockMuleMessage).build();
        this.parseTemplateProcessor = new ParseTemplateProcessor();
        this.parseTemplateProcessor.setMuleContext(this.mockMuleContext);
        Mockito.when((Object)this.mockMuleContext.getExpressionManager()).thenReturn((Object)this.mockExpressionManager);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseTemplateNullTemplate() throws InitialisationException {
        this.parseTemplateProcessor.setLocation(LOCATION);
        this.parseTemplateProcessor.process(this.event);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseTemplateNullLocation() throws InitialisationException {
        this.parseTemplateProcessor.setLocation(null);
        this.parseTemplateProcessor.initialise();
        this.parseTemplateProcessor.process(this.event);
    }

    @Test(expected=InitialisationException.class)
    public void testParseTemplateInvalidLocation() throws InitialisationException {
        this.parseTemplateProcessor.setLocation(INVALID_LOCATION);
        this.addMockComponentLocation((Component)this.parseTemplateProcessor);
        this.parseTemplateProcessor.initialise();
        this.parseTemplateProcessor.process(this.event);
    }

    @Test(expected=InitialisationException.class)
    public void testParseTemplateWithBothLocationAndContentDefined() throws InitialisationException {
        this.parseTemplateProcessor.setLocation(LOCATION);
        this.parseTemplateProcessor.setContent("SOME CONTENT");
        this.addMockComponentLocation((Component)this.parseTemplateProcessor);
        this.parseTemplateProcessor.initialise();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseTemplateNullContent() throws InitialisationException {
        this.parseTemplateProcessor.initialise();
        this.parseTemplateProcessor.process(this.event);
    }

    @Test
    public void testParseTemplateFromLocation() throws InitialisationException, IOException {
        this.parseTemplateProcessor.setLocation(LOCATION);
        this.parseTemplateProcessor.initialise();
        Mockito.when((Object)this.mockMuleMessage.getInboundProperty("errorMessage")).thenReturn((Object)"ERROR!!!");
        String expectedExpression = IOUtils.getResourceAsString((String)LOCATION, ((Object)((Object)this)).getClass());
        Mockito.when((Object)this.mockMuleMessage.getPayload()).thenReturn((Object)TypedValue.of((Object)"Parsed"));
        Mockito.when((Object)this.mockMuleMessage.getAttributes()).thenReturn((Object)TypedValue.of(new HashMap()));
        Mockito.when((Object)this.mockExpressionManager.parseLogTemplate((String)Matchers.eq((Object)expectedExpression), (CoreEvent)Matchers.eq((Object)this.event), (ComponentLocation)Matchers.any(), (BindingContext)Matchers.any())).thenReturn((Object)"Parsed");
        CoreEvent response = this.parseTemplateProcessor.process(this.event);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)"Parsed", (Object)response.getMessage().getPayload().getValue());
        response = this.parseTemplateProcessor.process(this.event);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)"Parsed", (Object)response.getMessage().getPayload().getValue());
    }

    @Test
    public void testParseTemplateFromContent() throws InitialisationException {
        String template = "This is a template";
        this.parseTemplateProcessor.setContent(template);
        this.parseTemplateProcessor.initialise();
        Mockito.when((Object)this.mockMuleMessage.getPayload()).thenReturn((Object)TypedValue.of((Object)template));
        Mockito.when((Object)this.mockMuleMessage.getAttributes()).thenReturn((Object)TypedValue.of(new HashMap()));
        Mockito.when((Object)this.mockExpressionManager.parseLogTemplate((String)Matchers.eq((Object)template), (CoreEvent)Matchers.eq((Object)this.event), (ComponentLocation)Matchers.any(), (BindingContext)Matchers.any())).thenReturn((Object)template);
        CoreEvent response = this.parseTemplateProcessor.process(this.event);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)template, (Object)response.getMessage().getPayload().getValue());
        response = this.parseTemplateProcessor.process(this.event);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)template, (Object)response.getMessage().getPayload().getValue());
    }

    @Test
    public void testParseTemplateToTarget() throws InitialisationException {
        String payload = "Payload";
        String template = "Template";
        this.parseTemplateProcessor.setContent(template);
        this.parseTemplateProcessor.setTarget("some_target_variable");
        this.parseTemplateProcessor.initialise();
        Mockito.when((Object)this.mockMuleMessage.getPayload()).thenReturn((Object)TypedValue.of((Object)payload));
        Mockito.when((Object)this.mockMuleMessage.getAttributes()).thenReturn((Object)TypedValue.of(new HashMap()));
        Mockito.when((Object)this.mockExpressionManager.parseLogTemplate((String)Matchers.any(), (CoreEvent)Matchers.any(), (ComponentLocation)Matchers.any(), (BindingContext)Matchers.any())).thenReturn((Object)"Parsed");
        CoreEvent response = this.parseTemplateProcessor.process(this.event);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)payload, (Object)response.getMessage().getPayload().getValue());
        Assert.assertEquals((Object)"Parsed", (Object)((Message)((TypedValue)response.getVariables().get("some_target_variable")).getValue()).getPayload().getValue());
    }
}

