/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.processor.strategy.AbstractProcessingStrategyTestCase;
import org.mule.runtime.core.internal.processor.strategy.BlockingProcessingStrategyFactory;
import org.mule.runtime.core.internal.processor.strategy.DirectProcessingStrategyTestCase;

@Feature(value="Processing Strategies")
@Story(value="Blocking")
public class BlockingProcessingStrategyTestCase
extends DirectProcessingStrategyTestCase {
    public BlockingProcessingStrategyTestCase(AbstractProcessingStrategyTestCase.Mode mode) {
        super(mode);
    }

    @Override
    protected ProcessingStrategy createProcessingStrategy(MuleContext muleContext, String schedulersNamePrefix) {
        return BlockingProcessingStrategyFactory.BLOCKING_PROCESSING_STRATEGY_INSTANCE;
    }

    @Override
    @Description(value="Regardless of processor type, when the BlockingProcessingStrategy is configured, the pipeline is executed synchronously in a caller thread and the pipeline will block caller thread until any async processors complete before continuing in the caller thread.")
    public void asyncCpuLight() throws Exception {
        super.asyncCpuLight();
    }

    @Override
    protected void assertAsyncCpuLight() {
        this.assertSynchronous(1);
    }

    @Override
    @Description(value="Regardless of processor type, when the BlockingProcessingStrategy is configured, the pipeline is executed synchronously in a caller thread and the pipeline will block caller thread until any async processors complete before continuing in the caller thread.")
    public void asyncCpuLightConcurrent() throws Exception {
        this.internalConcurrent((Flow.Builder)this.flowBuilder.get(), false, ReactiveProcessor.ProcessingType.CPU_LITE, 1, this.asyncProcessor);
        this.assertSynchronous(2);
    }
}

