/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Test;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.processor.strategy.AbstractProcessingStrategyTestCase;
import org.mule.runtime.core.internal.processor.strategy.DirectProcessingStrategyFactory;
import org.mule.tck.testmodels.mule.TestTransaction;

@Feature(value="Processing Strategies")
@Story(value="Direct")
public class DirectProcessingStrategyTestCase
extends AbstractProcessingStrategyTestCase {
    public DirectProcessingStrategyTestCase(AbstractProcessingStrategyTestCase.Mode mode) {
        super(mode);
    }

    @Override
    protected ProcessingStrategy createProcessingStrategy(MuleContext muleContext, String schedulersNamePrefix) {
        return new DirectProcessingStrategyFactory().create(muleContext, schedulersNamePrefix);
    }

    @Override
    @Description(value="Regardless of processor type, when the DirectProcessingStrategy is configured, the pipeline is executed synchronously in a caller thread.")
    public void singleCpuLight() throws Exception {
        super.singleCpuLight();
        this.assertSynchronous(1);
    }

    @Override
    @Description(value="Regardless of processor type, when the DirectProcessingStrategy is configured, the pipeline is executed synchronously in a caller thread.")
    public void singleCpuLightConcurrent() throws Exception {
        super.internalConcurrent((Flow.Builder)this.flowBuilder.get(), false, ReactiveProcessor.ProcessingType.CPU_LITE, 1, new Processor[0]);
        this.assertSynchronous(2);
    }

    @Override
    @Description(value="Regardless of processor type, when the DirectProcessingStrategy is configured, the pipeline is executed synchronously in a caller thread.")
    public void multipleCpuLight() throws Exception {
        super.multipleCpuLight();
        this.assertSynchronous(1);
    }

    @Override
    @Description(value="Regardless of processor type, when the DirectProcessingStrategy is configured, the pipeline is executed synchronously in a caller thread.")
    public void singleBlocking() throws Exception {
        super.singleBlocking();
        this.assertSynchronous(1);
    }

    @Override
    @Description(value="Regardless of processor type, when the DirectProcessingStrategy is configured, the pipeline is executed synchronously in a caller thread.")
    public void multipleBlocking() throws Exception {
        super.multipleBlocking();
        this.assertSynchronous(1);
    }

    @Override
    @Description(value="Regardless of processor type, when the DirectProcessingStrategy is configured, the pipeline is executed synchronously in a caller thread.")
    public void singleCpuIntensive() throws Exception {
        super.singleCpuIntensive();
        this.assertSynchronous(1);
    }

    @Override
    @Description(value="Regardless of processor type, when the DirectProcessingStrategy is configured, the pipeline is executed synchronously in a caller thread.")
    public void multipleCpuIntensive() throws Exception {
        super.multipleCpuIntensive();
        this.assertSynchronous(1);
    }

    @Override
    @Description(value="Regardless of processor type, when the DirectProcessingStrategy is configured, the pipeline is executed synchronously in a caller thread.")
    public void mix() throws Exception {
        super.mix();
        this.assertSynchronous(1);
    }

    @Override
    @Description(value="Regardless of processor type, when the DirectProcessingStrategy is configured, the pipeline is executed synchronously in a caller thread.")
    public void mix2() throws Exception {
        super.mix2();
        this.assertSynchronous(1);
    }

    @Override
    @Description(value="Regardless of processor type, when the DirectProcessingStrategy is configured, the pipeline is executed synchronously in a caller thread.")
    public void tx() throws Exception {
        this.flow = ((Flow.Builder)this.flowBuilder.get()).processors(new Processor[]{this.cpuLightProcessor, this.cpuIntensiveProcessor, this.blockingProcessor}).build();
        this.flow.initialise();
        this.flow.start();
        TransactionCoordination.getInstance().bindTransaction((Transaction)new TestTransaction(muleContext));
        this.processFlow(this.testEvent());
        this.assertSynchronous(1);
    }

    @Override
    @Description(value="Regardless of processor type, when the DirectProcessingStrategy is configured, the pipeline is executed synchronously in a caller thread but async processors will cause additional threads to be used. Flow processing continues using async processor thread.")
    public void asyncCpuLight() throws Exception {
        super.asyncCpuLight();
        this.assertAsyncCpuLight();
    }

    @Test
    @Description(value="Regardless of processor type, when the DirectProcessingStrategy is configured, the pipeline is executed synchronously in a caller thread.")
    public void singleIORW() throws Exception {
        super.singleIORW(() -> this.testEvent());
        this.assertSynchronous(1);
    }

    @Override
    @Description(value="When using DirectProcessingStrategy continued processing is carried out using async processor thread which can cause processing to block if there are concurrent requests and the number of custom async processor threads are reduced")
    public void asyncCpuLightConcurrent() throws Exception {
        this.internalConcurrent((Flow.Builder)this.flowBuilder.get(), true, ReactiveProcessor.ProcessingType.CPU_LITE, 4, this.asyncProcessor);
        MatcherAssert.assertThat((Object)this.threads.size(), DirectProcessingStrategyTestCase.between(2, 9));
        MatcherAssert.assertThat((Object)this.threads, (Matcher)CoreMatchers.not((Matcher)IsCollectionContaining.hasItem((Matcher)Matchers.startsWith((String)"cpuLight"))));
        MatcherAssert.assertThat((Object)this.threads, (Matcher)CoreMatchers.not((Matcher)IsCollectionContaining.hasItem((Matcher)Matchers.startsWith((String)"I/O"))));
        MatcherAssert.assertThat((Object)this.threads, (Matcher)CoreMatchers.not((Matcher)IsCollectionContaining.hasItem((Matcher)Matchers.startsWith((String)"cpuIntensive"))));
        MatcherAssert.assertThat((Object)this.threads.stream().filter(name -> name.startsWith("custom")).count(), (Matcher)CoreMatchers.equalTo((Object)4L));
    }

    protected void assertAsyncCpuLight() {
        MatcherAssert.assertThat((Object)this.threads, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)this.threads, (Matcher)CoreMatchers.not((Matcher)IsCollectionContaining.hasItem((Matcher)Matchers.startsWith((String)"cpuLight"))));
        MatcherAssert.assertThat((Object)this.threads, (Matcher)CoreMatchers.not((Matcher)IsCollectionContaining.hasItem((Matcher)Matchers.startsWith((String)"I/O"))));
        MatcherAssert.assertThat((Object)this.threads, (Matcher)CoreMatchers.not((Matcher)IsCollectionContaining.hasItem((Matcher)Matchers.startsWith((String)"cpuIntensive"))));
        MatcherAssert.assertThat((Object)this.threads.stream().filter(name -> name.startsWith("custom")).count(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    protected void assertSynchronous(int concurrency) {
        MatcherAssert.assertThat((Object)this.threads, (Matcher)Matchers.hasSize((int)concurrency));
        MatcherAssert.assertThat((Object)this.threads, (Matcher)CoreMatchers.not((Matcher)IsCollectionContaining.hasItem((Matcher)Matchers.startsWith((String)"cpuLight"))));
        MatcherAssert.assertThat((Object)this.threads, (Matcher)CoreMatchers.not((Matcher)IsCollectionContaining.hasItem((Matcher)Matchers.startsWith((String)"I/O"))));
        MatcherAssert.assertThat((Object)this.threads, (Matcher)CoreMatchers.not((Matcher)IsCollectionContaining.hasItem((Matcher)Matchers.startsWith((String)"cpuIntensive"))));
        MatcherAssert.assertThat((Object)this.threads, (Matcher)CoreMatchers.not((Matcher)IsCollectionContaining.hasItem((Matcher)Matchers.startsWith((String)"custom"))));
    }
}

