/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.internal.processor.strategy.AbstractProcessingStrategy;
import org.mule.runtime.core.internal.processor.strategy.AbstractProcessingStrategyFactory;
import org.mule.runtime.core.internal.processor.strategy.TransactionAwareProactorStreamProcessingStrategyFactory;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.util.MuleContextUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class FlowProcessingStrategyTestCase
extends AbstractMuleTestCase {
    protected MuleContext muleContext = MuleContextUtils.mockContextWithServices();
    @Mock
    private MuleConfiguration configuration;
    private Flow flow;

    @Before
    public void before() throws RegistrationException {
        Mockito.when((Object)this.muleContext.getConfiguration()).thenReturn((Object)this.configuration);
        this.createFlow(null);
    }

    @Test
    public void fixedProcessingStrategyIsHonoured() throws Exception {
        ProcessingStrategyFactory processingStrategyFactory = (ProcessingStrategyFactory)Mockito.mock(ProcessingStrategyFactory.class);
        ProcessingStrategy processingStrategy = (ProcessingStrategy)Mockito.mock(ProcessingStrategy.class);
        Mockito.when((Object)processingStrategyFactory.create((MuleContext)Matchers.any(), (String)Matchers.any())).thenReturn((Object)processingStrategy);
        this.createFlow(processingStrategyFactory);
        this.flow.initialise();
        Assert.assertThat((Object)this.flow.getProcessingStrategy(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)processingStrategy)));
    }

    @Test
    public void defaultProcessingStrategyInConfigIsHonoured() throws Exception {
        ProcessingStrategy processingStrategy = (ProcessingStrategy)Mockito.mock(ProcessingStrategy.class);
        ProcessingStrategyFactory processingStrategyFactory = (ProcessingStrategyFactory)Mockito.mock(ProcessingStrategyFactory.class);
        Mockito.when((Object)processingStrategyFactory.create((MuleContext)Matchers.any(), (String)Matchers.any())).thenReturn((Object)processingStrategy);
        Mockito.when((Object)this.configuration.getDefaultProcessingStrategyFactory()).thenReturn((Object)processingStrategyFactory);
        this.createFlow(null);
        this.flow.initialise();
        Assert.assertThat((Object)this.flow.getProcessingStrategy(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)processingStrategy)));
    }

    @Test
    public void fixedProcessingStrategyTakesPrecedenceOverConfig() throws Exception {
        ProcessingStrategyFactory configProcessingStrategyFactory = (ProcessingStrategyFactory)Mockito.mock(ProcessingStrategyFactory.class);
        Mockito.when((Object)this.configuration.getDefaultProcessingStrategyFactory()).thenReturn((Object)configProcessingStrategyFactory);
        ProcessingStrategyFactory processingStrategyFactory = (ProcessingStrategyFactory)Mockito.mock(ProcessingStrategyFactory.class);
        ProcessingStrategy processingStrategy = (ProcessingStrategy)Mockito.mock(ProcessingStrategy.class);
        Mockito.when((Object)processingStrategyFactory.create((MuleContext)Matchers.any(), (String)Matchers.any())).thenReturn((Object)processingStrategy);
        this.createFlow(processingStrategyFactory);
        this.flow.initialise();
        Assert.assertThat((Object)this.flow.getProcessingStrategy(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)processingStrategy)));
    }

    @Test
    public void createDefaultProcessingStrategyIfNoneSpecified() throws Exception {
        this.flow.initialise();
        Assert.assertThat((Object)this.flow.getProcessingStrategy(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf((Class)new TransactionAwareProactorStreamProcessingStrategyFactory().getProcessingStrategyType())));
    }

    @Test
    public void processingStrategySetBySystemPropertyOverridesDefault() throws Exception {
        MuleTestUtils.testWithSystemProperty((String)ProcessingStrategyFactory.class.getName(), (String)TestProcessingStrategyFactory.class.getName(), () -> {
            DefaultMuleConfiguration muleConfiguration = new DefaultMuleConfiguration();
            Mockito.when((Object)this.muleContext.getConfiguration()).thenReturn((Object)muleConfiguration);
            this.createFlow(null);
            Assert.assertEquals(this.flow.getProcessingStrategy().getClass(), TestProcessingStrategy.class);
        });
    }

    private void createFlow(ProcessingStrategyFactory configProcessingStrategyFactory) {
        Flow.Builder flowBuilder = Flow.builder((String)"test", (MuleContext)this.muleContext);
        if (configProcessingStrategyFactory != null) {
            flowBuilder = flowBuilder.processingStrategyFactory(configProcessingStrategyFactory);
        }
        this.flow = flowBuilder.build();
    }

    private static class TestProcessingStrategy
    extends AbstractProcessingStrategy {
        private TestProcessingStrategy() {
        }
    }

    public static class TestProcessingStrategyFactory
    extends AbstractProcessingStrategyFactory {
        public ProcessingStrategy create(MuleContext muleContext, String schedulersNamePrefix) {
            return new TestProcessingStrategy();
        }
    }
}

