/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.runtime.core.internal.processor.strategy.AbstractStreamProcessingStrategyFactory;
import org.mule.runtime.core.internal.processor.strategy.ProactorStreamProcessingStrategyFactory;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

@Feature(value="Processing Strategies")
@Story(value="Proactor")
public class ProactorStreamProcessingStrategyFactoryTestCase
extends AbstractMuleContextTestCase {
    private ProactorStreamProcessingStrategyFactory processingStrategy = new ProactorStreamProcessingStrategyFactory();

    @Test
    @Description(value="Number of CPU Light threads is limited to number of cores when max concurrency is MAX_VALUE.")
    public void cpuLightCountUnlimitedConcurrency() {
        MatcherAssert.assertThat((Object)this.processingStrategy.resolveParallelism(), (Matcher)CoreMatchers.equalTo((Object)Math.max(AbstractStreamProcessingStrategyFactory.CORES / AbstractStreamProcessingStrategyFactory.DEFAULT_SUBSCRIBER_COUNT, 1)));
    }

    @Test
    @Ignore(value="MULE-14522")
    @Description(value="Number of CPU Light threads is limited by max concurrency.")
    public void cpuLightCountMaxConcurrency2() {
        this.processingStrategy.setMaxConcurrency(2);
        MatcherAssert.assertThat((Object)this.processingStrategy.resolveParallelism(), (Matcher)CoreMatchers.equalTo((Object)Math.min(2, AbstractStreamProcessingStrategyFactory.CORES)));
    }

    @Test
    @Ignore(value="MULE-14522")
    @Description(value="Number of CPU Light threads is limited to number to a factor of maxConcurrency less than number of cores.")
    public void cpuLightCountMaxConcurrency9() {
        this.processingStrategy.setMaxConcurrency(9);
        if (AbstractStreamProcessingStrategyFactory.CORES >= 3) {
            MatcherAssert.assertThat((Object)this.processingStrategy.resolveParallelism(), (Matcher)CoreMatchers.equalTo((Object)3));
        } else {
            MatcherAssert.assertThat((Object)this.processingStrategy.resolveParallelism(), (Matcher)CoreMatchers.equalTo((Object)1));
        }
    }

    @Test
    @Ignore(value="MULE-14522")
    @Description(value="Number of CPU Light threads used considers the number of subscribers")
    public void cpuLightCountMaxConcurrency2SubscriberCount2() {
        this.processingStrategy.setMaxConcurrency(2);
        this.processingStrategy.setSubscriberCount(2);
        MatcherAssert.assertThat((Object)this.processingStrategy.resolveParallelism(), (Matcher)CoreMatchers.equalTo((Object)1));
    }
}

