/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy.processor;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.deployment.management.ComponentInitialStateManager;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.mule.runtime.api.notification.ErrorHandlerNotification;
import org.mule.runtime.api.notification.FlowConstructNotification;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.notification.PipelineMessageNotification;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.management.stats.AllStatistics;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.strategy.AsyncProcessingStrategyFactory;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.internal.construct.DefaultFlowBuilder;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.exception.ErrorHandler;
import org.mule.runtime.core.internal.exception.ErrorHandlerFactory;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.privileged.PrivilegedMuleContext;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.core.privileged.processor.InternalProcessor;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.transformer.ExtendedTransformationService;
import org.mule.tck.junit4.AbstractReactiveProcessorTestCase;
import org.mule.tck.util.MuleContextUtils;

@RunWith(value=Parameterized.class)
public class PipelineMessageNotificationTestCase
extends AbstractReactiveProcessorTestCase {
    private CoreEvent event;
    private NotificationDispatcher notificationFirer;
    private TestPipeline pipeline;
    private final String pipelineName = "testPipeline";
    private EventContext context;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    public PipelineMessageNotificationTestCase(AbstractReactiveProcessorTestCase.Mode mode) {
        super(mode);
    }

    @Before
    public void createMocks() throws Exception {
        muleContext.dispose();
        muleContext = MuleContextUtils.mockContextWithServices();
        Mockito.when((Object)muleContext.getStatistics()).thenReturn((Object)new AllStatistics());
        Mockito.when((Object)muleContext.getConfiguration()).thenReturn((Object)new DefaultMuleConfiguration());
        this.notificationFirer = (NotificationDispatcher)((MuleContextWithRegistries)muleContext).getRegistry().lookupObject(NotificationDispatcher.class);
        Mockito.when((Object)muleContext.getDefaultErrorHandler(Optional.empty())).thenReturn((Object)new ErrorHandlerFactory().createDefault(this.notificationFirer));
        this.mockErrorTypeLocator();
        Mockito.when((Object)muleContext.getTransformationService()).thenReturn((Object)new ExtendedTransformationService(muleContext));
    }

    private void mockErrorTypeLocator() {
        ErrorTypeLocator typeLocator = (ErrorTypeLocator)Mockito.mock(ErrorTypeLocator.class);
        ErrorType errorType = (ErrorType)Mockito.mock(ErrorType.class);
        Mockito.when((Object)errorType.getIdentifier()).thenReturn((Object)"ID");
        Mockito.when((Object)errorType.getNamespace()).thenReturn((Object)"NS");
        Mockito.when((Object)typeLocator.lookupErrorType((Throwable)Matchers.any(Throwable.class))).thenReturn((Object)errorType);
        Mockito.when((Object)typeLocator.lookupComponentErrorType((ComponentIdentifier)Matchers.any(ComponentIdentifier.class), (Throwable)Matchers.any(Throwable.class))).thenReturn((Object)errorType);
        Mockito.when((Object)((PrivilegedMuleContext)muleContext).getErrorTypeLocator()).thenReturn((Object)typeLocator);
    }

    public void createTestPipeline(List<Processor> processors, ErrorHandler errorHandler) {
        this.pipeline = new TestPipeline("testPipeline", muleContext, null, processors, errorHandler);
        this.context = EventContextFactory.create((FlowConstruct)this.pipeline, (ComponentLocation)TEST_CONNECTOR_LOCATION);
    }

    @After
    public void after() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)((Object)this.pipeline));
        LifecycleUtils.stopIfNeeded((Object)muleContext.getSchedulerService());
    }

    @Test
    public void send() throws Exception {
        this.createTestPipeline(Collections.emptyList(), null);
        this.pipeline.initialise();
        this.pipeline.start();
        this.event = InternalEvent.builder((EventContext)this.context).message(Message.of((Object)"request")).build();
        this.process((Processor)this.pipeline, this.event);
        this.verifySucess();
    }

    @Test
    public void requestResponseException() throws Exception {
        this.createTestPipeline(Collections.singletonList(new ExceptionThrowingMessageProcessor()), new ErrorHandlerFactory().createDefault(this.notificationFirer));
        this.pipeline.initialise();
        this.pipeline.start();
        this.event = InternalEvent.builder((EventContext)this.context).message(Message.of((Object)"request")).build();
        this.thrown.expect(CoreMatchers.instanceOf(MessagingException.class));
        this.thrown.expectCause(CoreMatchers.instanceOf(IllegalStateException.class));
        try {
            this.process((Processor)this.pipeline, this.event);
        }
        finally {
            this.verifyException();
        }
    }

    private void verifySucess() {
        ((NotificationDispatcher)Mockito.verify((Object)this.notificationFirer, (VerificationMode)Mockito.times((int)2))).dispatch((Notification)Matchers.argThat((Matcher)CoreMatchers.instanceOf(FlowConstructNotification.class)));
        ((NotificationDispatcher)Mockito.verify((Object)this.notificationFirer, (VerificationMode)Mockito.times((int)1))).dispatch((Notification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1801, false, this.event)));
        ((NotificationDispatcher)Mockito.verify((Object)this.notificationFirer, (VerificationMode)Mockito.times((int)1))).dispatch((Notification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1802, false, this.event)));
        ((NotificationDispatcher)Mockito.verify((Object)this.notificationFirer, (VerificationMode)Mockito.times((int)1))).dispatch((Notification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1804, false, this.event)));
        ((NotificationDispatcher)Mockito.verify((Object)this.notificationFirer, (VerificationMode)Mockito.times((int)3))).dispatch((Notification)Matchers.argThat((Matcher)CoreMatchers.instanceOf(PipelineMessageNotification.class)));
    }

    private void verifyException() {
        ((NotificationDispatcher)Mockito.verify((Object)this.notificationFirer, (VerificationMode)Mockito.times((int)2))).dispatch((Notification)Matchers.argThat((Matcher)CoreMatchers.instanceOf(FlowConstructNotification.class)));
        ((NotificationDispatcher)Mockito.verify((Object)this.notificationFirer, (VerificationMode)Mockito.times((int)2))).dispatch((Notification)Matchers.argThat((Matcher)CoreMatchers.instanceOf(PipelineMessageNotification.class)));
        ((NotificationDispatcher)Mockito.verify((Object)this.notificationFirer, (VerificationMode)Mockito.times((int)2))).dispatch((Notification)Matchers.argThat((Matcher)CoreMatchers.instanceOf(ErrorHandlerNotification.class)));
        ((NotificationDispatcher)Mockito.verify((Object)this.notificationFirer, (VerificationMode)Mockito.times((int)1))).dispatch((Notification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1801, false, this.event)));
        ((NotificationDispatcher)Mockito.verify((Object)this.notificationFirer, (VerificationMode)Mockito.times((int)1))).dispatch((Notification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1804, true, null)));
        ((NotificationDispatcher)Mockito.verify((Object)this.notificationFirer, (VerificationMode)Mockito.times((int)1))).dispatch((Notification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(2001, true, this.event)));
        ((NotificationDispatcher)Mockito.verify((Object)this.notificationFirer, (VerificationMode)Mockito.times((int)1))).dispatch((Notification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(2002, true, this.event)));
    }

    public static class ExceptionThrowingMessageProcessor
    implements Processor,
    InternalProcessor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            throw new IllegalStateException();
        }
    }

    private class PipelineMessageNotificiationArgumentMatcher
    extends ArgumentMatcher<Notification> {
        private int expectedAction;
        private boolean exceptionExpected;
        private CoreEvent event;

        public PipelineMessageNotificiationArgumentMatcher(int expectedAction, boolean exceptionExpected, CoreEvent event) {
            this.expectedAction = expectedAction;
            this.exceptionExpected = exceptionExpected;
            this.event = event;
        }

        public boolean matches(Object argument) {
            if (!(argument instanceof PipelineMessageNotification) && !(argument instanceof ErrorHandlerNotification)) {
                return false;
            }
            EnrichedServerNotification notification = (EnrichedServerNotification)argument;
            Exception exception = notification.getException();
            boolean result = this.expectedAction == notification.getAction().getActionId() && notification.getEvent() == null == (this.event == null) && (this.event == null || this.event.getMessage().getPayload().equals((Object)notification.getEvent().getMessage().getPayload()) && this.event.getMessage().getAttributes().equals((Object)notification.getEvent().getMessage().getAttributes())) && this.exceptionExpected == (exception != null);
            return result;
        }

        public void describeTo(Description description) {
            super.describeTo(description);
            description.appendText(String.format("expectedAction = %d, exceptionExpected = %s, event = %s", this.expectedAction, this.exceptionExpected, this.event));
        }
    }

    private class TestPipeline
    extends DefaultFlowBuilder.DefaultFlow {
        CountDownLatch latch;

        public TestPipeline(String name, MuleContext muleContext, MessageSource messageSource, List<Processor> messageProcessors, ErrorHandler errorHandler) {
            super(name, muleContext, messageSource, messageProcessors, Optional.ofNullable(errorHandler), Optional.empty(), "started", AsyncProcessingStrategyFactory.DEFAULT_MAX_CONCURRENCY, TestPipeline.createFlowStatistics((String)name, (MuleContext)muleContext), new ComponentInitialStateManager(){

                public boolean mustStartMessageSource(Component component) {
                    return true;
                }
            });
            this.latch = new CountDownLatch(2);
        }

        protected void configureMessageProcessors(MessageProcessorChainBuilder builder) throws MuleException {
            builder.chain(new Processor[]{event -> {
                this.latch.countDown();
                return event;
            }});
            super.configureMessageProcessors(builder);
            builder.chain(new Processor[]{event -> {
                this.latch.countDown();
                return event;
            }});
        }

        public String getConstructType() {
            return "test";
        }
    }
}

