/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.registry;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.builders.AbstractConfigurationBuilder;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.internal.context.DefaultMuleContext;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.registry.MuleRegistry;
import org.mule.runtime.core.internal.registry.MuleRegistryHelper;
import org.mule.runtime.core.internal.registry.TransformerResolver;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class ConvertersNotRegisteredTwiceTestCase
extends AbstractMuleContextTestCase {
    private MuleRegistryHelper registryHelper;

    protected void addBuilders(List<ConfigurationBuilder> builders) {
        super.addBuilders(builders);
        builders.add(0, (ConfigurationBuilder)new AbstractConfigurationBuilder(){

            protected void doConfigure(MuleContext muleContext) throws Exception {
                ConvertersNotRegisteredTwiceTestCase.this.registryHelper = (MuleRegistryHelper)((MuleContextWithRegistries)muleContext).getRegistry();
                ConvertersNotRegisteredTwiceTestCase.this.registryHelper = (MuleRegistryHelper)Mockito.spy((Object)ConvertersNotRegisteredTwiceTestCase.this.registryHelper);
                ((DefaultMuleContext)muleContext).setMuleRegistry((MuleRegistry)ConvertersNotRegisteredTwiceTestCase.this.registryHelper);
            }
        });
    }

    @Test
    public void noDuplicates() {
        ArgumentCaptor transformerResolverCaptor = ArgumentCaptor.forClass(TransformerResolver.class);
        ((MuleRegistryHelper)Mockito.verify((Object)this.registryHelper, (VerificationMode)Mockito.atLeastOnce())).registerTransformerResolver((TransformerResolver)transformerResolverCaptor.capture());
        this.assertNoDuplicatesNorEmpty(transformerResolverCaptor.getAllValues());
        ArgumentCaptor converterArgumentCaptor = ArgumentCaptor.forClass(Converter.class);
        ((MuleRegistryHelper)Mockito.verify((Object)this.registryHelper, (VerificationMode)Mockito.atLeastOnce())).notifyTransformerResolvers((Transformer)converterArgumentCaptor.capture(), (TransformerResolver.RegistryAction)org.mockito.Matchers.same((Object)TransformerResolver.RegistryAction.ADDED));
        this.assertNoDuplicatesNorEmpty(converterArgumentCaptor.getAllValues());
    }

    private <T> void assertNoDuplicatesNorEmpty(Collection<T> collection) {
        Assert.assertThat(collection, (Matcher)CoreMatchers.is((Matcher)Matchers.not((Matcher)IsEmptyCollection.empty())));
        HashSet<T> noDuplicates = new HashSet<T>(collection);
        Assert.assertThat(noDuplicates, (Matcher)IsCollectionWithSize.hasSize((int)collection.size()));
    }
}

