/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.registry;

import java.util.HashMap;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.registry.TestLifecycleObject;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class ManuallyRegisteredObjectLifecycleTestCase
extends AbstractMuleContextTestCase {
    private static final String INITIALISABLE = "initialisable";
    private static final String STARTABLE = "startable";

    public ManuallyRegisteredObjectLifecycleTestCase() {
        this.setStartContext(true);
    }

    protected Map<String, Object> getStartUpRegistryObjects() {
        HashMap<String, Object> registryObjects = new HashMap<String, Object>();
        registryObjects.put("TestInitialisableObject", new TestInitialisableObject());
        registryObjects.put("TestStartableObject", new TestStartableObject());
        return registryObjects;
    }

    @Test
    public void manuallyRegisteredStartableLifecycle() throws Exception {
        this.assertLifecycle(STARTABLE);
    }

    @Test
    public void manuallyRegisteredInitialisableLifecycle() throws Exception {
        this.assertLifecycle(INITIALISABLE);
    }

    private void assertLifecycle(String key) {
        TestLifecycleObject testLifecycleObject = (TestLifecycleObject)((MuleContextWithRegistries)muleContext).getRegistry().get(key);
        Assert.assertThat((Object)testLifecycleObject, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)testLifecycleObject.getInitialise(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)testLifecycleObject.getStart(), (Matcher)CoreMatchers.is((Object)1));
    }

    private class TestInitialisableObject
    extends RegisteringObject
    implements Initialisable {
        private TestInitialisableObject() {
        }

        public void initialise() throws InitialisationException {
            try {
                this.manuallyRegisterObject();
            }
            catch (MuleException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }

        @Override
        protected String getKey() {
            return ManuallyRegisteredObjectLifecycleTestCase.INITIALISABLE;
        }
    }

    private class TestStartableObject
    extends RegisteringObject
    implements Startable {
        private TestStartableObject() {
        }

        public void start() throws MuleException {
            this.manuallyRegisterObject();
        }

        @Override
        protected String getKey() {
            return ManuallyRegisteredObjectLifecycleTestCase.STARTABLE;
        }
    }

    private abstract class RegisteringObject
    implements MuleContextAware {
        private MuleContext muleContext;

        private RegisteringObject() {
        }

        public void setMuleContext(MuleContext muleContext) {
            this.muleContext = muleContext;
        }

        protected void manuallyRegisterObject() throws MuleException {
            TestLifecycleObject o = new TestLifecycleObject();
            ((MuleContextWithRegistries)this.muleContext).getRegistry().registerObject(this.getKey(), (Object)o);
        }

        protected abstract String getKey();
    }
}

