/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.registry;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.transformer.builder.MockConverterBuilder;
import org.mule.runtime.core.privileged.transformer.CompositeConverter;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.BloodOrange;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.tck.testmodels.fruit.Peach;
import org.mule.tck.testmodels.fruit.Seed;

public class MuleRegistryHelperTestCase
extends AbstractMuleContextTestCase {
    private static final DataType ORANGE_DATA_TYPE = DataType.fromType(Orange.class);
    private static final DataType BLOOD_ORANGE_DATA_TYPE = DataType.fromType(BloodOrange.class);
    private static final DataType FRUIT_DATA_TYPE = DataType.fromType(Fruit.class);
    private static final DataType PEACH_DATA_TYPE = DataType.fromType(Peach.class);
    private static final DataType SEED_DATA_TYPE = DataType.fromType(Seed.class);
    private static final DataType APPLE_DATA_TYPE = DataType.fromType(Apple.class);
    private static final DataType BANANA_DATA_TYPE = DataType.fromType(Banana.class);
    private Transformer t1;
    private Transformer t2;

    @Before
    public void setUp() throws Exception {
        this.t1 = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("t1")).from(ORANGE_DATA_TYPE)).to(FRUIT_DATA_TYPE)).build();
        ((MuleContextWithRegistries)muleContext).getRegistry().registerTransformer(this.t1);
        this.t2 = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("t2")).from(DataType.OBJECT)).to(FRUIT_DATA_TYPE)).build();
        ((MuleContextWithRegistries)muleContext).getRegistry().registerTransformer(this.t2);
    }

    @Test
    public void lookupsTransformersByType() throws Exception {
        List trans = ((MuleContextWithRegistries)muleContext).getRegistry().lookupTransformers(BLOOD_ORANGE_DATA_TYPE, FRUIT_DATA_TYPE);
        Assert.assertEquals((long)2L, (long)trans.size());
        Assert.assertTrue((boolean)trans.contains(this.t1));
        Assert.assertTrue((boolean)trans.contains(this.t2));
    }

    @Test
    public void lookupsTransformerByPriority() throws Exception {
        Transformer result = ((MuleContextWithRegistries)muleContext).getRegistry().lookupTransformer(BLOOD_ORANGE_DATA_TYPE, FRUIT_DATA_TYPE);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)this.t1, (Object)result);
    }

    @Test
    public void findsCompositeTransformerEvenIfDirectNotFound() throws Exception {
        Converter fruitToSeed = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("fruitToSeed")).from(FRUIT_DATA_TYPE)).to(SEED_DATA_TYPE)).build();
        Converter seedToApple = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("seedToApple")).from(SEED_DATA_TYPE)).to(APPLE_DATA_TYPE)).build();
        Converter appleToBanana = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("appleToBanana")).from(APPLE_DATA_TYPE)).to(BANANA_DATA_TYPE)).build();
        Converter bananaToBloodOrange = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("bananaToBloodOrange")).from(BANANA_DATA_TYPE)).to(BLOOD_ORANGE_DATA_TYPE)).build();
        ((MuleContextWithRegistries)muleContext).getRegistry().registerTransformer((Transformer)fruitToSeed);
        ((MuleContextWithRegistries)muleContext).getRegistry().registerTransformer((Transformer)seedToApple);
        ((MuleContextWithRegistries)muleContext).getRegistry().registerTransformer((Transformer)appleToBanana);
        ((MuleContextWithRegistries)muleContext).getRegistry().registerTransformer((Transformer)bananaToBloodOrange);
        Transformer trans = ((MuleContextWithRegistries)muleContext).getRegistry().lookupTransformer(FRUIT_DATA_TYPE, BLOOD_ORANGE_DATA_TYPE);
        Assert.assertThat((Object)trans, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)trans, (Matcher)Matchers.instanceOf(CompositeConverter.class));
        Assert.assertThat((Object)trans.getName(), (Matcher)Is.is((Object)"fruitToSeedseedToAppleappleToBananabananaToBloodOrange"));
        trans = ((MuleContextWithRegistries)muleContext).getRegistry().lookupTransformer(FRUIT_DATA_TYPE, ORANGE_DATA_TYPE);
        Assert.assertThat((Object)trans, (Matcher)Matchers.instanceOf(CompositeConverter.class));
        Assert.assertThat((Object)trans.getName(), (Matcher)Is.is((Object)"fruitToSeedseedToAppleappleToBananabananaToBloodOrange"));
        trans = ((MuleContextWithRegistries)muleContext).getRegistry().lookupTransformer(PEACH_DATA_TYPE, BLOOD_ORANGE_DATA_TYPE);
        Assert.assertThat((Object)trans, (Matcher)Matchers.instanceOf(CompositeConverter.class));
        Assert.assertThat((Object)trans.getName(), (Matcher)Is.is((Object)"fruitToSeedseedToAppleappleToBananabananaToBloodOrange"));
        trans = ((MuleContextWithRegistries)muleContext).getRegistry().lookupTransformer(PEACH_DATA_TYPE, ORANGE_DATA_TYPE);
        Assert.assertThat((Object)trans, (Matcher)Matchers.instanceOf(CompositeConverter.class));
        Assert.assertThat((Object)trans.getName(), (Matcher)Is.is((Object)"fruitToSeedseedToAppleappleToBananabananaToBloodOrange"));
    }

    @Test
    public void closestToTypesTransformerIsFoundEvenIfWeightIsLess() throws Exception {
        Converter bananaToBloodOrange = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("bananaToBloodOrange")).from(BANANA_DATA_TYPE)).to(BLOOD_ORANGE_DATA_TYPE)).weighting(10)).build();
        Converter bananaToOrange = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("bananaToOrange")).from(BANANA_DATA_TYPE)).to(ORANGE_DATA_TYPE)).weighting(1)).build();
        ((MuleContextWithRegistries)muleContext).getRegistry().registerTransformer((Transformer)bananaToBloodOrange);
        ((MuleContextWithRegistries)muleContext).getRegistry().registerTransformer((Transformer)bananaToOrange);
        Transformer trans = ((MuleContextWithRegistries)muleContext).getRegistry().lookupTransformer(BANANA_DATA_TYPE, ORANGE_DATA_TYPE);
        Assert.assertThat((Object)trans, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)trans.getName(), (Matcher)Is.is((Object)"bananaToOrange"));
    }
}

