/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.registry;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.internal.registry.DefaultRegistryBroker;
import org.mule.runtime.core.internal.registry.MuleRegistryHelper;
import org.mule.runtime.core.internal.registry.TransformerResolver;
import org.mule.runtime.core.internal.transformer.builder.MockConverterBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.fruit.Orange;

@SmallTest
public class MuleRegistryHelperTransformerLookupTestCase
extends AbstractMuleTestCase {
    private static final DataType ORANGE_DATA_TYPE = DataType.fromType(Orange.class);
    private final DefaultRegistryBroker registry = (DefaultRegistryBroker)Mockito.mock(DefaultRegistryBroker.class);
    private final MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
    private final MuleRegistryHelper muleRegistryHelper = new MuleRegistryHelper(this.registry, this.muleContext);
    private final Converter stringToOrange = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(DataType.STRING)).to(ORANGE_DATA_TYPE)).build();
    private final Converter orangeToString = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(ORANGE_DATA_TYPE)).to(DataType.STRING)).build();

    @Before
    public void setUp() throws Exception {
        TransformerResolver transformerResolver = (TransformerResolver)Mockito.mock(TransformerResolver.class);
        Mockito.when((Object)transformerResolver.resolve(DataType.STRING, ORANGE_DATA_TYPE)).thenReturn((Object)this.stringToOrange);
        Mockito.when((Object)transformerResolver.resolve(ORANGE_DATA_TYPE, DataType.STRING)).thenReturn((Object)this.orangeToString);
        this.muleRegistryHelper.registerObject("mockTransformerResolver", (Object)transformerResolver);
        this.muleRegistryHelper.registerTransformer((Transformer)this.orangeToString);
        this.muleRegistryHelper.registerTransformer((Transformer)this.stringToOrange);
    }

    @Test
    public void cachesTransformerResolvers() throws Exception {
        Transformer transformer1 = this.muleRegistryHelper.lookupTransformer(DataType.STRING, ORANGE_DATA_TYPE);
        Transformer transformer2 = this.muleRegistryHelper.lookupTransformer(ORANGE_DATA_TYPE, DataType.STRING);
        ((DefaultRegistryBroker)Mockito.verify((Object)this.registry, (VerificationMode)Mockito.times((int)0))).lookupObjects(TransformerResolver.class);
        Assert.assertEquals((Object)this.stringToOrange, (Object)transformer1);
        Assert.assertEquals((Object)this.orangeToString, (Object)transformer2);
    }

    @Test
    public void cachesTransformers() throws Exception {
        List transformers = this.muleRegistryHelper.lookupTransformers(DataType.STRING, ORANGE_DATA_TYPE);
        ((DefaultRegistryBroker)Mockito.verify((Object)this.registry, (VerificationMode)Mockito.times((int)0))).lookupObjects(Transformer.class);
        Assert.assertEquals((long)1L, (long)transformers.size());
        Assert.assertEquals((Object)this.stringToOrange, transformers.get(0));
    }
}

