/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.registry;

import javax.inject.Inject;
import javax.inject.Named;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleState;
import org.mule.runtime.core.api.lifecycle.LifecycleStateAware;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.registry.TestLifecycleObject;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class RegistrationAndInjectionTestCase
extends AbstractMuleContextTestCase {
    private static final String KEY = "key";
    private static final String KEY2 = "key2";
    private static final String EXTENDED_KEY = "extendedKey";

    public RegistrationAndInjectionTestCase() {
        this.setStartContext(true);
    }

    @Test
    public void applyLifecycleUponRegistration() throws Exception {
        TestLifecycleObject object = this.registerObject();
        this.assertRegistered(object);
        this.assertInitialisation(object);
    }

    @Test
    public void applyLifecycleUponUnregistration() throws Exception {
        this.applyLifecycleUponRegistration();
        TestLifecycleObject object = (TestLifecycleObject)((MuleContextWithRegistries)muleContext).getRegistry().unregisterObject(KEY);
        Assert.assertThat((Object)object, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.assertShutdown(object);
    }

    @Test
    public void registerExistingKey() throws Exception {
        TestLifecycleObject object = this.registerObject();
        TestLifecycleObject replacement = this.registerObject();
        this.assertRegistered(replacement);
        this.assertShutdown(object);
        this.assertInitialisation(replacement);
    }

    @Test
    public void injectOnRegisteredObject() throws Exception {
        TestLifecycleObject object = this.registerObject();
        this.assertInjection(object);
    }

    @Test
    public void injectWithInheritance() throws Exception {
        TestLifecycleObject child1 = new TestLifecycleObject();
        TestLifecycleObject child2 = new TestLifecycleObject();
        ((MuleContextWithRegistries)muleContext).getRegistry().registerObject(KEY, (Object)child1);
        ((MuleContextWithRegistries)muleContext).getRegistry().registerObject(KEY2, (Object)child2);
        Assert.assertThat((Object)((MuleContextWithRegistries)muleContext).getRegistry().lookupByType(TestLifecycleObject.class).size(), (Matcher)CoreMatchers.is((Object)2));
        ExtendedTestLifecycleObject object = new ExtendedTestLifecycleObject();
        muleContext.getInjector().inject((Object)object);
        this.assertInjection(object);
        Assert.assertThat((Object)object.getKeyChild(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)child1)));
        Assert.assertThat((Object)object.getKey2Child(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)child2)));
    }

    @Test
    public void muleContextAware() throws Exception {
        MuleContextAware muleContextAware = (MuleContextAware)Mockito.mock(MuleContextAware.class);
        ((MuleContextWithRegistries)muleContext).getRegistry().registerObject(KEY, (Object)muleContextAware);
        this.assertRegistered(muleContextAware);
        ((MuleContextAware)Mockito.verify((Object)muleContextAware)).setMuleContext(muleContext);
    }

    @Test
    public void lifecycleSateAware() throws Exception {
        LifecycleStateAware lifecycleStateAware = (LifecycleStateAware)Mockito.mock(LifecycleStateAware.class);
        ((MuleContextWithRegistries)muleContext).getRegistry().registerObject(KEY, (Object)lifecycleStateAware);
        this.assertRegistered(lifecycleStateAware);
        ((LifecycleStateAware)Mockito.verify((Object)lifecycleStateAware)).setLifecycleState((LifecycleState)Matchers.any(LifecycleState.class));
    }

    private void assertInjection(TestLifecycleObject object) {
        Assert.assertThat((Object)((MuleContextWithRegistries)muleContext).getRegistry().get("_muleObjectStoreManager"), (Matcher)CoreMatchers.is((Object)object.getObjectStoreManager()));
        Assert.assertThat((Object)object.getMuleContext(), (Matcher)CoreMatchers.is((Object)muleContext));
        Assert.assertThat((Object)object, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(MuleContextAware.class))));
    }

    private void assertRegistered(Object object) {
        Object registered = ((MuleContextWithRegistries)muleContext).getRegistry().get(KEY);
        Assert.assertThat((Object)registered, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)object)));
    }

    private TestLifecycleObject registerObject() throws RegistrationException {
        TestLifecycleObject object = new TestLifecycleObject();
        ((MuleContextWithRegistries)muleContext).getRegistry().registerObject(KEY, (Object)object);
        return object;
    }

    private void assertInitialisation(TestLifecycleObject object) {
        Assert.assertThat((Object)object.getInitialise(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)object.getStart(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)object.getStop(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)object.getDispose(), (Matcher)CoreMatchers.is((Object)0));
    }

    private void assertShutdown(TestLifecycleObject object) {
        Assert.assertThat((Object)object.getStop(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)object.getDispose(), (Matcher)CoreMatchers.is((Object)1));
    }

    public static class ExtendedTestLifecycleObject
    extends TestLifecycleObject {
        @Inject
        @Named(value="key")
        private TestLifecycleObject keyChild;
        private TestLifecycleObject key2Child;

        public TestLifecycleObject getKeyChild() {
            return this.keyChild;
        }

        public TestLifecycleObject getKey2Child() {
            return this.key2Child;
        }

        @Inject
        @Named(value="key2")
        public void setKey2Child(TestLifecycleObject key2Child) {
            this.key2Child = key2Child;
        }
    }
}

