/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.registry;

import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.deployment.management.ComponentInitialStateManager;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.processor.strategy.AsyncProcessingStrategyFactory;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.core.internal.construct.DefaultFlowBuilder;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.lifecycle.LifecycleInterceptor;
import org.mule.runtime.core.internal.lifecycle.MuleLifecycleInterceptor;
import org.mule.runtime.core.internal.registry.DefaultRegistryBroker;
import org.mule.runtime.core.internal.registry.MuleRegistry;
import org.mule.runtime.core.internal.registry.Registry;
import org.mule.runtime.core.internal.registry.RegistryBroker;
import org.mule.runtime.core.internal.registry.TransientRegistry;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Kiwi;

public class RegistryBrokerTestCase
extends AbstractMuleContextTestCase {
    private String tracker;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.tracker = new String();
    }

    protected boolean isStartContext() {
        return false;
    }

    @Test
    public void testCrossRegistryLifecycleOrder() throws MuleException {
        TransientRegistry reg1 = new TransientRegistry(UUID.getUUID(), muleContext, (LifecycleInterceptor)new MuleLifecycleInterceptor());
        reg1.initialise();
        TransientRegistry reg2 = new TransientRegistry(UUID.getUUID(), muleContext, (LifecycleInterceptor)new MuleLifecycleInterceptor());
        reg2.initialise();
        reg1.registerObject("flow", (Object)new LifecycleTrackerFlow("flow", muleContext));
        reg2.registerObject("flow2", (Object)new LifecycleTrackerFlow("flow2", muleContext));
        ((MuleContextWithRegistries)muleContext).addRegistry((Registry)reg1);
        ((MuleContextWithRegistries)muleContext).addRegistry((Registry)reg2);
        muleContext.start();
        Assert.assertEquals((Object)"flow2-start flow-start ", (Object)this.tracker.toString());
        this.tracker = new String();
        muleContext.stop();
        Assert.assertEquals((Object)"flow2-stop flow-stop ", (Object)this.tracker);
    }

    @Test
    public void testConcurrentRegistryAddRemove() throws Exception {
        MuleLifecycleInterceptor lifecycleInterceptor = new MuleLifecycleInterceptor();
        DefaultRegistryBroker broker = new DefaultRegistryBroker(muleContext, (LifecycleInterceptor)lifecycleInterceptor);
        int N = 50;
        CountDownLatch start = new CountDownLatch(1);
        CountDownLatch end = new CountDownLatch(50);
        AtomicInteger errors = new AtomicInteger(0);
        for (int i = 0; i < 50; ++i) {
            new Thread(() -> RegistryBrokerTestCase.lambda$testConcurrentRegistryAddRemove$0(start, (RegistryBroker)broker, lifecycleInterceptor, errors, end), "thread-eval-" + i).start();
        }
        start.countDown();
        end.await();
        if (errors.get() > 0) {
            Assert.fail();
        }
    }

    @Test
    public void registerWhenNoRegistriesManuallyAddedYet() throws Exception {
        String KEY1 = "apple";
        Apple VALUE1 = new Apple();
        String KEY2 = "Kiwi";
        Kiwi VALUE2 = new Kiwi();
        MuleRegistry registry = ((MuleContextWithRegistries)muleContext).getRegistry();
        registry.registerObject("apple", (Object)VALUE1);
        registry.registerObject("Kiwi", (Object)VALUE2);
        Assert.assertThat((Object)registry.get("apple"), (Matcher)CoreMatchers.is((Object)VALUE1));
        Assert.assertThat((Object)registry.get("Kiwi"), (Matcher)CoreMatchers.is((Object)VALUE2));
        Assert.assertThat((Object)registry.lookupObject(Apple.class), (Matcher)CoreMatchers.is((Object)VALUE1));
        Assert.assertThat((Object)registry.lookupObject(Kiwi.class), (Matcher)CoreMatchers.is((Object)VALUE2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$testConcurrentRegistryAddRemove$0(CountDownLatch start, RegistryBroker broker, MuleLifecycleInterceptor lifecycleInterceptor, AtomicInteger errors, CountDownLatch end) {
        try {
            start.await();
            broker.addRegistry((Registry)new TransientRegistry(UUID.getUUID(), muleContext, (LifecycleInterceptor)lifecycleInterceptor));
            broker.lookupByType(Object.class);
        }
        catch (Exception e) {
            errors.incrementAndGet();
        }
        finally {
            end.countDown();
        }
    }

    class LifecycleTrackerFlow
    extends DefaultFlowBuilder.DefaultFlow {
        public LifecycleTrackerFlow(String name, MuleContext muleContext) {
            super(name, muleContext, null, Collections.emptyList(), Optional.empty(), Optional.empty(), "started", AsyncProcessingStrategyFactory.DEFAULT_MAX_CONCURRENCY, null, new ComponentInitialStateManager(){

                public boolean mustStartMessageSource(Component component) {
                    return true;
                }
            });
        }

        protected void doStart() throws MuleException {
            super.doStart();
            RegistryBrokerTestCase.this.tracker = RegistryBrokerTestCase.this.tracker + this.getName() + "-start ";
        }

        protected void doStop() throws MuleException {
            super.doStop();
            RegistryBrokerTestCase.this.tracker = RegistryBrokerTestCase.this.tracker + this.getName() + "-stop ";
        }
    }
}

