/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.registry;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.internal.registry.Registry;
import org.mule.runtime.core.internal.registry.RegistryDelegatingInjector;
import org.mule.runtime.core.internal.registry.RegistryProvider;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class RegistryDelegatingInjectorTestCase
extends AbstractMuleTestCase {
    @Mock
    private RegistryProvider registryProvider;
    @Mock(extraInterfaces={Injector.class})
    private Registry injectorRegistry;
    private Injector injector;

    @Before
    public void before() {
        this.injector = new RegistryDelegatingInjector(this.registryProvider);
    }

    @Test
    public void inject() throws Exception {
        Mockito.when((Object)this.registryProvider.getRegistries()).thenReturn(Arrays.asList((Registry)Mockito.mock(Registry.class), this.injectorRegistry));
        Object target = new Object();
        Object injected = new Object();
        Mockito.when((Object)((Injector)this.injectorRegistry).inject(target)).thenReturn(injected);
        Assert.assertThat((Object)this.injector.inject(target), (Matcher)CoreMatchers.is((Object)injected));
    }

    @Test
    public void noSuitableRegistry() throws Exception {
        Mockito.when((Object)this.registryProvider.getRegistries()).thenReturn(Arrays.asList((Registry)Mockito.mock(Registry.class)));
        this.assertNoinjection();
    }

    @Test
    public void noRegistriesAtAll() throws Exception {
        Mockito.when((Object)this.registryProvider.getRegistries()).thenReturn((Object)ImmutableList.of());
        this.assertNoinjection();
    }

    @Test(expected=IllegalArgumentException.class)
    public void nullProvider() {
        new RegistryDelegatingInjector(null);
    }

    private void assertNoinjection() throws MuleException {
        Object target = Mockito.mock(Object.class);
        Assert.assertThat((Object)this.injector.inject(target), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)target)));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{target});
    }
}

