/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.retry.policies;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.core.internal.retry.policies.SimpleRetryPolicy;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public class NonBlockingReconnectionTestCase
extends AbstractMuleContextTestCase {
    private static final int RETRIES = 5;
    private static final Long FREQUENCY = 1000L;
    private final AtomicInteger executedRetries = new AtomicInteger(0);
    private final AtomicBoolean exhausted = new AtomicBoolean(false);
    private final AtomicLong previousExecutionMoment = new AtomicLong(0L);
    private final List<Long> executionMomentDeltas = new LinkedList<Long>();

    @Test
    public void successfulWithoutRetry() throws Exception {
        SimpleRetryPolicy retryPolicy = new SimpleRetryPolicy(FREQUENCY.longValue(), 5);
        Mono publisher = Mono.fromCallable(() -> {
            this.trackRetry();
            return this.executedRetries.get();
        });
        Integer value = (Integer)Mono.from((Publisher)retryPolicy.applyPolicy((Publisher)publisher, e -> e instanceof IllegalArgumentException, e -> this.exhausted.set(true), Function.identity())).block();
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)1));
        this.assertNoRetry();
        Assert.assertThat((Object)this.exhausted.get(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void successfulRetry() throws Exception {
        this.doSuccessfulRetry(new SimpleRetryPolicy(FREQUENCY.longValue(), 5));
    }

    @Test
    public void retryForever() throws Exception {
        this.doSuccessfulRetry(new SimpleRetryPolicy(FREQUENCY.longValue(), -1));
    }

    private void doSuccessfulRetry(SimpleRetryPolicy retryPolicy) throws Exception {
        Mono publisher = Mono.fromCallable(() -> {
            this.trackRetry();
            if (this.executedRetries.get() <= 5) {
                throw new IllegalArgumentException("not retried enough");
            }
            return this.executedRetries.get();
        });
        Integer value = (Integer)Mono.from((Publisher)retryPolicy.applyPolicy((Publisher)publisher, e -> e instanceof IllegalArgumentException, e -> this.exhausted.set(true), Function.identity())).block();
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)6));
        this.assertRetry();
        Assert.assertThat((Object)this.exhausted.get(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void exhaustedRetry() {
        SimpleRetryPolicy retryPolicy = new SimpleRetryPolicy(FREQUENCY.longValue(), 5);
        Mono publisher = Mono.fromCallable(() -> {
            this.trackRetry();
            throw new IllegalArgumentException("No retry will save you");
        });
        try {
            Mono.from((Publisher)retryPolicy.applyPolicy((Publisher)publisher, e -> e instanceof IllegalArgumentException, e -> this.exhausted.set(true), Function.identity())).block();
        }
        catch (Exception e2) {
            Assert.assertThat((Object)e2, (Matcher)CoreMatchers.instanceOf(IllegalArgumentException.class));
            Assert.assertThat((Object)this.exhausted.get(), (Matcher)CoreMatchers.is((Object)true));
            this.assertRetry();
        }
    }

    @Test
    public void exhaustedRetryWithMappedException() {
        SimpleRetryPolicy retryPolicy = new SimpleRetryPolicy(FREQUENCY.longValue(), 5);
        Mono publisher = Mono.fromCallable(() -> {
            this.trackRetry();
            throw new IllegalArgumentException("No retry will save you");
        });
        try {
            Mono.from((Publisher)retryPolicy.applyPolicy((Publisher)publisher, e -> true, e -> this.exhausted.set(true), ConnectionException::new)).block();
        }
        catch (Throwable e2) {
            e2 = Exceptions.unwrap((Throwable)e2);
            Assert.assertThat((Object)e2, (Matcher)CoreMatchers.instanceOf(ConnectionException.class));
            Assert.assertThat((Object)e2.getCause(), (Matcher)CoreMatchers.instanceOf(IllegalArgumentException.class));
            Assert.assertThat((Object)this.exhausted.get(), (Matcher)CoreMatchers.is((Object)true));
            this.assertRetry();
        }
    }

    @Test
    public void skipRetry() throws Exception {
        SimpleRetryPolicy retryPolicy = new SimpleRetryPolicy(FREQUENCY.longValue(), 5);
        Mono publisher = Mono.fromCallable(() -> {
            this.trackRetry();
            throw new IllegalArgumentException("No retry will save you");
        });
        try {
            Mono.from((Publisher)retryPolicy.applyPolicy((Publisher)publisher, e -> !(e instanceof IllegalArgumentException), e -> this.exhausted.set(true), Function.identity())).block();
        }
        catch (Exception e2) {
            Assert.assertThat((Object)e2, (Matcher)CoreMatchers.instanceOf(IllegalArgumentException.class));
            this.assertNoRetry();
            Assert.assertThat((Object)this.exhausted.get(), (Matcher)CoreMatchers.is((Object)true));
        }
    }

    private void assertNoRetry() {
        Assert.assertThat((Object)this.executedRetries.get(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat(this.executionMomentDeltas, (Matcher)Matchers.hasSize((int)0));
    }

    private void assertRetry() {
        Assert.assertThat((Object)this.executedRetries.get(), (Matcher)CoreMatchers.is((Object)6));
        Assert.assertThat((Object)this.executionMomentDeltas.stream().mapToInt(Long::intValue).average().getAsDouble(), (Matcher)Matchers.anyOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Double.valueOf(FREQUENCY.doubleValue())), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Double.valueOf(FREQUENCY.doubleValue() * 1.3))));
    }

    private void trackRetry() {
        this.executedRetries.incrementAndGet();
        long now = System.currentTimeMillis();
        if (!this.previousExecutionMoment.compareAndSet(0L, now)) {
            long delta = now - this.previousExecutionMoment.get();
            this.previousExecutionMoment.set(now);
            this.executionMomentDeltas.add(delta);
        }
    }
}

