/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.internal.routing.AbstractSplitter;
import org.mule.runtime.core.privileged.event.Acceptor;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.FruitBowl;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.tck.util.MuleContextUtils;

public class AbstractSplitterTestCase
extends AbstractMuleContextTestCase {
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @Test
    public void simpleSplitter() throws Exception {
        TestSplitter splitter = new TestSplitter(false);
        MultipleEventSensingMessageProcessor listener = new MultipleEventSensingMessageProcessor();
        splitter.setListener(listener);
        splitter.setMuleContext(muleContext);
        Apple apple = new Apple();
        Banana banana = new Banana();
        Orange orange = new Orange();
        FruitBowl fruitBowl = new FruitBowl();
        fruitBowl.addFruit((Fruit)apple);
        fruitBowl.addFruit((Fruit)banana);
        fruitBowl.addFruit((Fruit)orange);
        CoreEvent inEvent = MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)fruitBowl)).build();
        CoreEvent resultEvent = splitter.process(inEvent);
        Assert.assertThat(listener.events, (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat((Object)listener.events.get(0).getMessage().getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(Fruit.class));
        Assert.assertThat((Object)listener.events.get(1).getMessage().getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(Fruit.class));
        Assert.assertThat((Object)listener.events.get(2).getMessage().getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(Fruit.class));
        Assert.assertThat((Object)resultEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(List.class));
        Assert.assertThat((Object)((List)resultEvent.getMessage().getPayload().getValue()), (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat((Object)((InternalMessage)((List)resultEvent.getMessage().getPayload().getValue()).get(0)).getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(Fruit.class));
        Assert.assertThat((Object)((InternalMessage)((List)resultEvent.getMessage().getPayload().getValue()).get(1)).getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(Fruit.class));
        Assert.assertThat((Object)((InternalMessage)((List)resultEvent.getMessage().getPayload().getValue()).get(2)).getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(Fruit.class));
    }

    @Test
    public void allFilteredSplitter() throws Exception {
        TestSplitter splitter = new TestSplitter(true);
        splitter.setListener(event -> {
            throw new MessagingException(I18nMessageFactory.createStaticMessage((String)"Expected"), event, (Component)splitter);
        });
        splitter.setMuleContext(muleContext);
        Apple apple = new Apple();
        Banana banana = new Banana();
        Orange orange = new Orange();
        FruitBowl fruitBowl = new FruitBowl();
        fruitBowl.addFruit((Fruit)apple);
        fruitBowl.addFruit((Fruit)banana);
        fruitBowl.addFruit((Fruit)orange);
        CoreEvent inEvent = MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)fruitBowl)).build();
        CoreEvent resultEvent = splitter.process(inEvent);
        Assert.assertThat((Object)resultEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void failingNotFilteredSplitter() throws Exception {
        TestSplitter splitter = new TestSplitter(false);
        splitter.setListener(event -> {
            throw new MessagingException(I18nMessageFactory.createStaticMessage((String)"Expected"), event, (Component)splitter);
        });
        splitter.setMuleContext(muleContext);
        Apple apple = new Apple();
        Banana banana = new Banana();
        Orange orange = new Orange();
        FruitBowl fruitBowl = new FruitBowl();
        fruitBowl.addFruit((Fruit)apple);
        fruitBowl.addFruit((Fruit)banana);
        fruitBowl.addFruit((Fruit)orange);
        CoreEvent inEvent = MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)fruitBowl)).build();
        this.expected.expect(MessagingException.class);
        this.expected.expectMessage("Expected");
        splitter.process(inEvent);
    }

    private static class TestSplitter
    extends AbstractSplitter {
        public TestSplitter(final boolean filtersErrors) {
            this.filterOnErrorTypeAcceptor = new Acceptor(){

                public boolean acceptsAll() {
                    return filtersErrors;
                }

                public boolean accept(CoreEvent event) {
                    return filtersErrors;
                }
            };
        }

        protected List<CoreEvent> splitMessage(CoreEvent event) {
            FruitBowl bowl = (FruitBowl)event.getMessage().getPayload().getValue();
            ArrayList<CoreEvent> parts = new ArrayList<CoreEvent>();
            for (Fruit fruit : bowl.getFruit()) {
                parts.add(CoreEvent.builder((CoreEvent)event).message(Message.of((Object)fruit)).build());
            }
            return parts;
        }
    }

    private static class MultipleEventSensingMessageProcessor
    implements Processor {
        List<CoreEvent> events = new ArrayList<CoreEvent>();

        private MultipleEventSensingMessageProcessor() {
        }

        public CoreEvent process(CoreEvent event) throws MuleException {
            this.events.add(event);
            return event;
        }
    }
}

