/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.routing.AbstractAggregator;
import org.mule.runtime.core.internal.routing.AggregationException;
import org.mule.runtime.core.internal.routing.EventGroup;
import org.mule.runtime.core.internal.routing.correlation.EventCorrelatorCallback;
import org.mule.runtime.core.privileged.event.DefaultMuleSession;
import org.mule.runtime.core.privileged.event.MuleSession;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class AggregatorTestCase
extends AbstractMuleContextTestCase {
    public AggregatorTestCase() {
        this.setStartContext(true);
    }

    protected Map<String, Object> getStartUpRegistryObjects() {
        return Collections.singletonMap("_muleConfigurationComponentLocator", this.componentLocator);
    }

    @Test
    public void testMessageAggregator() throws Exception {
        Flow flow = MuleTestUtils.createAndRegisterFlow((MuleContext)muleContext, (String)"appleFlow", (ConfigurationComponentLocator)this.componentLocator);
        DefaultMuleSession session = new DefaultMuleSession();
        TestEventAggregator router = new TestEventAggregator(3);
        router.setAnnotations(AggregatorTestCase.getAppleFlowComponentLocationAnnotations());
        LifecycleUtils.initialiseIfNeeded((Object)((Object)router), (boolean)true, (MuleContext)muleContext);
        EventContext context = EventContextFactory.create((FlowConstruct)flow, (ComponentLocation)TEST_CONNECTOR_LOCATION, (String)"foo");
        Message message1 = Message.of((Object)"test event A");
        Message message2 = Message.of((Object)"test event B");
        Message message3 = Message.of((Object)"test event C");
        InternalEvent event1 = InternalEvent.builder((EventContext)context).message(message1).session((MuleSession)session).build();
        InternalEvent event2 = InternalEvent.builder((EventContext)context).message(message2).session((MuleSession)session).build();
        InternalEvent event3 = InternalEvent.builder((EventContext)context).message(message3).session((MuleSession)session).build();
        Assert.assertNull((Object)router.process((CoreEvent)event1));
        Assert.assertNull((Object)router.process((CoreEvent)event2));
        CoreEvent result = router.process((CoreEvent)event3);
        Assert.assertNotNull((Object)result);
        PrivilegedEvent privilegedResult = (PrivilegedEvent)result;
        Assert.assertTrue((boolean)privilegedResult.getMessageAsString(muleContext).contains("test event A"));
        Assert.assertTrue((boolean)privilegedResult.getMessageAsString(muleContext).contains("test event B"));
        Assert.assertTrue((boolean)privilegedResult.getMessageAsString(muleContext).contains("test event C"));
        Assert.assertTrue((boolean)privilegedResult.getMessageAsString(muleContext).matches("test event [A,B,C] test event [A,B,C] test event [A,B,C] "));
    }

    public static class TestEventAggregator
    extends AbstractAggregator {
        protected final int eventThreshold;
        protected int eventCount = 0;

        public TestEventAggregator(int eventThreshold) {
            this.eventThreshold = eventThreshold;
        }

        protected EventCorrelatorCallback getCorrelatorCallback(final MuleContext muleContext) {
            return new EventCorrelatorCallback(){

                public boolean shouldAggregateEvents(EventGroup events) {
                    ++eventCount;
                    if (eventCount == eventThreshold) {
                        eventCount = 0;
                        return true;
                    }
                    return false;
                }

                public EventGroup createEventGroup(CoreEvent event, Object groupId) {
                    return new EventGroup(groupId, muleContext, Optional.of(eventThreshold), storePrefix);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public CoreEvent aggregateEvents(EventGroup events) throws AggregationException {
                    if (events.size() != eventThreshold) {
                        throw new IllegalStateException("eventThreshold not yet reached?");
                    }
                    StringBuilder newPayload = new StringBuilder(80);
                    try {
                        Iterator iterator = events.iterator(false);
                        while (iterator.hasNext()) {
                            CoreEvent event = (CoreEvent)iterator.next();
                            try {
                                newPayload.append(((PrivilegedEvent)event).getMessageAsString(muleContext)).append(" ");
                            }
                            catch (MuleException e) {
                                throw new AggregationException(events, next, (Throwable)e);
                                return CoreEvent.builder((CoreEvent)events.getMessageCollectionEvent()).message(Message.of((Object)newPayload.toString())).build();
                            }
                        }
                    }
                    catch (ObjectStoreException e) {
                        throw new AggregationException(events, next, (Throwable)e);
                    }
                }
            };
        }
    }
}

