/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.Collections;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.management.stats.RouterStatistics;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.routing.ChoiceRouter;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.tck.junit4.AbstractReactiveProcessorTestCase;
import org.mule.tck.testmodels.mule.TestMessageProcessor;
import org.mule.tck.util.MuleContextUtils;

public class ChoiceRouterTestCase
extends AbstractReactiveProcessorTestCase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private ChoiceRouter choiceRouter;

    public ChoiceRouterTestCase(AbstractReactiveProcessorTestCase.Mode mode) {
        super(mode);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.choiceRouter = new ChoiceRouter();
        this.choiceRouter.setAnnotations(Collections.singletonMap(AbstractComponent.LOCATION_KEY, TEST_CONNECTOR_LOCATION));
        this.choiceRouter.setExpressionManager((ExpressionManager)muleContext.getExpressionManager());
    }

    @Test
    public void testNoRoute() throws Exception {
        CoreEvent inputEvent = this.fooEvent();
        Assert.assertThat((Object)this.process((Processor)this.choiceRouter, inputEvent), (Matcher)CoreMatchers.is((Object)inputEvent));
    }

    @Test
    public void testOnlyDefaultRoute() throws Exception {
        this.choiceRouter.setDefaultRoute((Processor)MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{new TestMessageProcessor("default")}));
        this.choiceRouter.setMuleContext(muleContext);
        this.choiceRouter.initialise();
        Assert.assertThat((Object)this.process((Processor)this.choiceRouter, this.fooEvent()).getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"foo:default"));
    }

    @Test
    public void testNoMatchingNorDefaultRoute() throws Exception {
        this.choiceRouter.addRoute(this.payloadZapExpression(), (Processor)MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{new TestMessageProcessor("bar")}));
        CoreEvent inputEvent = this.fooEvent();
        Assert.assertThat((Object)this.process((Processor)this.choiceRouter, inputEvent), (Matcher)CoreMatchers.is((Object)inputEvent));
    }

    @Test
    public void testNoMatchingRouteWithDefaultRoute() throws Exception {
        this.choiceRouter.addRoute(this.payloadZapExpression(), (Processor)MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{new TestMessageProcessor("bar")}));
        this.choiceRouter.setDefaultRoute((Processor)MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{new TestMessageProcessor("default")}));
        this.choiceRouter.setMuleContext(muleContext);
        this.choiceRouter.initialise();
        Assert.assertThat((Object)this.process((Processor)this.choiceRouter, this.fooEvent()).getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"foo:default"));
    }

    @Test
    public void testMatchingRouteWithDefaultRoute() throws Exception {
        this.choiceRouter.addRoute(this.payloadZapExpression(), (Processor)MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{new TestMessageProcessor("bar")}));
        this.choiceRouter.setDefaultRoute((Processor)MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{new TestMessageProcessor("default")}));
        this.choiceRouter.setMuleContext(muleContext);
        this.choiceRouter.initialise();
        Assert.assertThat((Object)this.process((Processor)this.choiceRouter, this.zapEvent()).getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"zap:bar"));
    }

    @Test
    public void testMatchingRouteWithStatistics() throws Exception {
        this.choiceRouter.addRoute(this.payloadZapExpression(), (Processor)MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{new TestMessageProcessor("bar")}));
        this.choiceRouter.setRouterStatistics(new RouterStatistics(2));
        this.choiceRouter.setMuleContext(muleContext);
        this.choiceRouter.initialise();
        Assert.assertThat((Object)this.process((Processor)this.choiceRouter, this.zapEvent()).getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"zap:bar"));
    }

    @Test
    public void testAddAndDeleteRoute() throws Exception {
        MessageProcessorChain mp = MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{new TestMessageProcessor("bar")});
        this.choiceRouter.addRoute(this.payloadZapExpression(), (Processor)mp);
        this.choiceRouter.removeRoute((Processor)mp);
        this.choiceRouter.setRouterStatistics(new RouterStatistics(2));
        this.choiceRouter.setMuleContext(muleContext);
        this.choiceRouter.initialise();
        CoreEvent inputEvent = this.zapEvent();
        Assert.assertThat((Object)this.process((Processor)this.choiceRouter, inputEvent), (Matcher)CoreMatchers.is((Object)inputEvent));
    }

    @Test
    public void testUpdateRoute() throws Exception {
        MessageProcessorChain mp = MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{new TestMessageProcessor("bar")});
        this.choiceRouter.addRoute(this.payloadPazExpression(), (Processor)mp);
        this.choiceRouter.updateRoute(this.payloadZapExpression(), (Processor)mp);
        this.choiceRouter.setMuleContext(muleContext);
        this.choiceRouter.initialise();
        Assert.assertThat((Object)this.process((Processor)this.choiceRouter, this.zapEvent()).getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"zap:bar"));
    }

    protected CoreEvent fooEvent() throws MuleException {
        return MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"foo")).build();
    }

    protected CoreEvent zapEvent() throws MuleException {
        return MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"zap")).build();
    }

    @Test
    public void testRemovingUpdatingMissingRoutes() {
        this.choiceRouter.updateRoute(this.payloadZapExpression(), (Processor)MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{new TestMessageProcessor("bar")}));
        this.choiceRouter.removeRoute((Processor)MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{new TestMessageProcessor("rab")}));
    }

    public String payloadZapExpression() {
        return "payload == 'zap'";
    }

    public String payloadPazExpression() {
        return "payload == 'paz'";
    }
}

