/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.internal.construct.DefaultFlowBuilder;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.privileged.event.MuleSession;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.routing.DefaultRouterResultsHandler;
import org.mule.runtime.core.privileged.routing.RouterResultsHandler;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.util.MuleContextUtils;

public class DefaultRouterResultsHandlerTestCase
extends AbstractMuleTestCase {
    protected RouterResultsHandler resultsHandler = new DefaultRouterResultsHandler();
    protected MuleContext muleContext = MuleContextUtils.mockContextWithServices();
    protected MuleSession session = (MuleSession)Mockito.mock(MuleSession.class);
    protected DefaultFlowBuilder.DefaultFlow flow = (DefaultFlowBuilder.DefaultFlow)Mockito.mock(DefaultFlowBuilder.DefaultFlow.class);
    private EventContext context;

    @Before
    public void setupMocks() throws Exception {
        Mockito.when((Object)this.flow.getMuleContext()).thenReturn((Object)this.muleContext);
        Mockito.when((Object)this.muleContext.getConfiguration()).thenReturn(Mockito.mock(MuleConfiguration.class));
        this.context = EventContextFactory.create((FlowConstruct)this.flow, (ComponentLocation)TEST_CONNECTOR_LOCATION);
    }

    @Test
    public void aggregateNoEvent() {
        CoreEvent result = this.resultsHandler.aggregateResults(Collections.singletonList(null), (CoreEvent)Mockito.mock(CoreEvent.class));
        Assert.assertNull((Object)result);
    }

    @Test
    public void aggregateSingleEvent() {
        Message message1 = Message.of((Object)"test event A");
        InternalEvent event1 = InternalEvent.builder((EventContext)this.context).message(message1).addVariable("key1", (Object)"value1").build();
        event1.getSession().setProperty("key", (Serializable)((Object)"value"));
        Message message2 = Message.of((Object)"test event B");
        InternalEvent event2 = InternalEvent.builder((EventContext)this.context).message(message2).addVariable("key2", (Object)"value2").build();
        event2.getSession().setProperty("key", (Serializable)((Object)"valueNEW"));
        event2.getSession().setProperty("key1", (Serializable)((Object)"value1"));
        CoreEvent result = this.resultsHandler.aggregateResults(Collections.singletonList(event2), (CoreEvent)event1);
        Assert.assertSame((Object)event2, (Object)result);
        Assert.assertThat(result.getVariables().keySet(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)"key1")));
        Assert.assertThat((Object)((TypedValue)result.getVariables().get("key2")).getValue(), (Matcher)CoreMatchers.equalTo((Object)"value2"));
        PrivilegedEvent privilegedResult = (PrivilegedEvent)result;
        Assert.assertThat((Object)privilegedResult.getSession().getProperty("key"), (Matcher)CoreMatchers.equalTo((Object)"valueNEW"));
        Assert.assertThat((Object)privilegedResult.getSession().getProperty("key1"), (Matcher)CoreMatchers.equalTo((Object)"value1"));
    }

    @Test
    public void aggregateMultipleEvents() throws Exception {
        DataType simpleDateType1 = DataType.builder().type(String.class).mediaType("text/plain").build();
        Message message1 = Message.of((Object)"test event A");
        Message message2 = Message.of((Object)"test event B");
        Message message3 = Message.of((Object)"test event C");
        InternalEvent event1 = InternalEvent.builder((EventContext)this.context).message(message1).addVariable("key1", (Object)"value1", simpleDateType1).build();
        MuleSession session = event1.getSession();
        InternalEvent event2 = InternalEvent.builder((EventContext)this.context).message(message2).session(session).addVariable("key2", (Object)"value2", simpleDateType1).build();
        InternalEvent event3 = InternalEvent.builder((EventContext)this.context).message(message3).session(session).addVariable("key3", (Object)"value3", simpleDateType1).build();
        event1.getSession().setProperty("key", (Serializable)((Object)"value"));
        event2.getSession().setProperty("key1", (Serializable)((Object)"value1"));
        event2.getSession().setProperty("key2", (Serializable)((Object)"value2"));
        event3.getSession().setProperty("KEY2", (Serializable)((Object)"value2NEW"));
        event3.getSession().setProperty("key3", (Serializable)((Object)"value3"));
        ArrayList<InternalEvent> events = new ArrayList<InternalEvent>();
        events.add(event2);
        events.add(event3);
        PrivilegedEvent result = (PrivilegedEvent)this.resultsHandler.aggregateResults(events, (CoreEvent)event1);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)((List)result.getMessage().getPayload().getValue()), (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(List.class));
        Assert.assertThat(((List)result.getMessage().getPayload().getValue()).get(0), (Matcher)CoreMatchers.is((Object)message2));
        Assert.assertThat(((List)result.getMessage().getPayload().getValue()).get(1), (Matcher)CoreMatchers.is((Object)message3));
        Assert.assertThat((Object)((TypedValue)result.getVariables().get("key1")).getValue(), (Matcher)CoreMatchers.equalTo((Object)"value1"));
        Assert.assertThat((Object)((TypedValue)result.getVariables().get("key1")).getDataType(), (Matcher)CoreMatchers.equalTo((Object)simpleDateType1));
        Assert.assertThat((Object)((TypedValue)result.getVariables().get("key2")).getValue(), (Matcher)CoreMatchers.equalTo((Object)"value2"));
        Assert.assertThat((Object)((TypedValue)result.getVariables().get("key3")).getValue(), (Matcher)CoreMatchers.equalTo((Object)"value3"));
        Assert.assertThat((Object)result.getCorrelationId(), (Matcher)CoreMatchers.equalTo((Object)event1.getCorrelationId()));
        Assert.assertThat((Object)result.getSession().getProperty("key"), (Matcher)CoreMatchers.is((Object)"value"));
        Assert.assertThat((Object)result.getSession().getProperty("key1"), (Matcher)CoreMatchers.is((Object)"value1"));
        Assert.assertThat((Object)result.getSession().getProperty("key2"), (Matcher)CoreMatchers.is((Object)"value2NEW"));
        Assert.assertThat((Object)result.getSession().getProperty("key3"), (Matcher)CoreMatchers.is((Object)"value3"));
        Assert.assertThat((Object)result.getSession().getProperty("key4"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void aggregateMultipleEventsAllButOneNull() {
        Message message1 = Message.of((Object)"test event A");
        Message message2 = Message.of((Object)"test event B");
        InternalEvent event1 = InternalEvent.builder((EventContext)this.context).message(message1).addVariable("key", (Object)"value").build();
        InternalEvent event2 = InternalEvent.builder((EventContext)this.context).message(message2).addVariable("key2", (Object)"value2").build();
        ArrayList<InternalEvent> events = new ArrayList<InternalEvent>();
        events.add(null);
        events.add(event2);
        CoreEvent result = this.resultsHandler.aggregateResults(events, (CoreEvent)event1);
        Assert.assertSame((Object)event2, (Object)result);
        Assert.assertThat(result.getVariables().keySet(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)"key1")));
        Assert.assertThat((Object)((TypedValue)result.getVariables().get("key2")).getValue(), (Matcher)CoreMatchers.equalTo((Object)"value2"));
    }

    @Test
    public void aggregateSingleMuleMessageCollection() {
        Message message1 = Message.of((Object)"test event A");
        InternalEvent event1 = InternalEvent.builder((EventContext)this.context).message(message1).addVariable("key1", (Object)"value1").build();
        Message message2 = Message.of((Object)"test event B");
        Message message3 = Message.of((Object)"test event C");
        ArrayList<Message> list = new ArrayList<Message>();
        list.add(message2);
        list.add(message3);
        Message messageCollection = Message.of(list);
        InternalEvent event2 = InternalEvent.builder((EventContext)this.context).message(messageCollection).addVariable("key2", (Object)"value2").build();
        CoreEvent result = this.resultsHandler.aggregateResults(Collections.singletonList(event2), (CoreEvent)event1);
        Assert.assertSame((Object)event2, (Object)result);
        Assert.assertThat(result.getVariables().keySet(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)"key1")));
        Assert.assertThat((Object)((TypedValue)result.getVariables().get("key2")).getValue(), (Matcher)CoreMatchers.equalTo((Object)"value2"));
    }

    @Test
    public void aggregateMultipleMuleMessageCollections() {
        Message message1 = Message.of((Object)"test event A");
        InternalEvent event1 = InternalEvent.builder((EventContext)this.context).message(message1).addVariable("key1", (Object)"value1").build();
        Message message2 = Message.of((Object)"test event B");
        Message message3 = Message.of((Object)"test event C");
        Message message4 = Message.of((Object)"test event D");
        Message message5 = Message.of((Object)"test event E");
        ArrayList<Message> list = new ArrayList<Message>();
        list.add(message2);
        list.add(message3);
        Message messageCollection = Message.of(list);
        InternalEvent event2 = InternalEvent.builder((EventContext)this.context).message(messageCollection).addVariable("key2", (Object)"value2").build();
        ArrayList list2 = new ArrayList();
        list.add(message4);
        list.add(message5);
        Message messageCollection2 = Message.of(list2);
        InternalEvent event3 = InternalEvent.builder((EventContext)this.context).message(messageCollection2).addVariable("key3", (Object)"value3").build();
        ArrayList<InternalEvent> events = new ArrayList<InternalEvent>();
        events.add(event2);
        events.add(event3);
        CoreEvent result = this.resultsHandler.aggregateResults(events, (CoreEvent)event1);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)2L, (long)((List)result.getMessage().getPayload().getValue()).size());
        Assert.assertTrue((boolean)(result.getMessage().getPayload().getValue() instanceof List));
        Assert.assertEquals((Object)messageCollection, ((List)result.getMessage().getPayload().getValue()).get(0));
        Assert.assertEquals((Object)messageCollection2, ((List)result.getMessage().getPayload().getValue()).get(1));
        Assert.assertThat((Object)((TypedValue)result.getVariables().get("key1")).getValue(), (Matcher)CoreMatchers.equalTo((Object)"value1"));
        Assert.assertThat((Object)((TypedValue)result.getVariables().get("key2")).getValue(), (Matcher)CoreMatchers.equalTo((Object)"value2"));
        Assert.assertThat((Object)((TypedValue)result.getVariables().get("key3")).getValue(), (Matcher)CoreMatchers.equalTo((Object)"value3"));
        Assert.assertThat((Object)result.getCorrelationId(), (Matcher)CoreMatchers.equalTo((Object)event1.getCorrelationId()));
    }
}

