/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.IteratorUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.PartitionableObjectStore;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.routing.EventGroup;
import org.mule.runtime.core.internal.util.store.DefaultObjectStoreFactoryBean;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.util.MuleContextUtils;

public class EventGroupTestCase
extends AbstractMuleContextTestCase {
    private PartitionableObjectStore<CoreEvent> objectStore;

    @Before
    public void before() throws RegistrationException {
        DefaultObjectStoreFactoryBean cfr_ignored_0 = (DefaultObjectStoreFactoryBean)((MuleContextWithRegistries)muleContext).getRegistry().lookupObject(DefaultObjectStoreFactoryBean.class);
        this.objectStore = (PartitionableObjectStore)DefaultObjectStoreFactoryBean.createDefaultInMemoryObjectStore();
    }

    @Test
    public void concurrentIteration() throws Exception {
        EventGroup eg = new EventGroup((Object)UUID.getUUID(), muleContext);
        eg.initEventsStore(this.objectStore);
        Assert.assertFalse((boolean)eg.iterator().hasNext());
        eg.addEvent(MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"foo1")).build());
        eg.addEvent(MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"foo2")).build());
        Assert.assertTrue((boolean)eg.iterator().hasNext());
        Iterator i = eg.iterator();
        Assert.assertNotNull(i.next());
        eg.addEvent(MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"foo3")).build());
        Assert.assertNotNull(i.next());
        eg.addEvent(MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"foo4")).build());
        Assert.assertFalse((boolean)i.hasNext());
        Assert.assertEquals((long)4L, (long)eg.size());
    }

    @Test
    public void eventGroupEquality() throws ObjectStoreException {
        EventGroup g1 = new EventGroup((Object)"foo", muleContext);
        g1.initEventsStore(this.objectStore);
        EventGroup g2 = new EventGroup((Object)"foo", muleContext);
        g2.initEventsStore(this.objectStore);
        EventGroup g3 = new EventGroup((Object)"bar", muleContext);
        g3.initEventsStore(this.objectStore);
        Assert.assertEquals((Object)g1, (Object)g2);
        Assert.assertFalse((boolean)g1.equals((Object)g3));
        MyEventGroup mg = new MyEventGroup("foo");
        Assert.assertEquals((Object)g1, (Object)((Object)mg));
        Assert.assertEquals((Object)((Object)mg), (Object)g1);
        mg = new MyEventGroup("bar");
        Assert.assertFalse((boolean)g1.equals((Object)mg));
        Assert.assertFalse((boolean)mg.equals(g1));
    }

    @Test
    public void eventGroupHashCode() throws ObjectStoreException {
        String uuid = UUID.getUUID();
        EventGroup g1 = new EventGroup((Object)uuid, muleContext);
        g1.initEventsStore(this.objectStore);
        EventGroup g2 = new EventGroup((Object)uuid, muleContext);
        g2.initEventsStore(this.objectStore);
        EventGroup g3 = new EventGroup((Object)UUID.getUUID(), muleContext);
        g3.initEventsStore(this.objectStore);
        Assert.assertEquals((long)g1.hashCode(), (long)g2.hashCode());
        Assert.assertEquals((Object)g1, (Object)g2);
        Assert.assertFalse((g1.hashCode() == g3.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)g1.equals((Object)g3));
        Assert.assertFalse((boolean)g3.equals((Object)g1));
        HashSet<EventGroup> s = new HashSet<EventGroup>();
        s.add(g1);
        Assert.assertTrue((boolean)s.contains(g1));
        Assert.assertEquals((long)1L, (long)s.size());
        Assert.assertTrue((boolean)s.contains(g2));
        Assert.assertEquals((long)1L, (long)s.size());
        Assert.assertFalse((boolean)s.contains(g3));
        Assert.assertTrue((boolean)s.add(g3));
        Assert.assertTrue((boolean)s.contains(g3));
        Assert.assertEquals((long)2L, (long)s.size());
    }

    @Test
    public void eventGroupComparison() throws InterruptedException, ObjectStoreException {
        String uuid = UUID.getUUID();
        EventGroup g1 = new EventGroup((Object)uuid, muleContext);
        g1.initEventsStore(this.objectStore);
        EventGroup g2 = new EventGroup((Object)uuid, muleContext);
        g2.initEventsStore(this.objectStore);
        EventGroup g3 = new EventGroup((Object)UUID.getUUID(), muleContext);
        g3.initEventsStore(this.objectStore);
        try {
            g1.compareTo(null);
            Assert.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)g1.compareTo(g2));
        Assert.assertTrue((g1.compareTo(g3) != 0 ? 1 : 0) != 0);
        Assert.assertTrue((g3.compareTo(g1) != 0 ? 1 : 0) != 0);
        Assert.assertTrue((g3.compareTo(g2) != 0 ? 1 : 0) != 0);
        g1 = new EventGroup(new Object(), muleContext);
        Thread.sleep(10L);
        g2 = new EventGroup(new Object(), muleContext);
        Assert.assertTrue((g1.compareTo(g2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((g2.compareTo(g1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void eventGroupConversionToArray() throws Exception {
        EventGroup eg = new EventGroup((Object)UUID.getUUID(), muleContext);
        eg.initEventsStore(this.objectStore);
        eg.addEvent(MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"foo1")).build());
        eg.addEvent(MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"foo2")).build());
        Object[] array1 = IteratorUtils.toArray((Iterator)eg.iterator(false));
        Object[] array2 = eg.toArray(false);
        Assert.assertTrue((boolean)Arrays.equals(array1, array2));
    }

    @Test
    public void eventGroupConversionToString() throws Exception {
        EventGroup eg = new EventGroup((Object)UUID.getUUID(), muleContext);
        eg.initEventsStore(this.objectStore);
        String es = eg.toString();
        Assert.assertTrue((boolean)es.endsWith("events=0}"));
        CoreEvent firstEvent = MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"foo")).build();
        String firstId = firstEvent.getCorrelationId();
        eg.addEvent(firstEvent);
        es = eg.toString();
        Assert.assertTrue((boolean)es.contains("events=1"));
        Assert.assertTrue((boolean)es.endsWith("[" + firstId + "]}"));
        CoreEvent secondEvent = MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"foo2")).build();
        String secondId = secondEvent.getCorrelationId();
        eg.addEvent(secondEvent);
        es = eg.toString();
        Assert.assertTrue((boolean)es.contains("events=2"));
        Assert.assertTrue((boolean)es.contains(firstId));
        Assert.assertTrue((boolean)es.contains(secondId));
    }

    @Test
    public void mergedSessions() throws Exception {
        EventGroup eg = new EventGroup((Object)UUID.getUUID(), muleContext);
        eg.initEventsStore(this.objectStore);
        Assert.assertFalse((boolean)eg.iterator().hasNext());
        PrivilegedEvent event1 = (PrivilegedEvent)MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"foo1")).build();
        PrivilegedEvent event2 = (PrivilegedEvent)MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"foo2")).build();
        PrivilegedEvent event3 = (PrivilegedEvent)MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"foo3")).build();
        event1.getSession().setProperty("key1", (Serializable)((Object)"value1"));
        event1.getSession().setProperty("key2", (Serializable)((Object)"value2"));
        event2.getSession().setProperty("KEY2", (Serializable)((Object)"value2NEW"));
        event2.getSession().setProperty("key3", (Serializable)((Object)"value3"));
        event3.getSession().setProperty("key4", (Serializable)((Object)"value4"));
        eg.addEvent((CoreEvent)event1);
        System.out.println(event1.getSession());
        eg.addEvent((CoreEvent)event2);
        System.out.println(event2.getSession());
        eg.addEvent((CoreEvent)event3);
        System.out.println(event3.getSession());
        PrivilegedEvent result = (PrivilegedEvent)eg.getMessageCollectionEvent();
        Assert.assertEquals((Object)"value1", (Object)result.getSession().getProperty("key1"));
        Assert.assertEquals((Object)"value3", (Object)result.getSession().getProperty("key3"));
        Assert.assertEquals((Object)"value4", (Object)result.getSession().getProperty("key4"));
    }

    @Test
    public void arrivalOrderEvents() throws Exception {
        EventGroup eventGroup = new EventGroup((Object)UUID.getUUID(), muleContext);
        eventGroup.initEventsStore(this.objectStore);
        for (int i = 0; i < 3; ++i) {
            eventGroup.addEvent(MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)("foo" + i))).build());
        }
        CoreEvent result = eventGroup.getMessageCollectionEvent();
        Message message = result.getMessage();
        List messages = (List)message.getPayload().getValue();
        Assert.assertThat((Object)messages.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)((Message)messages.get(0)).getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"foo0"));
        Assert.assertThat((Object)((Message)messages.get(1)).getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"foo1"));
        Assert.assertThat((Object)((Message)messages.get(2)).getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"foo2"));
    }

    @Test
    public void isDisposedEventGroupPartition() throws Exception {
        EventGroup eventGroup = new EventGroup((Object)UUID.getUUID(), muleContext);
        PartitionableObjectStore objectStore = (PartitionableObjectStore)Mockito.mock(PartitionableObjectStore.class);
        eventGroup.initEventsStore(objectStore);
        eventGroup.clear();
        ((PartitionableObjectStore)Mockito.verify((Object)objectStore)).disposePartition(Matchers.anyString());
    }

    private static class MyEventGroup
    extends EventGroup {
        private static final long serialVersionUID = 1L;

        public MyEventGroup(Object groupId) {
            super(groupId, muleContext);
        }

        public MyEventGroup(Object groupId, int expectedSize) {
            super(groupId, muleContext, Optional.of(expectedSize), "EventGroupTestCase");
        }
    }
}

