/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.message.ExceptionPayload;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.message.DefaultExceptionPayload;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.internal.routing.FirstSuccessful;
import org.mule.runtime.core.privileged.event.DefaultMuleSession;
import org.mule.runtime.core.privileged.event.MuleSession;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.routing.CouldNotRouteOutboundMessageException;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.util.MuleContextUtils;

public class FirstSuccessfulTestCase
extends AbstractMuleContextTestCase {
    private static final String EXCEPTION_SEEN = "EXCEPTION WAS SEEN";

    public FirstSuccessfulTestCase() {
        this.setStartContext(true);
    }

    @Test
    public void testFirstSuccessful() throws Exception {
        DefaultMuleSession session = new DefaultMuleSession();
        FirstSuccessful fs = this.createFirstSuccessfulRouter(new TestProcessor("abc"), new TestProcessor("def"), new TestProcessor("ghi"));
        fs.initialise();
        Assert.assertThat((Object)this.getPayload((Processor)fs, (MuleSession)session, ""), (Matcher)Matchers.is((Object)"No abc"));
        Assert.assertThat((Object)this.getPayload((Processor)fs, (MuleSession)session, "abc"), (Matcher)Matchers.is((Object)"No def"));
        Assert.assertThat((Object)this.getPayload((Processor)fs, (MuleSession)session, "abcdef"), (Matcher)Matchers.is((Object)"No ghi"));
        Assert.assertThat((Object)this.getPayload((Processor)fs, (MuleSession)session, "abcdefghi"), (Matcher)Matchers.is((Object)EXCEPTION_SEEN));
        Assert.assertThat((Object)this.getPayload((Processor)fs, (MuleSession)session, "ABC"), (Matcher)Matchers.is((Object)"No def"));
        Assert.assertThat((Object)this.getPayload((Processor)fs, (MuleSession)session, "ABCDEF"), (Matcher)Matchers.is((Object)"No ghi"));
        Assert.assertThat((Object)this.getPayload((Processor)fs, (MuleSession)session, "ABCDEFGHI"), (Matcher)Matchers.is((Object)EXCEPTION_SEEN));
    }

    @Test
    public void testRouteReturnsNullEvent() throws Exception {
        Processor nullReturningMp = event -> null;
        FirstSuccessful fs = this.createFirstSuccessfulRouter(nullReturningMp);
        fs.setAnnotations(FirstSuccessfulTestCase.getAppleFlowComponentLocationAnnotations());
        fs.initialise();
        Assert.assertThat((Object)fs.process(this.testEvent()), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testRouteReturnsNullMessage() throws Exception {
        Processor nullEventMp = event -> CoreEvent.builder((CoreEvent)event).message(null).build();
        FirstSuccessful fs = this.createFirstSuccessfulRouter(nullEventMp);
        fs.setAnnotations(FirstSuccessfulTestCase.getAppleFlowComponentLocationAnnotations());
        fs.initialise();
        try {
            fs.process(this.testEvent());
            Assert.fail((String)"Exception expected");
        }
        catch (CouldNotRouteOutboundMessageException couldNotRouteOutboundMessageException) {
            // empty catch block
        }
    }

    private FirstSuccessful createFirstSuccessfulRouter(Processor ... processors) throws Exception {
        FirstSuccessful fs = new FirstSuccessful();
        fs.setAnnotations(FirstSuccessfulTestCase.getAppleFlowComponentLocationAnnotations());
        FlowConstruct flow = (FlowConstruct)Mockito.mock(FlowConstruct.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Component.class}));
        Mockito.when((Object)flow.getMuleContext()).thenReturn((Object)muleContext);
        Mockito.when((Object)flow.getLocation()).thenReturn((Object)TEST_CONNECTOR_LOCATION);
        fs.setMuleContext(muleContext);
        fs.setRoutes(Arrays.asList(processors));
        return fs;
    }

    private String getPayload(Processor mp, MuleSession session, String message) throws Exception {
        Message msg = Message.of((Object)message);
        try {
            CoreEvent event = mp.process((CoreEvent)((PrivilegedEvent.Builder)this.getEventBuilder()).message(msg).session(session).build());
            Message returnedMessage = event.getMessage();
            if (event.getError().isPresent()) {
                return EXCEPTION_SEEN;
            }
            return this.getPayloadAsString(returnedMessage);
        }
        catch (Exception ex) {
            return EXCEPTION_SEEN;
        }
    }

    private static class TestProcessor
    implements Processor {
        private String rejectIfMatches;

        TestProcessor(String rejectIfMatches) {
            this.rejectIfMatches = rejectIfMatches;
        }

        public CoreEvent process(CoreEvent event) throws MuleException {
            try {
                Message msg;
                Error error = null;
                String payload = ((InternalEvent)event).getMessageAsString(muleContext);
                if (payload.indexOf(this.rejectIfMatches) >= 0) {
                    throw new DefaultMuleException("Saw " + this.rejectIfMatches);
                }
                if (payload.toLowerCase().indexOf(this.rejectIfMatches) >= 0) {
                    Exception exception = new Exception();
                    error = MuleTestUtils.createErrorMock((Exception)exception);
                    msg = InternalMessage.builder().nullValue().exceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)exception)).build();
                } else {
                    msg = Message.of((Object)("No " + this.rejectIfMatches));
                }
                CoreEvent muleEvent = MuleContextUtils.eventBuilder((MuleContext)muleContext).message(msg).error(error).build();
                return muleEvent;
            }
            catch (Exception e) {
                throw new DefaultMuleException((Throwable)e);
            }
        }
    }
}

