/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.nio.BufferOverflowException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.internal.routing.Foreach;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.processor.InternalProcessor;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.tck.SensingNullMessageProcessor;
import org.mule.tck.junit4.AbstractReactiveProcessorTestCase;
import org.mule.tck.junit4.matcher.DataTypeCompatibilityMatcher;
import org.mule.tck.testmodels.mule.TestMessageProcessor;
import org.mule.tck.util.MuleContextUtils;

public class ForeachTestCase
extends AbstractReactiveProcessorTestCase {
    protected Foreach simpleForeach;
    protected Foreach nestedForeach;
    protected ArrayList<CoreEvent> processedEvents;
    protected Map<String, TypedValue<?>> variables;
    private static String ERR_NUMBER_MESSAGES = "Not a correct number of messages processed";
    private static String ERR_PAYLOAD_TYPE = "Type error on processed payloads";
    private static String ERR_OUTPUT = "Messages processed incorrectly";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    public ForeachTestCase(AbstractReactiveProcessorTestCase.Mode mode) {
        super(mode);
    }

    @Before
    public void initialise() throws MuleException {
        this.processedEvents = new ArrayList();
        this.simpleForeach = this.createForeach(this.getSimpleMessageProcessors((Processor)new TestMessageProcessor("zas")));
        this.nestedForeach = this.createForeach(this.getNestedMessageProcessors());
    }

    private List<Processor> getSimpleMessageProcessors(Processor innerProcessor) {
        ArrayList<Processor> lmp = new ArrayList<Processor>();
        lmp.add(event -> {
            String payload = event.getMessage().getPayload().getValue() instanceof List ? ((List)event.getMessage().getPayload().getValue()).stream().map(typeValue -> typeValue.getValue()).collect(Collectors.toList()).toString() : event.getMessage().getPayload().getValue().toString();
            event = CoreEvent.builder((CoreEvent)event).message((Message)InternalMessage.builder((Message)event.getMessage()).value((Object)(payload + ":foo")).build()).build();
            return event;
        });
        lmp.add(innerProcessor);
        lmp.add(event -> {
            this.variables = event.getVariables();
            this.processedEvents.add(event);
            return event;
        });
        return lmp;
    }

    private List<Processor> getNestedMessageProcessors() throws MuleException {
        ArrayList<Processor> lmp = new ArrayList<Processor>();
        Foreach internalForeach = this.createForeach();
        internalForeach.setMessageProcessors(this.getSimpleMessageProcessors((Processor)new TestMessageProcessor("zas")));
        lmp.add((Processor)internalForeach);
        return lmp;
    }

    private Foreach createForeach(List<Processor> mps) throws MuleException {
        Foreach foreachMp = this.createForeach();
        foreachMp.setMessageProcessors(mps);
        LifecycleUtils.initialiseIfNeeded((Object)foreachMp, (MuleContext)muleContext);
        return foreachMp;
    }

    @Test
    public void arrayListPayload() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("bar");
        arrayList.add("zip");
        this.process((Processor)this.simpleForeach, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of(arrayList)).build());
        this.assertSimpleProcessedMessages();
    }

    @Test
    public void arrayPayload() throws Exception {
        String[] array = new String[]{"bar", "zip"};
        this.process((Processor)this.simpleForeach, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)array)).build());
        this.assertSimpleProcessedMessages();
    }

    @Test
    public void muleMessageCollectionPayload() throws Exception {
        ArrayList<Message> list = new ArrayList<Message>();
        list.add(Message.of((Object)"bar"));
        list.add(Message.of((Object)"zip"));
        this.process((Processor)this.simpleForeach, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of(list)).build());
        this.assertSimpleProcessedMessages();
    }

    @Test
    public void iterablePayload() throws Exception {
        DummySimpleIterableClass iterable = new DummySimpleIterableClass();
        CoreEvent testEvent = MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)iterable)).build();
        this.process((Processor)this.simpleForeach, testEvent);
        this.assertSimpleProcessedMessages();
    }

    @Test
    public void iteratorPayload() throws Exception {
        DummySimpleIterableClass iterable = new DummySimpleIterableClass();
        this.process((Processor)this.simpleForeach, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of(iterable.iterator())).build());
        this.assertSimpleProcessedMessages();
    }

    @Test
    public void mapPayload() throws Exception {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Foreach does not support 'java.util.Map' with no collection expression. To iterate over Map entries use '#[dw::core::Objects::entrySet(payload)]'");
        this.process((Processor)this.simpleForeach, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of(Collections.singletonMap("foo", "bar"))).build());
    }

    @Test
    public void mapEntrySetExpression() throws Exception {
        this.simpleForeach.setCollectionExpression("#[dw::core::Objects::entrySet(payload)]");
        this.simpleForeach.initialise();
        this.process((Processor)this.simpleForeach, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of(Collections.singletonMap("foo", "bar"))).build());
    }

    @Test
    public void nestedArrayListPayload() throws Exception {
        ArrayList payload = new ArrayList();
        ArrayList<String> elem1 = new ArrayList<String>();
        ArrayList<String> elem2 = new ArrayList<String>();
        ArrayList<String> elem3 = new ArrayList<String>();
        elem1.add("a1");
        elem1.add("a2");
        elem1.add("a3");
        elem2.add("b1");
        elem2.add("b2");
        elem3.add("c1");
        payload.add(elem1);
        payload.add(elem2);
        payload.add(elem3);
        this.process((Processor)this.nestedForeach, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of(payload)).build());
        this.assertNestedProcessedMessages();
    }

    @Test
    public void nestedArrayPayload() throws Exception {
        String[][] payload = new String[3][2];
        payload[0][0] = "a1";
        payload[0][1] = "a2";
        payload[1][0] = "a3";
        payload[1][1] = "b1";
        payload[2][0] = "b2";
        payload[2][1] = "c1";
        this.process((Processor)this.nestedForeach, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)payload)).build());
        this.assertNestedProcessedMessages();
    }

    @Test
    public void nestedMuleMessageCollectionPayload() throws Exception {
        ArrayList<Message> parentList = new ArrayList<Message>();
        ArrayList<Message> list1 = new ArrayList<Message>();
        ArrayList<Message> list2 = new ArrayList<Message>();
        list1.add(Message.of((Object)"a1"));
        list1.add(Message.of((Object)"a2"));
        list1.add(Message.of((Object)"a3"));
        list2.add(Message.of((Object)"b1"));
        list2.add(Message.of((Object)"b2"));
        list2.add(Message.of((Object)"c1"));
        parentList.add(Message.of(list1));
        parentList.add(Message.of(list2));
        Message parentCollection = Message.of(parentList);
        this.process((Processor)this.nestedForeach, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(parentCollection).build());
        this.assertNestedProcessedMessages();
    }

    @Test
    public void nestedIterablePayload() throws Exception {
        DummyNestedIterableClass iterable = new DummyNestedIterableClass();
        this.process((Processor)this.nestedForeach, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)iterable)).build());
        this.assertNestedProcessedMessages();
    }

    @Test
    public void nestedIteratorPayload() throws Exception {
        DummyNestedIterableClass iterable = new DummyNestedIterableClass();
        this.process((Processor)this.nestedForeach, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)iterable)).build());
        this.assertNestedProcessedMessages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void failingNestedProcessor() throws Exception {
        BufferOverflowException throwable = new BufferOverflowException();
        Foreach foreach = this.createForeach();
        SensingNullMessageProcessor firstProcessor = new SensingNullMessageProcessor();
        InternalTestProcessor failingProcessor = event -> {
            throw throwable;
        };
        foreach.setMessageProcessors(Arrays.asList(firstProcessor, failingProcessor));
        LifecycleUtils.initialiseIfNeeded((Object)foreach, (MuleContext)muleContext);
        try {
            this.expectNestedProessorException(throwable, failingProcessor);
            this.process((Processor)foreach, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of(new DummyNestedIterableClass().iterator())).build(), false);
        }
        finally {
            Assert.assertThat((Object)firstProcessor.invocations, (Matcher)Matchers.equalTo((Object)1));
        }
    }

    private void expectNestedProessorException(RuntimeException throwable, InternalTestProcessor failingProcessor) {
        this.expectedException.expect(CoreMatchers.is(MessagingException.class));
        this.expectedException.expect((Matcher)new FailingProcessorMatcher(failingProcessor));
        this.expectedException.expectCause(CoreMatchers.is((Object)throwable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void failingNestedProcessorInChain() throws Exception {
        BufferOverflowException throwable = new BufferOverflowException();
        Foreach foreach = this.createForeach();
        SensingNullMessageProcessor firstProcessor = new SensingNullMessageProcessor();
        InternalTestProcessor failingProcessor = event -> {
            throw throwable;
        };
        foreach.setMessageProcessors(Arrays.asList(firstProcessor, failingProcessor));
        LifecycleUtils.initialiseIfNeeded((Object)foreach, (MuleContext)muleContext);
        try {
            this.expectNestedProessorException(throwable, failingProcessor);
            this.processInChain((Processor)foreach, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of(new DummyNestedIterableClass().iterator())).build());
        }
        finally {
            Assert.assertThat((Object)firstProcessor.invocations, (Matcher)Matchers.equalTo((Object)1));
        }
    }

    private Foreach createForeach() {
        Foreach foreach = new Foreach();
        foreach.setAnnotations(ForeachTestCase.getAppleFlowComponentLocationAnnotations());
        return foreach;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void failingExpression() throws Exception {
        Foreach foreach = this.createForeach();
        foreach.setCollectionExpression("!@INVALID");
        SensingNullMessageProcessor firstProcessor = new SensingNullMessageProcessor();
        List<Processor> processors = this.getSimpleMessageProcessors((Processor)new TestMessageProcessor("zas"));
        processors.add(0, (Processor)firstProcessor);
        foreach.setMessageProcessors(processors);
        LifecycleUtils.initialiseIfNeeded((Object)foreach, (MuleContext)muleContext);
        try {
            this.expectExpressionException(foreach);
            this.process((Processor)foreach, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of(new DummyNestedIterableClass().iterator())).build(), false);
        }
        finally {
            Assert.assertThat((Object)firstProcessor.invocations, (Matcher)Matchers.equalTo((Object)0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void failingExpressionInChain() throws Exception {
        Foreach foreach = this.createForeach();
        foreach.setCollectionExpression("!@INVALID");
        SensingNullMessageProcessor firstProcessor = new SensingNullMessageProcessor();
        List<Processor> processors = this.getSimpleMessageProcessors((Processor)new TestMessageProcessor("zas"));
        processors.add(0, (Processor)firstProcessor);
        foreach.setMessageProcessors(processors);
        LifecycleUtils.initialiseIfNeeded((Object)foreach, (MuleContext)muleContext);
        try {
            this.expectExpressionException(foreach);
            this.processInChain((Processor)foreach, MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of(new DummyNestedIterableClass().iterator())).build());
        }
        finally {
            Assert.assertThat((Object)firstProcessor.invocations, (Matcher)Matchers.equalTo((Object)0));
        }
    }

    private void expectExpressionException(Foreach foreach) {
        this.expectedException.expect(CoreMatchers.instanceOf(MessagingException.class));
        this.expectedException.expect((Matcher)new FailingProcessorMatcher((Processor)foreach));
        this.expectedException.expectCause(CoreMatchers.instanceOf(ExpressionRuntimeException.class));
    }

    @Test
    public void batchSize() throws Exception {
        Foreach foreachMp = this.createForeach();
        List<Processor> processors = this.getSimpleMessageProcessors((Processor)new TestMessageProcessor("zas"));
        foreachMp.setMessageProcessors(processors);
        foreachMp.setBatchSize(2);
        LifecycleUtils.initialiseIfNeeded((Object)foreachMp, (MuleContext)muleContext);
        foreachMp.process(MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of(Arrays.asList(1, 2, 3))).build());
        Assert.assertThat(this.processedEvents, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)((PrivilegedEvent)this.processedEvents.get(0)).getMessageAsString(muleContext), (Matcher)CoreMatchers.is((Object)"[1, 2]:foo:zas"));
        Assert.assertThat((Object)((PrivilegedEvent)this.processedEvents.get(1)).getMessageAsString(muleContext), (Matcher)CoreMatchers.is((Object)"[3]:foo:zas"));
    }

    @Test
    public void batchSizeWithCollectionAttributes() throws Exception {
        Foreach foreachMp = this.createForeach();
        List<Processor> processors = this.getSimpleMessageProcessors((Processor)new TestMessageProcessor("zas"));
        foreachMp.setMessageProcessors(processors);
        foreachMp.setBatchSize(2);
        foreachMp.setCollectionExpression("vars.collection");
        LifecycleUtils.initialiseIfNeeded((Object)foreachMp, (MuleContext)muleContext);
        foreachMp.process(MuleContextUtils.eventBuilder((MuleContext)muleContext).addVariable("collection", Arrays.asList(1, 2, 3)).message(Message.of(null)).build());
        Assert.assertThat(this.processedEvents, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)((PrivilegedEvent)this.processedEvents.get(0)).getMessageAsString(muleContext), (Matcher)CoreMatchers.is((Object)"[1, 2]:foo:zas"));
        Assert.assertThat((Object)((PrivilegedEvent)this.processedEvents.get(1)).getMessageAsString(muleContext), (Matcher)CoreMatchers.is((Object)"[3]:foo:zas"));
    }

    @Test
    public void variables() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("bar");
        arrayList.add("zip");
        CoreEvent in = MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of(arrayList)).build();
        this.process((Processor)this.simpleForeach, in);
        this.assertSimpleProcessedMessages();
        Assert.assertThat(this.variables.keySet(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat(this.variables.keySet(), (Matcher)Matchers.hasItems((Object[])new String[]{"rootMessage", "counter"}));
        Assert.assertThat((Object)this.variables.get("rootMessage").getDataType(), (Matcher)CoreMatchers.is((Matcher)DataTypeCompatibilityMatcher.assignableTo((DataType)DataType.MULE_MESSAGE)));
        Assert.assertThat((Object)this.variables.get("rootMessage").getValue(), (Matcher)Matchers.equalTo((Object)in.getMessage()));
        Assert.assertThat((Object)this.variables.get("counter").getDataType(), (Matcher)Matchers.equalTo((Object)DataType.builder().type(Integer.class).build()));
        Assert.assertThat((Object)this.variables.get("counter").getValue(), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void empty() throws Exception {
        CoreEvent input = MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of(Collections.emptyList())).build();
        CoreEvent result = this.process((Processor)this.simpleForeach, input);
        Assert.assertThat((Object)result.getMessage(), (Matcher)Matchers.equalTo((Object)input.getMessage()));
        Assert.assertThat(this.processedEvents, (Matcher)Matchers.hasSize((int)0));
    }

    private CoreEvent processInChain(Processor processor, CoreEvent event) throws Exception {
        return this.process((Processor)MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{processor}), event, false);
    }

    private void assertSimpleProcessedMessages() {
        Assert.assertEquals((String)ERR_NUMBER_MESSAGES, (long)2L, (long)this.processedEvents.size());
        Assert.assertTrue((String)ERR_PAYLOAD_TYPE, (boolean)(this.processedEvents.get(0).getMessage().getPayload().getValue() instanceof String));
        Assert.assertTrue((String)ERR_PAYLOAD_TYPE, (boolean)(this.processedEvents.get(1).getMessage().getPayload().getValue() instanceof String));
        Assert.assertEquals((String)ERR_OUTPUT, (Object)"bar:foo:zas", (Object)this.processedEvents.get(0).getMessage().getPayload().getValue());
        Assert.assertEquals((String)ERR_OUTPUT, (Object)"zip:foo:zas", (Object)this.processedEvents.get(1).getMessage().getPayload().getValue());
    }

    private void assertNestedProcessedMessages() {
        int i;
        String[] expectedOutputs = new String[]{"a1:foo:zas", "a2:foo:zas", "a3:foo:zas", "b1:foo:zas", "b2:foo:zas", "c1:foo:zas"};
        Assert.assertEquals((String)ERR_NUMBER_MESSAGES, (long)6L, (long)this.processedEvents.size());
        for (i = 0; i < this.processedEvents.size(); ++i) {
            Assert.assertTrue((String)ERR_PAYLOAD_TYPE, (boolean)(this.processedEvents.get(i).getMessage().getPayload().getValue() instanceof String));
        }
        for (i = 0; i < this.processedEvents.size(); ++i) {
            Assert.assertEquals((String)ERR_OUTPUT, (Object)expectedOutputs[i], (Object)this.processedEvents.get(i).getMessage().getPayload().getValue());
        }
    }

    @FunctionalInterface
    private static interface InternalTestProcessor
    extends Processor,
    InternalProcessor {
    }

    private static class FailingProcessorMatcher
    extends BaseMatcher<MessagingException> {
        private Processor expectedFailingProcessor;

        FailingProcessorMatcher(Processor processor) {
            this.expectedFailingProcessor = processor;
        }

        public boolean matches(Object o) {
            return o instanceof MessagingException && ((MessagingException)o).getFailingComponent() == this.expectedFailingProcessor;
        }

        public void describeTo(Description description) {
            description.appendText("Exception is not a MessagingException or failing processor does not match.");
        }
    }

    private class DummyNestedIterableClass
    implements Iterable<DummySimpleIterableClass> {
        private List<DummySimpleIterableClass> iterables = new ArrayList<DummySimpleIterableClass>();

        public DummyNestedIterableClass() {
            DummySimpleIterableClass dsi1 = new DummySimpleIterableClass();
            dsi1.strings = new ArrayList<String>();
            dsi1.strings.add("a1");
            dsi1.strings.add("a2");
            DummySimpleIterableClass dsi2 = new DummySimpleIterableClass();
            dsi2.strings = new ArrayList<String>();
            dsi2.strings.add("a3");
            dsi2.strings.add("b1");
            dsi2.strings.add("b2");
            dsi2.strings.add("c1");
            this.iterables.add(dsi1);
            this.iterables.add(dsi2);
        }

        @Override
        public Iterator<DummySimpleIterableClass> iterator() {
            return this.iterables.iterator();
        }
    }

    public class DummySimpleIterableClass
    implements Iterable<String> {
        public List<String> strings = new ArrayList<String>();

        public DummySimpleIterableClass() {
            this.strings.add("bar");
            this.strings.add("zip");
        }

        @Override
        public Iterator<String> iterator() {
            return this.strings.iterator();
        }
    }
}

