/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.store.ObjectAlreadyExistsException;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.TemplateObjectStore;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.internal.routing.IdempotentMessageValidator;
import org.mule.runtime.core.internal.routing.ValidationException;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class IdempotentMessageValidatorMule6079TestCase
extends AbstractMuleContextTestCase {
    private ObjectStore<String> objectStore;
    private IdempotentMessageValidator validator;
    private AtomicInteger processedEvents = new AtomicInteger(0);
    private Boolean errorHappenedInChildThreads = false;

    @Test
    public void testRaceConditionOnAcceptAndProcess() throws Exception {
        CountDownLatch cdl = new CountDownLatch(2);
        this.objectStore = new RaceConditionEnforcingObjectStore(cdl);
        this.validator = new IdempotentMessageValidator();
        this.validator.setMuleContext(muleContext);
        this.validator.setStorePrefix("foo");
        this.validator.setObjectStore(this.objectStore);
        Thread t1 = new Thread((Runnable)new TestForRaceConditionRunnable(), "thread1");
        Thread t2 = new Thread((Runnable)new TestForRaceConditionRunnable(), "thread2");
        t1.start();
        t2.start();
        t1.join(5000L);
        t2.join(5000L);
        Assert.assertThat((String)"Exception in child threads", (Object)this.errorHappenedInChildThreads, (Matcher)Matchers.is((Object)false));
        Assert.assertThat((String)"None or more than one message was processed by IdempotentMessageValidator", (Object)this.processedEvents.get(), (Matcher)Matchers.is((Object)1));
    }

    private class RaceConditionEnforcingObjectStore
    extends TemplateObjectStore<String> {
        protected CountDownLatch barrier;
        Map<String, String> map = new TreeMap<String, String>();

        public RaceConditionEnforcingObjectStore(CountDownLatch latch) {
            this.barrier = latch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean doContains(String key) throws ObjectStoreException {
            boolean containsKey;
            RaceConditionEnforcingObjectStore raceConditionEnforcingObjectStore = this;
            synchronized (raceConditionEnforcingObjectStore) {
                containsKey = this.map.containsKey(key);
                if (containsKey) {
                    this.barrier.countDown();
                }
            }
            return containsKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doStore(String key, String value) throws ObjectStoreException {
            boolean wasAdded;
            if (key == null) {
                throw new ObjectStoreException();
            }
            RaceConditionEnforcingObjectStore raceConditionEnforcingObjectStore = this;
            synchronized (raceConditionEnforcingObjectStore) {
                wasAdded = this.map.containsKey(key);
                this.map.put(key, value);
            }
            this.barrier.countDown();
            try {
                this.barrier.await();
            }
            catch (Exception e) {
                Boolean bl = IdempotentMessageValidatorMule6079TestCase.this.errorHappenedInChildThreads;
                synchronized (bl) {
                    IdempotentMessageValidatorMule6079TestCase.this.errorHappenedInChildThreads = true;
                }
            }
            if (wasAdded) {
                throw new ObjectAlreadyExistsException();
            }
        }

        protected String doRetrieve(String key) throws ObjectStoreException {
            return null;
        }

        protected String doRemove(String key) throws ObjectStoreException {
            return null;
        }

        public boolean isPersistent() {
            return false;
        }

        public void clear() throws ObjectStoreException {
            this.map.clear();
        }

        public void open() throws ObjectStoreException {
        }

        public void close() throws ObjectStoreException {
        }

        public List<String> allKeys() throws ObjectStoreException {
            return new ArrayList<String>(this.map.keySet());
        }

        public Map<String, String> retrieveAll() throws ObjectStoreException {
            return Collections.unmodifiableMap(this.map);
        }
    }

    private class TestForRaceConditionRunnable
    implements Runnable {
        private TestForRaceConditionRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InternalMessage okMessage = InternalMessage.builder().value((Object)"OK").build();
            BaseEventContext context = (BaseEventContext)Mockito.mock(BaseEventContext.class);
            Mockito.when((Object)context.getCorrelationId()).thenReturn((Object)"1");
            CoreEvent event = CoreEvent.builder((EventContext)context).message((Message)okMessage).build();
            try {
                event = IdempotentMessageValidatorMule6079TestCase.this.validator.process(event);
            }
            catch (ValidationException e) {
                if (event != null) {
                    IdempotentMessageValidatorMule6079TestCase.this.processedEvents.incrementAndGet();
                }
                return;
            }
            catch (Throwable e) {
                e.printStackTrace();
                Boolean bl = IdempotentMessageValidatorMule6079TestCase.this.errorHappenedInChildThreads;
                synchronized (bl) {
                    IdempotentMessageValidatorMule6079TestCase.this.errorHappenedInChildThreads = true;
                }
            }
        }
    }
}

