/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.el.DefaultExpressionLanguageFactoryService;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.internal.el.dataweave.DataWeaveExpressionLanguageAdaptor;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.internal.routing.IdempotentMessageValidator;
import org.mule.runtime.core.internal.routing.ValidationException;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.tck.core.util.store.InMemoryObjectStore;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.weave.v2.el.ByteArrayBasedCursorStreamProvider;
import org.mule.weave.v2.el.WeaveDefaultExpressionLanguageFactoryService;

public class IdempotentMessageValidatorTestCase
extends AbstractMuleContextTestCase {
    private static IdempotentMessageValidator idempotent;
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @Before
    public void reset() {
        idempotent = new IdempotentMessageValidator();
        idempotent.setStorePrefix("foo");
        idempotent.setObjectStore((ObjectStore)new InMemoryObjectStore());
        idempotent.setMuleContext(muleContext);
    }

    @Test
    public void idempotentReceiver() throws Exception {
        BaseEventContext contextA = (BaseEventContext)Mockito.mock(BaseEventContext.class);
        Mockito.when((Object)contextA.getCorrelationId()).thenReturn((Object)"1");
        InternalMessage okMessage = InternalMessage.builder().value((Object)"OK").build();
        CoreEvent event = CoreEvent.builder((EventContext)contextA).message((Message)okMessage).build();
        CoreEvent processedEvent = idempotent.process(event);
        Assert.assertThat((Object)processedEvent, (Matcher)Matchers.sameInstance((Object)event));
        BaseEventContext contextB = (BaseEventContext)Mockito.mock(BaseEventContext.class);
        Mockito.when((Object)contextB.getCorrelationId()).thenReturn((Object)"1");
        event = CoreEvent.builder((EventContext)contextB).message((Message)okMessage).build();
        this.expected.expect(ValidationException.class);
        processedEvent = idempotent.process(event);
    }

    @Test
    public void testIdCheckWithMEL() throws Exception {
        String melExpression = "#[payload]";
        BaseEventContext context = (BaseEventContext)Mockito.mock(BaseEventContext.class);
        Mockito.when((Object)context.getCorrelationId()).thenReturn((Object)"1");
        Message okMessage = Message.of((Object)"OK");
        CoreEvent event = CoreEvent.builder((EventContext)context).message(okMessage).build();
        idempotent.setIdExpression(melExpression);
        CoreEvent processedEvent = idempotent.process(event);
        Assert.assertNotNull((Object)processedEvent);
        Assert.assertEquals((Object)idempotent.getObjectStore().retrieve("OK"), (Object)"1");
        okMessage = Message.of((Object)"OK");
        event = CoreEvent.builder((EventContext)context).message(okMessage).build();
        this.expected.expect(ValidationException.class);
        processedEvent = idempotent.process(event);
    }

    @Test
    public void testIdCheckWithDW() throws Exception {
        String dwExpression = "%dw 2.0\noutput application/text\n---\npayload ++ ' World'";
        BaseEventContext context = (BaseEventContext)Mockito.mock(BaseEventContext.class);
        Mockito.when((Object)context.getCorrelationId()).thenReturn((Object)"1");
        Message okMessage = Message.of((Object)"Hello");
        CoreEvent event = CoreEvent.builder((EventContext)context).message(okMessage).build();
        idempotent.setIdExpression(dwExpression);
        CoreEvent processedEvent = idempotent.process(event);
        Assert.assertNotNull((Object)processedEvent);
        Assert.assertEquals((Object)idempotent.getObjectStore().retrieve("Hello World"), (Object)"1");
        okMessage = Message.of((Object)"Hello");
        event = CoreEvent.builder((EventContext)context).message(okMessage).build();
        this.expected.expect(ValidationException.class);
        processedEvent = idempotent.process(event);
    }

    @Test
    public void testIdCheckWithHash() throws Exception {
        String dwHashExpression = "%dw 2.0\noutput text/plain\nimport dw::Crypto\n---\nCrypto::hashWith(payload,'SHA-256')";
        String payload = "payload to be hashed";
        BaseEventContext context = (BaseEventContext)Mockito.mock(BaseEventContext.class);
        Mockito.when((Object)context.getCorrelationId()).thenReturn((Object)"1");
        Message message = Message.of((Object)payload);
        CoreEvent event = CoreEvent.builder((EventContext)context).message(message).build();
        idempotent.setIdExpression(dwHashExpression);
        DataWeaveExpressionLanguageAdaptor expressionLanguageAdaptor = new DataWeaveExpressionLanguageAdaptor(muleContext, (Registry)Mockito.mock(Registry.class), (DefaultExpressionLanguageFactoryService)new WeaveDefaultExpressionLanguageFactoryService());
        TypedValue hashedValue = expressionLanguageAdaptor.evaluate(dwHashExpression, event, BindingContextUtils.NULL_BINDING_CONTEXT);
        CoreEvent processedEvent = idempotent.process(event);
        Assert.assertNotNull((Object)processedEvent);
        Assert.assertEquals((Object)idempotent.getObjectStore().retrieve(IOUtils.toString((CursorStreamProvider)((ByteArrayBasedCursorStreamProvider)hashedValue.getValue()))), (Object)"1");
        message = Message.of((Object)payload);
        event = CoreEvent.builder((EventContext)context).message(message).build();
        this.expected.expect(ValidationException.class);
        processedEvent = idempotent.process(event);
    }

    @Test
    public void differentIdsShouldBeStored() throws Exception {
        String dwHashExpression = "%dw 2.0\noutput text/plain\nimport dw::Crypto\n---\nCrypto::SHA1(payload)";
        String payload = "payload to be hashed";
        String otherPayload = "this is another payload to be hashed";
        BaseEventContext context = (BaseEventContext)Mockito.mock(BaseEventContext.class);
        Mockito.when((Object)context.getCorrelationId()).thenReturn((Object)"1");
        Message message = Message.of((Object)payload);
        CoreEvent event = CoreEvent.builder((EventContext)context).message(message).build();
        idempotent.setIdExpression(dwHashExpression);
        DataWeaveExpressionLanguageAdaptor expressionLanguageAdaptor = new DataWeaveExpressionLanguageAdaptor(muleContext, (Registry)Mockito.mock(Registry.class), (DefaultExpressionLanguageFactoryService)new WeaveDefaultExpressionLanguageFactoryService());
        TypedValue hashedValue = expressionLanguageAdaptor.evaluate(dwHashExpression, event, BindingContextUtils.NULL_BINDING_CONTEXT);
        CoreEvent processedEvent = idempotent.process(event);
        Assert.assertNotNull((Object)processedEvent);
        Assert.assertEquals((Object)idempotent.getObjectStore().retrieve(IOUtils.toString((CursorStreamProvider)((ByteArrayBasedCursorStreamProvider)hashedValue.getValue()))), (Object)"1");
        Message otherMessage = Message.of((Object)otherPayload);
        event = CoreEvent.builder((EventContext)context).message(otherMessage).build();
        processedEvent = idempotent.process(event);
        Assert.assertNotNull((Object)processedEvent);
    }

    @Test
    public void multipleObjectStoreConfigurationShouldRaiseException() throws Exception {
        idempotent.setPrivateObjectStore((ObjectStore)new InMemoryObjectStore());
        this.expected.expect(InitialisationException.class);
        idempotent.initialise();
    }

    @Test
    public void implicitObjectStoreIsCreatedWhenNonDefined() throws Exception {
        idempotent.setObjectStore(null);
        idempotent.initialise();
        Assert.assertThat((Object)idempotent.getObjectStore(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }
}

