/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.routing.Splitter;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.util.MuleContextUtils;

public class MapSplitterTestCase
extends AbstractMuleContextTestCase {
    private Splitter mapSplitter;
    private List<Map.Entry<String, String>> splitPayloads = new ArrayList<Map.Entry<String, String>>();

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.mapSplitter = new Splitter();
        this.mapSplitter.setListener(event -> {
            this.splitPayloads.add((Map.Entry)event.getMessage().getPayload().getValue());
            return event;
        });
        this.mapSplitter.setMuleContext(muleContext);
        this.mapSplitter.initialise();
    }

    @Test
    public void testSplit() throws Exception {
        HashMap<String, String> testMap = new HashMap<String, String>();
        testMap.put("1", "one");
        testMap.put("2", "two");
        testMap.put("3", "three");
        this.mapSplitter.process(MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of(testMap)).build());
        Assert.assertThat(this.splitPayloads, (Matcher)IsCollectionWithSize.hasSize((int)3));
        Assert.assertThat(this.splitPayloads.get(0), (Matcher)IsInstanceOf.instanceOf(Map.Entry.class));
        Assert.assertThat((Object)this.splitPayloads.get(0).getKey(), (Matcher)Is.is((Object)"1"));
        Assert.assertThat((Object)this.splitPayloads.get(0).getValue(), (Matcher)Is.is((Object)"one"));
        Assert.assertThat((Object)this.splitPayloads.get(1).getKey(), (Matcher)Is.is((Object)"2"));
        Assert.assertThat((Object)this.splitPayloads.get(1).getValue(), (Matcher)Is.is((Object)"two"));
        Assert.assertThat((Object)this.splitPayloads.get(2).getKey(), (Matcher)Is.is((Object)"3"));
        Assert.assertThat((Object)this.splitPayloads.get(2).getValue(), (Matcher)Is.is((Object)"three"));
    }
}

