/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.message.GroupCorrelation;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.routing.MessageChunkAggregator;
import org.mule.runtime.core.privileged.event.DefaultMuleSession;
import org.mule.runtime.core.privileged.event.MuleSession;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class MessageChunkAggregatorTestCase
extends AbstractMuleContextTestCase {
    public MessageChunkAggregatorTestCase() {
        this.setStartContext(true);
    }

    protected Map<String, Object> getStartUpRegistryObjects() {
        return Collections.singletonMap("_muleConfigurationComponentLocator", this.componentLocator);
    }

    @Test
    public void testMessageProcessor() throws Exception {
        DefaultMuleSession session = new DefaultMuleSession();
        Flow flow = MuleTestUtils.createAndRegisterFlow((MuleContext)muleContext, (String)"appleFlow", (ConfigurationComponentLocator)this.componentLocator);
        Assert.assertNotNull((Object)flow);
        MessageChunkAggregator router = new MessageChunkAggregator();
        router.setAnnotations(MessageChunkAggregatorTestCase.getAppleFlowComponentLocationAnnotations());
        LifecycleUtils.initialiseIfNeeded((Object)router, (boolean)true, (MuleContext)muleContext);
        Message message1 = Message.of((Object)"test event A");
        Message message2 = Message.of((Object)"test event B");
        Message message3 = Message.of((Object)"test event C");
        EventContext context = EventContextFactory.create((FlowConstruct)flow, (ComponentLocation)TEST_CONNECTOR_LOCATION, (String)"foo");
        InternalEvent event1 = InternalEvent.builder((EventContext)context).message(message1).groupCorrelation(Optional.of(GroupCorrelation.of((int)0, (int)3))).session((MuleSession)session).build();
        InternalEvent event2 = InternalEvent.builder((EventContext)context).message(message2).session((MuleSession)session).build();
        InternalEvent event3 = InternalEvent.builder((EventContext)context).message(message3).session((MuleSession)session).build();
        Assert.assertNull((Object)router.process((CoreEvent)event1));
        Assert.assertNull((Object)router.process((CoreEvent)event2));
        CoreEvent resultEvent = router.process((CoreEvent)event3);
        Assert.assertNotNull((Object)resultEvent);
        Message resultMessage = resultEvent.getMessage();
        Assert.assertNotNull((Object)resultMessage);
        String payload = this.getPayloadAsString(resultMessage);
        Assert.assertTrue((boolean)payload.contains("test event A"));
        Assert.assertTrue((boolean)payload.contains("test event B"));
        Assert.assertTrue((boolean)payload.contains("test event C"));
        Assert.assertTrue((boolean)payload.matches("test event [A,B,C]test event [A,B,C]test event [A,B,C]"));
    }
}

