/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.routing.EventGroup;
import org.mule.runtime.core.internal.routing.Resequencer;
import org.mule.runtime.core.internal.routing.correlation.CorrelationSequenceComparator;
import org.mule.runtime.core.internal.routing.correlation.EventCorrelatorCallback;
import org.mule.runtime.core.internal.routing.correlation.ResequenceMessagesCorrelatorCallback;
import org.mule.runtime.core.privileged.event.DefaultMuleSession;
import org.mule.runtime.core.privileged.event.MuleSession;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class ResequencerTestCase
extends AbstractMuleContextTestCase {
    public ResequencerTestCase() {
        this.setStartContext(true);
    }

    protected Map<String, Object> getStartUpRegistryObjects() {
        return Collections.singletonMap("_muleConfigurationComponentLocator", this.componentLocator);
    }

    @Test
    public void testMessageResequencer() throws Exception {
        DefaultMuleSession session = new DefaultMuleSession();
        Flow flow = MuleTestUtils.createAndRegisterFlow((MuleContext)muleContext, (String)"appleFlow", (ConfigurationComponentLocator)this.componentLocator);
        Assert.assertNotNull((Object)flow);
        TestEventResequencer router = new TestEventResequencer(3);
        router.setMuleContext(muleContext);
        router.setAnnotations(ResequencerTestCase.getAppleFlowComponentLocationAnnotations());
        LifecycleUtils.initialiseIfNeeded((Object)((Object)router), (boolean)true, (MuleContext)muleContext);
        EventContext context = EventContextFactory.create((FlowConstruct)flow, (ComponentLocation)TEST_CONNECTOR_LOCATION, (String)"foo");
        Message message1 = Message.of((Object)"test event A");
        Message message2 = Message.of((Object)"test event B");
        Message message3 = Message.of((Object)"test event C");
        InternalEvent event1 = InternalEvent.builder((EventContext)context).message(message1).session((MuleSession)session).build();
        InternalEvent event2 = InternalEvent.builder((EventContext)context).message(message2).session((MuleSession)session).build();
        InternalEvent event3 = InternalEvent.builder((EventContext)context).message(message3).session((MuleSession)session).build();
        Assert.assertNull((Object)router.process((CoreEvent)event2));
        Assert.assertNull((Object)router.process((CoreEvent)event3));
        CoreEvent resultEvent = router.process((CoreEvent)event1);
        Assert.assertNotNull((Object)resultEvent);
        Message resultMessage = resultEvent.getMessage();
        Assert.assertNotNull((Object)resultMessage);
        Assert.assertTrue((this.getPayloadAsString(resultMessage).equals("test event A") || this.getPayloadAsString(resultMessage).equals("test event B") || this.getPayloadAsString(resultMessage).equals("test event C") ? 1 : 0) != 0);
    }

    @Test
    public void testMessageResequencerWithComparator() throws Exception {
        DefaultMuleSession session = new DefaultMuleSession();
        Flow flow = MuleTestUtils.createFlow((MuleContext)muleContext, (String)"test");
        Assert.assertNotNull((Object)flow);
        Mockito.when((Object)this.componentLocator.find((Location)Matchers.any(Location.class))).thenReturn(Optional.of(flow));
        TestEventResequencer router = new TestEventResequencer(3);
        ImmutableMap fakeComponentLocationAnnotations = ImmutableMap.builder().put((Object)AbstractComponent.LOCATION_KEY, (Object)DefaultComponentLocation.fromSingleComponent((String)"test")).build();
        router.setAnnotations((Map)fakeComponentLocationAnnotations);
        LifecycleUtils.initialiseIfNeeded((Object)((Object)router), (boolean)true, (MuleContext)muleContext);
        EventContext context = EventContextFactory.create((FlowConstruct)flow, (ComponentLocation)TEST_CONNECTOR_LOCATION, (String)"foo");
        Message message1 = Message.of((Object)"test event A");
        Message message2 = Message.of((Object)"test event B");
        Message message3 = Message.of((Object)"test event C");
        InternalEvent event1 = InternalEvent.builder((EventContext)context).message(message1).session((MuleSession)session).build();
        InternalEvent event2 = InternalEvent.builder((EventContext)context).message(message2).session((MuleSession)session).build();
        InternalEvent event3 = InternalEvent.builder((EventContext)context).message(message3).session((MuleSession)session).build();
        router = new TestEventResequencer(3);
        router.setMuleContext(muleContext);
        router.setEventComparator(new EventPayloadComparator());
        router.setAnnotations(ResequencerTestCase.getAppleFlowComponentLocationAnnotations());
        LifecycleUtils.initialiseIfNeeded((Object)((Object)router), (boolean)true, (MuleContext)muleContext);
        Assert.assertNull((Object)router.process((CoreEvent)event2));
        Assert.assertNull((Object)router.process((CoreEvent)event3));
        CoreEvent resultEvent = router.process((CoreEvent)event1);
        Assert.assertNotNull((Object)resultEvent);
        Message resultMessage = resultEvent.getMessage();
        Assert.assertNotNull((Object)resultMessage);
        Assert.assertEquals((Object)"test event C", (Object)this.getPayloadAsString(resultMessage));
    }

    public static class EventPayloadComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            try {
                return ((PrivilegedEvent)o1).getMessageAsString(muleContext).compareTo(((PrivilegedEvent)o2).getMessageAsString(muleContext));
            }
            catch (MuleException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    public static class TestEventResequencer
    extends Resequencer {
        private int eventCount = 0;
        private int eventthreshold = 1;

        public TestEventResequencer(int eventthreshold) {
            this.eventthreshold = eventthreshold;
            this.setEventComparator((Comparator)new CorrelationSequenceComparator());
        }

        protected EventCorrelatorCallback getCorrelatorCallback(MuleContext muleContext) {
            return new ResequenceMessagesCorrelatorCallback(this.getEventComparator(), muleContext, this.storePrefix){

                public boolean shouldAggregateEvents(EventGroup events) {
                    eventCount++;
                    if (eventCount == eventthreshold) {
                        eventCount = 0;
                        return true;
                    }
                    return false;
                }
            };
        }
    }
}

