/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.routing.RoundRobin;
import org.mule.runtime.core.privileged.event.DefaultMuleSession;
import org.mule.runtime.core.privileged.event.MuleSession;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.util.MuleContextUtils;
import org.reactivestreams.Publisher;

public class RoundRobinTestCase
extends AbstractMuleContextTestCase {
    private static final int NUMBER_OF_ROUTES = 10;
    private static final int NUMBER_OF_MESSAGES = 10;
    private final AtomicInteger messageNumber = new AtomicInteger(0);

    public RoundRobinTestCase() {
        this.setStartContext(true);
    }

    protected Map<String, Object> getStartUpRegistryObjects() {
        ConfigurationComponentLocator configurationComponentLocator = (ConfigurationComponentLocator)Mockito.mock(ConfigurationComponentLocator.class);
        Mockito.when((Object)configurationComponentLocator.find((Location)Matchers.any(Location.class))).thenReturn(Optional.empty());
        Mockito.when((Object)configurationComponentLocator.find((ComponentIdentifier)Matchers.any(ComponentIdentifier.class))).thenReturn(Collections.emptyList());
        return Collections.singletonMap("_muleConfigurationComponentLocator", configurationComponentLocator);
    }

    @Test
    public void testRoundRobin() throws Exception {
        RoundRobin rr = new RoundRobin();
        rr.setAnnotations(RoundRobinTestCase.getAppleFlowComponentLocationAnnotations());
        DefaultMuleSession session = new DefaultMuleSession();
        ArrayList<TestProcessor> routes = new ArrayList<TestProcessor>(10);
        for (int i = 0; i < 10; ++i) {
            routes.add(new TestProcessor());
        }
        rr.setRoutes(new ArrayList(routes));
        LifecycleUtils.initialiseIfNeeded((Object)rr, (MuleContext)muleContext);
        ArrayList<Thread> threads = new ArrayList<Thread>(10);
        for (int i = 0; i < 10; ++i) {
            threads.add(new Thread(new TestDriver((MuleSession)session, (Processor)rr, 10, (FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext))));
        }
        for (Thread t : threads) {
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
        for (TestProcessor route : routes) {
            Assert.assertEquals((long)10L, (long)route.getCount());
        }
    }

    @Test
    public void usesFirstRouteOnFirstRequest() throws Exception {
        RoundRobin roundRobin = new RoundRobin();
        roundRobin.setAnnotations(RoundRobinTestCase.getAppleFlowComponentLocationAnnotations());
        ArrayList<Processor> routes = new ArrayList<Processor>(2);
        Processor route1 = (Processor)Mockito.mock(Processor.class, (String)"route1");
        Mockito.when((Object)route1.apply((Publisher)Matchers.any(Publisher.class))).then(invocation -> invocation.getArguments()[0]);
        routes.add(route1);
        Processor route2 = (Processor)Mockito.mock(Processor.class, (String)"route2");
        Mockito.when((Object)route2.apply((Publisher)Matchers.any(Publisher.class))).then(invocation -> invocation.getArguments()[0]);
        routes.add(route2);
        roundRobin.setRoutes(new ArrayList(routes));
        LifecycleUtils.initialiseIfNeeded((Object)roundRobin, (MuleContext)muleContext);
        Message message = Message.of(Collections.singletonList("Test Message"));
        roundRobin.process(MuleContextUtils.eventBuilder((MuleContext)muleContext).message(message).build());
        ((Processor)Mockito.verify((Object)route1)).apply((Publisher)Matchers.any(Publisher.class));
        ((Processor)Mockito.verify((Object)route2, (VerificationMode)Mockito.never())).apply((Publisher)Matchers.any(Publisher.class));
    }

    static class TestProcessor
    implements Processor {
        private int count;
        private List<Object> payloads = new ArrayList<Object>();

        TestProcessor() {
        }

        public CoreEvent process(CoreEvent event) throws MuleException {
            this.payloads.add(event.getMessage().getPayload().getValue());
            ++this.count;
            if (this.count % 3 == 0) {
                throw new DefaultMuleException("Mule Exception!");
            }
            return null;
        }

        public int getCount() {
            return this.count;
        }
    }

    class TestDriver
    implements Runnable {
        private Processor target;
        private int numMessages;
        private MuleSession session;
        private FlowConstruct flowConstruct;

        TestDriver(MuleSession session, Processor target, int numMessages, FlowConstruct flowConstruct) {
            this.target = target;
            this.numMessages = numMessages;
            this.session = session;
            this.flowConstruct = flowConstruct;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.numMessages; ++i) {
                Message msg = Message.of((Object)("Test Message" + RoundRobinTestCase.this.messageNumber.getAndIncrement()));
                InternalEvent event = InternalEvent.builder((EventContext)EventContextFactory.create((FlowConstruct)this.flowConstruct, (ComponentLocation)AbstractMuleTestCase.TEST_CONNECTOR_LOCATION)).message(msg).session(this.session).build();
                try {
                    this.target.process((CoreEvent)event);
                    continue;
                }
                catch (MuleException muleException) {
                    // empty catch block
                }
            }
        }
    }
}

