/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.StringBufferInputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.routing.ForkJoinStrategy;
import org.mule.runtime.core.internal.routing.ForkJoinStrategyFactory;
import org.mule.runtime.core.internal.routing.ScatterGatherRouter;
import org.mule.runtime.core.internal.routing.forkjoin.CollectMapForkJoinStrategyFactory;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Feature(value="Routers")
@Story(value="Scatter Gather")
public class ScatterGatherRouterTestCase
extends AbstractMuleContextTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private ScatterGatherRouter router = new ScatterGatherRouter();
    private ForkJoinStrategyFactory mockForkJoinStrategyFactory = (ForkJoinStrategyFactory)Mockito.mock(ForkJoinStrategyFactory.class);

    protected Map<String, Object> getStartUpRegistryObjects() {
        Mockito.when((Object)this.componentLocator.find(Location.builder().globalName("appleFlow").build())).thenReturn(Optional.of(Mockito.mock(Flow.class)));
        return Collections.singletonMap("_muleConfigurationComponentLocator", this.componentLocator);
    }

    @After
    public void tearDown() throws Exception {
        this.router.dispose();
    }

    @Test
    @Description(value="RoutingPairs are created for each route configured. Each RoutingPair has the same input event.")
    public void routingPairs() throws Exception {
        CoreEvent event = (CoreEvent)Mockito.mock(CoreEvent.class);
        MessageProcessorChain route1 = (MessageProcessorChain)Mockito.mock(MessageProcessorChain.class);
        MessageProcessorChain route2 = (MessageProcessorChain)Mockito.mock(MessageProcessorChain.class);
        MessageProcessorChain route3 = (MessageProcessorChain)Mockito.mock(MessageProcessorChain.class);
        this.router.setRoutes(Arrays.asList(route1, route2, route3));
        List routingPairs = (List)Flux.from((Publisher)this.router.getRoutingPairs(event)).collectList().block();
        Assert.assertThat((Object)routingPairs, (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat(routingPairs.get(0), (Matcher)CoreMatchers.equalTo((Object)ForkJoinStrategy.RoutingPair.of((CoreEvent)event, (MessageProcessorChain)route1)));
        Assert.assertThat(routingPairs.get(1), (Matcher)CoreMatchers.equalTo((Object)ForkJoinStrategy.RoutingPair.of((CoreEvent)event, (MessageProcessorChain)route2)));
        Assert.assertThat(routingPairs.get(2), (Matcher)CoreMatchers.equalTo((Object)ForkJoinStrategy.RoutingPair.of((CoreEvent)event, (MessageProcessorChain)route3)));
    }

    @Test
    @Description(value="By default the router result populates the outgoing message payload.")
    public void defaultTarget() throws Exception {
        CoreEvent original = this.testEvent();
        MessageProcessorChain route1 = MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{event -> event});
        MessageProcessorChain route2 = MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{event -> event});
        this.router.setRoutes(Arrays.asList(route1, route2));
        muleContext.getInjector().inject((Object)this.router);
        this.router.setAnnotations(ScatterGatherRouterTestCase.getAppleFlowComponentLocationAnnotations());
        this.router.initialise();
        CoreEvent result = this.router.process(original);
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(Map.class));
        Map resultMap = (Map)result.getMessage().getPayload().getValue();
        Assert.assertThat(resultMap.values(), (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    @Description(value="When a custom target is configured the router result is set in a variable and the input event is output.")
    public void customTargetMessage() throws Exception {
        String variableName = "foo";
        CoreEvent original = this.testEvent();
        MessageProcessorChain route1 = MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{event -> event});
        MessageProcessorChain route2 = MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{event -> event});
        this.router.setRoutes(Arrays.asList(route1, route2));
        this.router.setTarget("foo");
        this.router.setTargetValue("#[message]");
        muleContext.getInjector().inject((Object)this.router);
        this.router.setAnnotations(ScatterGatherRouterTestCase.getAppleFlowComponentLocationAnnotations());
        this.router.initialise();
        CoreEvent result = this.router.process(original);
        Assert.assertThat((Object)result.getMessage(), (Matcher)CoreMatchers.equalTo((Object)original.getMessage()));
        Assert.assertThat((Object)((Message)((TypedValue)result.getVariables().get("foo")).getValue()).getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(Map.class));
        Map resultMap = (Map)((Message)((TypedValue)result.getVariables().get("foo")).getValue()).getPayload().getValue();
        Assert.assertThat(resultMap.values(), (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    @Description(value="When a custom target is configured the router result is set in a variable and the input event is output.")
    public void customTargetDefaultPayload() throws Exception {
        String variableName = "foo";
        CoreEvent original = this.testEvent();
        MessageProcessorChain route1 = MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{event -> event});
        MessageProcessorChain route2 = MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{event -> event});
        this.router.setRoutes(Arrays.asList(route1, route2));
        this.router.setTarget("foo");
        muleContext.getInjector().inject((Object)this.router);
        this.router.setAnnotations(ScatterGatherRouterTestCase.getAppleFlowComponentLocationAnnotations());
        this.router.initialise();
        CoreEvent result = this.router.process(original);
        Assert.assertThat((Object)result.getMessage(), (Matcher)CoreMatchers.equalTo((Object)original.getMessage()));
        TypedValue typedValue = (TypedValue)result.getVariables().get("foo");
        Assert.assertThat((Object)typedValue.getValue(), (Matcher)CoreMatchers.instanceOf(Map.class));
        Assert.assertThat((Object)Map.class.isAssignableFrom(typedValue.getDataType().getType()), (Matcher)CoreMatchers.is((Object)true));
        Map resultMap = (Map)typedValue.getValue();
        Assert.assertThat(resultMap.values(), (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    @Description(value="The router uses a fork-join strategy with concurrency and timeout configured via the router and delayErrors true.")
    public void forkJoinStrategyConfiguration() throws Exception {
        int routes = 21;
        int concurrency = 3;
        long timeout = 123L;
        this.router.setMaxConcurrency(3);
        this.router.setTimeout(123L);
        this.router.setRoutes(IntStream.range(0, 21).mapToObj(i -> (MessageProcessorChain)Mockito.mock(MessageProcessorChain.class)).collect(Collectors.toList()));
        this.router.setForkJoinStrategyFactory(this.mockForkJoinStrategyFactory);
        muleContext.getInjector().inject((Object)this.router);
        this.router.setAnnotations(ScatterGatherRouterTestCase.getAppleFlowComponentLocationAnnotations());
        this.router.initialise();
        ((ForkJoinStrategyFactory)Mockito.verify((Object)this.mockForkJoinStrategyFactory)).createForkJoinStrategy((ProcessingStrategy)org.mockito.Matchers.any(ProcessingStrategy.class), org.mockito.Matchers.eq((int)3), org.mockito.Matchers.eq((boolean)true), org.mockito.Matchers.eq((long)123L), (Scheduler)org.mockito.Matchers.any(Scheduler.class), (ErrorType)org.mockito.Matchers.any(ErrorType.class));
    }

    @Test
    @Description(value="By default CollectMapForkJoinStrategyFactory is used which aggregates routes into a message with a Map<Message> payload.")
    public void defaultForkJoinStrategyFactory() throws Exception {
        Assert.assertThat((Object)this.router.getDefaultForkJoinStrategyFactory(), (Matcher)CoreMatchers.instanceOf(CollectMapForkJoinStrategyFactory.class));
        Assert.assertThat((Object)this.router.getDefaultForkJoinStrategyFactory().getResultDataType(), (Matcher)CoreMatchers.equalTo((Object)DataType.MULE_MESSAGE_MAP));
    }

    @Test
    @Description(value="The router must be configured with at least two routes.")
    public void minimumTwoRoutes() throws Exception {
        this.expectedException.expect(CoreMatchers.instanceOf(IllegalArgumentException.class));
        this.router.setRoutes(Collections.singletonList(Mockito.mock(MessageProcessorChain.class)));
    }

    @Test
    @Description(value="Consumable payloads are not supported.")
    public void consumablePayload() throws Exception {
        MessageProcessorChain route1 = MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{event -> event});
        MessageProcessorChain route2 = MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{event -> event});
        this.router.setRoutes(Arrays.asList(route1, route2));
        muleContext.getInjector().inject((Object)this.router);
        this.router.setAnnotations(ScatterGatherRouterTestCase.getAppleFlowComponentLocationAnnotations());
        this.router.initialise();
        this.expectedException.expect(CoreMatchers.instanceOf(MuleRuntimeException.class));
        this.router.process(CoreEvent.builder((CoreEvent)this.testEvent()).message(Message.of((Object)new StringBufferInputStream("test"))).build());
    }

    @Test
    @Description(value="Delay errors is always true for scatter-gather currently.")
    public void defaultDelayErrors() throws Exception {
        Assert.assertThat((Object)this.router.isDelayErrors(), (Matcher)CoreMatchers.equalTo((Object)true));
    }
}

