/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.message.GroupCorrelation;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.internal.routing.SimpleCollectionAggregator;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.SensingNullMessageProcessor;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class SimpleCollectionAggregatorTestCase
extends AbstractMuleContextTestCase {
    public SimpleCollectionAggregatorTestCase() {
        this.setStartContext(true);
    }

    protected Map<String, Object> getStartUpRegistryObjects() {
        return Collections.singletonMap("_muleConfigurationComponentLocator", this.componentLocator);
    }

    @Test
    public void testAggregateMultipleEvents() throws Exception {
        Flow flow = MuleTestUtils.createAndRegisterFlow((MuleContext)muleContext, (String)"appleFlow", (ConfigurationComponentLocator)this.componentLocator);
        Assert.assertNotNull((Object)flow);
        SimpleCollectionAggregator router = new SimpleCollectionAggregator();
        SensingNullMessageProcessor sensingMessageProcessor = this.getSensingNullMessageProcessor();
        router.setListener((Processor)sensingMessageProcessor);
        router.setAnnotations(SimpleCollectionAggregatorTestCase.getAppleFlowComponentLocationAnnotations());
        LifecycleUtils.initialiseIfNeeded((Object)router, (boolean)true, (MuleContext)muleContext);
        EventContext executionContext = EventContextFactory.create((FlowConstruct)flow, (ComponentLocation)TEST_CONNECTOR_LOCATION, (String)"foo");
        Message message1 = Message.of((Object)"test event A");
        Message message2 = Message.of((Object)"test event B");
        Message message3 = Message.of((Object)"test event C");
        InternalEvent event1 = InternalEvent.builder((EventContext)executionContext).message(message1).groupCorrelation(Optional.of(GroupCorrelation.of((int)0, (int)3))).build();
        InternalEvent event2 = InternalEvent.builder((EventContext)executionContext).message(message2).build();
        InternalEvent event3 = InternalEvent.builder((EventContext)executionContext).message(message3).build();
        Assert.assertNull((Object)router.process((CoreEvent)event1));
        Assert.assertNull((Object)router.process((CoreEvent)event2));
        CoreEvent resultEvent = router.process((CoreEvent)event3);
        Assert.assertNotNull((Object)sensingMessageProcessor.event);
        Assert.assertThat((Object)resultEvent, (Matcher)CoreMatchers.equalTo((Object)sensingMessageProcessor.event));
        Message nextMessage = sensingMessageProcessor.event.getMessage();
        Assert.assertNotNull((Object)nextMessage);
        Assert.assertTrue((boolean)(nextMessage.getPayload().getValue() instanceof List));
        List list = (List)nextMessage.getPayload().getValue();
        Assert.assertEquals((long)3L, (long)list.size());
        Object[] results = new String[3];
        list.stream().map(msg -> msg.getPayload().getValue()).collect(Collectors.toList()).toArray(results);
        Arrays.sort(results);
        Assert.assertEquals((Object)"test event A", (Object)results[0]);
        Assert.assertEquals((Object)"test event B", (Object)results[1]);
        Assert.assertEquals((Object)"test event C", (Object)results[2]);
    }

    @Test
    public void testAggregateSingleEvent() throws Exception {
        Flow flow = MuleTestUtils.createAndRegisterFlow((MuleContext)muleContext, (String)"appleFlow", (ConfigurationComponentLocator)this.componentLocator);
        Assert.assertNotNull((Object)flow);
        SimpleCollectionAggregator router = new SimpleCollectionAggregator();
        SensingNullMessageProcessor sensingMessageProcessor = this.getSensingNullMessageProcessor();
        router.setListener((Processor)sensingMessageProcessor);
        router.setMuleContext(muleContext);
        router.setAnnotations(SimpleCollectionAggregatorTestCase.getAppleFlowComponentLocationAnnotations());
        LifecycleUtils.initialiseIfNeeded((Object)router, (boolean)true, (MuleContext)muleContext);
        EventContext executionContext = EventContextFactory.create((FlowConstruct)flow, (ComponentLocation)TEST_CONNECTOR_LOCATION, (String)"foo");
        Message message1 = Message.of((Object)"test event A");
        InternalEvent event1 = InternalEvent.builder((EventContext)executionContext).message(message1).groupCorrelation(Optional.of(GroupCorrelation.of((int)0, (int)1))).build();
        CoreEvent resultEvent = router.process((CoreEvent)event1);
        Assert.assertNotNull((Object)sensingMessageProcessor.event);
        Assert.assertThat((Object)resultEvent, (Matcher)CoreMatchers.equalTo((Object)sensingMessageProcessor.event));
        Message nextMessage = sensingMessageProcessor.event.getMessage();
        Assert.assertNotNull((Object)nextMessage);
        Assert.assertTrue((boolean)(nextMessage.getPayload().getValue() instanceof List));
        List payload = (List)nextMessage.getPayload().getValue();
        Assert.assertEquals((long)1L, (long)payload.size());
        Assert.assertEquals((Object)"test event A", (Object)((InternalMessage)payload.get(0)).getPayload().getValue());
    }

    @Test
    public void testAggregateMessageCollections() throws Exception {
        Flow flow = MuleTestUtils.createAndRegisterFlow((MuleContext)muleContext, (String)"appleFlow", (ConfigurationComponentLocator)this.componentLocator);
        Assert.assertNotNull((Object)flow);
        SimpleCollectionAggregator router = new SimpleCollectionAggregator();
        router.setMuleContext(muleContext);
        router.setAnnotations(SimpleCollectionAggregatorTestCase.getAppleFlowComponentLocationAnnotations());
        LifecycleUtils.initialiseIfNeeded((Object)router, (boolean)true, (MuleContext)muleContext);
        EventContext executionContext = EventContextFactory.create((FlowConstruct)flow, (ComponentLocation)TEST_CONNECTOR_LOCATION, (String)"foo");
        Message message1 = Message.of((Object)"test event A");
        Message message2 = Message.of((Object)"test event B");
        Message message3 = Message.of((Object)"test event C");
        Message message4 = Message.of((Object)"test event D");
        ArrayList<Message> list = new ArrayList<Message>();
        ArrayList<Message> list2 = new ArrayList<Message>();
        list.add(message1);
        list.add(message2);
        list2.add(message3);
        list2.add(message4);
        Message messageCollection1 = Message.of(list);
        Message messageCollection2 = Message.of(list2);
        InternalEvent event1 = InternalEvent.builder((EventContext)executionContext).message(messageCollection1).groupCorrelation(Optional.of(GroupCorrelation.of((int)0, (int)2))).build();
        InternalEvent event2 = InternalEvent.builder((EventContext)executionContext).message(messageCollection2).groupCorrelation(Optional.of(GroupCorrelation.of((int)0, (int)2))).build();
        Assert.assertNull((Object)router.process((CoreEvent)event1));
        CoreEvent resultEvent = router.process((CoreEvent)event2);
        Assert.assertNotNull((Object)resultEvent);
        Message resultMessage = resultEvent.getMessage();
        Assert.assertNotNull((Object)resultMessage);
        List payload = (List)resultMessage.getPayload().getValue();
        Assert.assertEquals((long)2L, (long)payload.size());
        Assert.assertEquals((Object)"test event A", (Object)((InternalMessage)((List)((InternalMessage)payload.get(0)).getPayload().getValue()).get(0)).getPayload().getValue());
        Assert.assertEquals((Object)"test event B", (Object)((InternalMessage)((List)((InternalMessage)payload.get(0)).getPayload().getValue()).get(1)).getPayload().getValue());
        Assert.assertEquals((Object)"test event C", (Object)((InternalMessage)((List)((InternalMessage)payload.get(1)).getPayload().getValue()).get(0)).getPayload().getValue());
        Assert.assertEquals((Object)"test event D", (Object)((InternalMessage)((List)((InternalMessage)payload.get(1)).getPayload().getValue()).get(1)).getPayload().getValue());
    }
}

