/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.routing.Splitter;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class SplitterIteratorTestCase
extends AbstractMuleTestCase {
    private CoreEvent muleEvent;
    private MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
    private ExtendedExpressionManager expressionManager = (ExtendedExpressionManager)Mockito.mock(ExtendedExpressionManager.class);
    private final List<TypedValue<?>> integers = this.createListOfIntegers();
    private final Splitter splitter = new Splitter("fullExpression", null);
    private final FlowCallStack flowCallStack = (FlowCallStack)Mockito.mock(FlowCallStack.class);

    @Before
    public void setUp() throws Exception {
        this.splitter.setMuleContext(this.muleContext);
        Mockito.when((Object)this.muleContext.getExpressionManager()).thenReturn((Object)this.expressionManager);
        Mockito.when((Object)this.expressionManager.split((String)Matchers.any(String.class), (CoreEvent)Matchers.any(CoreEvent.class), (BindingContext)Matchers.any(BindingContext.class))).thenReturn(this.integers.iterator());
        this.muleEvent = this.testEvent();
        this.splitter.initialise();
    }

    @Test
    public void testExpressionSplitterWithIteratorInput() throws Exception {
        CoreEvent result = this.splitter.process(this.muleEvent);
        List values = (List)result.getMessage().getPayload().getValue();
        Assert.assertThat((Object)values.size(), (Matcher)CoreMatchers.is((Object)this.integers.size()));
        this.assertListValues(values);
    }

    private List<TypedValue<?>> createListOfIntegers() {
        ArrayList integers = new ArrayList(3);
        for (int i = 0; i < 3; ++i) {
            integers.add(new TypedValue((Object)i, DataType.fromType(Integer.class)));
        }
        return integers;
    }

    private void assertListValues(List<?> values) {
        Integer[] i = new Integer[]{0};
        values.forEach(value -> {
            Message message = (Message)value;
            Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(Integer.class));
            Integer n = i[0];
            Integer n2 = i[0] = Integer.valueOf(i[0] + 1);
            Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)n));
        });
    }
}

