/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.retry.policy.RetryPolicyExhaustedException;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.routing.UntilSuccessful;
import org.mule.runtime.core.privileged.processor.InternalProcessor;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.util.MuleContextUtils;

@RunWith(value=Parameterized.class)
public class UntilSuccessfulTestCase
extends AbstractMuleContextTestCase {
    @Rule
    public ExpectedException expected = ExpectedException.none();
    private UntilSuccessful untilSuccessful;
    private ConfigurableMessageProcessor targetMessageProcessor;
    private boolean tx;

    @Parameterized.Parameters
    public static Collection<Boolean> modeParameters() {
        return Arrays.asList(Boolean.TRUE, Boolean.FALSE);
    }

    public UntilSuccessfulTestCase(boolean tx) {
        this.tx = tx;
    }

    protected Map<String, Object> getStartUpRegistryObjects() {
        return Collections.singletonMap("_muleConfigurationComponentLocator", this.componentLocator);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        MuleTestUtils.createAndRegisterFlow((MuleContext)muleContext, (String)"appleFlow", (ConfigurationComponentLocator)this.componentLocator);
        this.untilSuccessful = this.buildUntilSuccessful(1000L);
        if (this.tx) {
            TransactionCoordination.getInstance().bindTransaction((Transaction)Mockito.mock(Transaction.class));
        }
    }

    @After
    public void doTeardown() throws Exception {
        this.untilSuccessful.dispose();
        super.doTearDown();
    }

    private UntilSuccessful buildUntilSuccessful(Long millisBetweenRetries) throws Exception {
        UntilSuccessful untilSuccessful = new UntilSuccessful();
        untilSuccessful.setMaxRetries(2);
        untilSuccessful.setAnnotations(UntilSuccessfulTestCase.getAppleFlowComponentLocationAnnotations());
        if (millisBetweenRetries != null) {
            untilSuccessful.setMillisBetweenRetries(millisBetweenRetries.longValue());
        }
        this.targetMessageProcessor = new ConfigurableMessageProcessor();
        untilSuccessful.setMessageProcessors(Collections.singletonList(this.targetMessageProcessor));
        muleContext.getInjector().inject((Object)untilSuccessful);
        return untilSuccessful;
    }

    protected void doTearDown() throws Exception {
        this.untilSuccessful.stop();
    }

    @Test
    public void testSuccessfulDelivery() throws Exception {
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        this.assertLogicallyEqualEvents(this.testEvent(), this.untilSuccessful.process(this.testEvent()));
        this.assertTargetEventReceived(this.testEvent());
    }

    @Test
    public void testSuccessfulDeliveryStreamPayload() throws Exception {
        this.untilSuccessful.setMuleContext(muleContext);
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        CoreEvent testEvent = MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)new ByteArrayInputStream("test_data".getBytes()))).build();
        Assert.assertSame((Object)testEvent.getMessage(), (Object)this.untilSuccessful.process(testEvent).getMessage());
        this.assertTargetEventReceived(testEvent);
    }

    @Test
    public void testPermanentDeliveryFailure() throws Exception {
        this.targetMessageProcessor.setNumberOfFailuresToSimulate(Integer.MAX_VALUE);
        this.untilSuccessful.setMuleContext(muleContext);
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        CoreEvent testEvent = MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"ERROR")).build();
        this.expected.expect(MessagingException.class);
        this.expected.expectCause(CoreMatchers.instanceOf(RetryPolicyExhaustedException.class));
        try {
            this.untilSuccessful.process(testEvent);
        }
        finally {
            Assert.assertEquals((long)(1 + this.untilSuccessful.getMaxRetries()), (long)this.targetMessageProcessor.getEventCount());
        }
    }

    @Test
    public void testTemporaryDeliveryFailure() throws Exception {
        this.targetMessageProcessor.setNumberOfFailuresToSimulate(this.untilSuccessful.getMaxRetries());
        this.untilSuccessful.setMuleContext(muleContext);
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        CoreEvent testEvent = MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"ERROR")).build();
        Assert.assertSame((Object)testEvent.getMessage(), (Object)this.untilSuccessful.process(testEvent).getMessage());
        this.assertTargetEventReceived(testEvent);
        Assert.assertEquals((long)this.targetMessageProcessor.getEventCount(), (long)(this.untilSuccessful.getMaxRetries() + 1));
    }

    @Test
    public void testDefaultMillisWait() throws Exception {
        this.untilSuccessful = this.buildUntilSuccessful(null);
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        Assert.assertEquals((long)60000L, (long)this.untilSuccessful.getMillisBetweenRetries());
    }

    private void assertTargetEventReceived(CoreEvent request) throws MuleException {
        Assert.assertThat((Object)this.targetMessageProcessor.getEventReceived(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        this.assertLogicallyEqualEvents(request, this.targetMessageProcessor.getEventReceived());
    }

    private void assertLogicallyEqualEvents(CoreEvent testEvent, CoreEvent eventReceived) throws MuleException {
        Assert.assertEquals((Object)testEvent.getCorrelationId(), (Object)eventReceived.getCorrelationId());
        Assert.assertEquals((Object)testEvent.getMessage(), (Object)eventReceived.getMessage());
    }

    public static class ConfigurableMessageProcessor
    implements Processor,
    InternalProcessor {
        private volatile int eventCount;
        private volatile CoreEvent event;
        private volatile int numberOfFailuresToSimulate;

        public CoreEvent process(CoreEvent evt) throws MuleException {
            ++this.eventCount;
            if (this.numberOfFailuresToSimulate-- > 0) {
                throw new RuntimeException("simulated problem");
            }
            this.event = evt;
            return evt;
        }

        public CoreEvent getEventReceived() {
            return this.event;
        }

        public int getEventCount() {
            return this.eventCount;
        }

        public void setNumberOfFailuresToSimulate(int numberOfFailuresToSimulate) {
            this.numberOfFailuresToSimulate = numberOfFailuresToSimulate;
        }
    }
}

