/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing.correlation;

import java.io.Serializable;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.store.ObjectDoesNotExistException;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.PartitionableObjectStore;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.routing.EventGroup;
import org.mule.runtime.core.internal.routing.correlation.EventCorrelator;
import org.mule.runtime.core.internal.routing.correlation.EventCorrelatorCallback;
import org.mule.runtime.core.privileged.routing.RoutingException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.util.MuleContextUtils;

public class EventCorrelatorMemoryLeakTestCase
extends AbstractMuleTestCase {
    private EventCorrelator eventCorrelator;
    private final EventCorrelatorCallback eventCorrelatorCallback = (EventCorrelatorCallback)Mockito.mock(EventCorrelatorCallback.class);
    private final Processor messageProcessor = (Processor)Mockito.mock(Processor.class);
    private PartitionableObjectStore<EventGroup> partitionableObjectStore = (PartitionableObjectStore)Mockito.mock(PartitionableObjectStore.class);
    private ObjectStore<Long> objectStore = (ObjectStore)Mockito.mock(ObjectStore.class);
    private final FlowConstruct flowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class);
    private MuleContext muleContext = MuleContextUtils.mockContextWithServices();
    private MuleConfiguration muleConfiguration = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);
    private EventGroup eventGroup = (EventGroup)Mockito.mock(EventGroup.class);
    private int countOfEventGroups = 0;
    private boolean eventGroupWasSaved = false;

    @Before
    public void setUp() throws Exception {
        this.setReturnsAndExceptions();
        this.setAnswers();
        this.eventCorrelator = new EventCorrelator(this.eventCorrelatorCallback, this.messageProcessor, this.muleContext, this.flowConstruct, this.partitionableObjectStore, "prefix", this.objectStore);
    }

    @Test
    public void testEventGroupFreedInRoutingException() throws Exception {
        CoreEvent event = (CoreEvent)Mockito.mock(CoreEvent.class);
        try {
            this.eventCorrelator.process(event);
            Assert.fail((String)"Routing Exception must be catched.");
        }
        catch (RoutingException e) {
            Assert.assertTrue((String)"Event Group wasn't saved", (boolean)this.eventGroupWasSaved);
            Assert.assertThat((Object)this.countOfEventGroups, (Matcher)Matchers.is((Object)0));
        }
    }

    private void setReturnsAndExceptions() throws Exception {
        Mockito.when((Object)this.muleContext.getConfiguration()).thenReturn((Object)this.muleConfiguration);
        Mockito.when((Object)this.partitionableObjectStore.retrieve((String)org.mockito.Matchers.any(String.class), (String)org.mockito.Matchers.any(String.class))).thenThrow(new Class[]{ObjectDoesNotExistException.class});
        Mockito.when((Object)this.eventCorrelatorCallback.createEventGroup((CoreEvent)org.mockito.Matchers.any(CoreEvent.class), org.mockito.Matchers.any(Object.class))).thenReturn((Object)this.eventGroup);
        Mockito.when((Object)this.eventCorrelatorCallback.aggregateEvents((EventGroup)org.mockito.Matchers.any(EventGroup.class))).thenThrow(new Class[]{RoutingException.class});
        Mockito.when((Object)this.eventCorrelatorCallback.shouldAggregateEvents((EventGroup)org.mockito.Matchers.any(EventGroup.class))).thenReturn((Object)true);
    }

    private void setAnswers() throws ObjectStoreException {
        ((PartitionableObjectStore)Mockito.doAnswer(invocation -> {
            ++this.countOfEventGroups;
            this.eventGroupWasSaved = true;
            return null;
        }).when(this.partitionableObjectStore)).store((String)org.mockito.Matchers.any(), (Serializable)org.mockito.Matchers.any(), (String)org.mockito.Matchers.any());
        ((PartitionableObjectStore)Mockito.doAnswer(invocation -> {
            --this.countOfEventGroups;
            return null;
        }).when(this.partitionableObjectStore)).remove((String)org.mockito.Matchers.any(String.class), (String)org.mockito.Matchers.any(String.class));
    }
}

