/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing.correlation;

import io.qameta.allure.Issue;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.PartitionableObjectStore;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.internal.routing.EventGroup;
import org.mule.runtime.core.internal.routing.correlation.CorrelationTimeoutException;
import org.mule.runtime.core.internal.routing.correlation.EventCorrelator;
import org.mule.runtime.core.internal.routing.correlation.EventCorrelatorCallback;
import org.mule.runtime.core.internal.store.PartitionedInMemoryObjectStore;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.size.SmallTest;
import org.mule.tck.util.MuleContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class EventCorrelatorTestCase
extends AbstractMuleTestCase {
    public static final String TEST_GROUP_ID = "groupId";
    private static final Logger LOGGER = LoggerFactory.getLogger(EventCorrelatorTestCase.class);
    private MuleContextWithRegistries mockMuleContext = MuleContextUtils.mockContextWithServices();
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private EventCorrelatorCallback mockEventCorrelatorCallback;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Processor mockTimeoutMessageProcessor;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ObjectStoreManager mockObjectStoreManager;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private EventGroup mockEventGroup;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ObjectStore mockProcessedGroups;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private InternalMessage mockMessageCollection;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private CoreEvent mockMuleEvent;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private FlowConstruct mockFlowConstruct;
    private PartitionableObjectStore memoryObjectStore = new PartitionedInMemoryObjectStore();

    @Before
    public void setup() throws RegistrationException {
        Mockito.when((Object)this.mockEventGroup.getMessageCollectionEvent()).thenReturn((Object)this.mockMuleEvent);
        Mockito.when((Object)this.mockMuleEvent.getMessage()).thenReturn((Object)this.mockMessageCollection);
        Mockito.when((Object)this.mockMessageCollection.getPayload()).thenReturn((Object)new TypedValue(null, DataType.OBJECT));
    }

    @Test(expected=CorrelationTimeoutException.class)
    public void initAfterDeserializationAfterForceGroupExpiry() throws Exception {
        try {
            EventCorrelator eventCorrelator = this.createEventCorrelator();
            eventCorrelator.forceGroupExpiry(TEST_GROUP_ID);
        }
        finally {
            ((EventGroup)Mockito.verify((Object)this.mockEventGroup, (VerificationMode)Mockito.times((int)1))).initAfterDeserialisation((MuleContext)this.mockMuleContext);
        }
    }

    @Test
    public void initAfterDeserializationAfterAddEventGroup() throws Exception {
        EventCorrelator eventCorrelator = this.createEventCorrelator();
        eventCorrelator.addEventGroup(this.mockEventGroup);
        ((EventGroup)Mockito.verify((Object)this.mockEventGroup, (VerificationMode)Mockito.times((int)1))).initAfterDeserialisation((MuleContext)this.mockMuleContext);
    }

    @Test
    public void initAfterDeserializationAfterProcess() throws Exception {
        Mockito.when((Object)this.mockEventCorrelatorCallback.shouldAggregateEvents(this.mockEventGroup)).thenReturn((Object)false);
        Mockito.when((Object)this.mockMuleEvent.getCorrelationId()).thenReturn((Object)TEST_GROUP_ID);
        EventCorrelator eventCorrelator = this.createEventCorrelator();
        eventCorrelator.process(this.mockMuleEvent);
        ((EventGroup)Mockito.verify((Object)this.mockEventGroup, (VerificationMode)Mockito.times((int)1))).initAfterDeserialisation((MuleContext)this.mockMuleContext);
    }

    @Test
    @Ignore(value="MULE-7311")
    @Issue(value="MULE-7311")
    public void processesExpiredGroupInPrimaryNode() throws Exception {
        this.doExpiredGroupMonitoringTest(true);
    }

    @Test
    public void doesNotProcessExpiredGroupInSecondaryNode() throws Exception {
        try {
            this.doExpiredGroupMonitoringTest(false);
            Assert.fail((String)"Expiring group monitoring thread is not supposed to do any work on a secondary node");
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExpiredGroupMonitoringTest(boolean primaryNode) throws Exception {
        Mockito.when((Object)this.mockMuleContext.isPrimaryPollingInstance()).thenReturn((Object)primaryNode);
        EventCorrelator eventCorrelator = this.createEventCorrelator();
        Mockito.when((Object)this.mockEventCorrelatorCallback.createEventGroup(this.mockMuleEvent, (Object)TEST_GROUP_ID)).thenReturn((Object)this.mockEventGroup);
        eventCorrelator.start();
        try {
            PollingProber prober = new PollingProber(1000L, 50L);
            prober.check(new Probe(){

                public boolean isSatisfied() {
                    try {
                        return !EventCorrelatorTestCase.this.memoryObjectStore.contains(EventCorrelatorTestCase.TEST_GROUP_ID, "prefix.eventGroups");
                    }
                    catch (ObjectStoreException e) {
                        LOGGER.debug("Could not access object store.");
                        return false;
                    }
                }

                public String describeFailure() {
                    return "Event group not expired.";
                }
            });
        }
        finally {
            eventCorrelator.stop();
        }
    }

    @Test
    public void avoidCreateMessageEventToGetExceptionListener() throws Exception {
        this.doExpiredGroupMonitoringTest(true);
        ((EventGroup)Mockito.verify((Object)this.mockEventGroup, (VerificationMode)Mockito.times((int)1))).getMessageCollectionEvent();
    }

    private EventCorrelator createEventCorrelator() throws Exception {
        MuleContextUtils.registerIntoMockContext((MuleContextWithRegistries)this.mockMuleContext, (String)"_muleObjectStoreManager", (Object)this.mockObjectStoreManager);
        this.memoryObjectStore.store(TEST_GROUP_ID, (Serializable)this.mockEventGroup, "prefix.eventGroups");
        Mockito.when((Object)this.mockEventGroup.getGroupId()).thenReturn((Object)TEST_GROUP_ID);
        Mockito.when((Object)this.mockEventGroup.getMessageCollectionEvent()).thenReturn(Mockito.mock(CoreEvent.class));
        Mockito.when((Object)this.mockFlowConstruct.getName()).thenReturn((Object)"flowName");
        return new EventCorrelator(this.mockEventCorrelatorCallback, this.mockTimeoutMessageProcessor, (MuleContext)this.mockMuleContext, this.mockFlowConstruct, this.memoryObjectStore, "prefix", this.mockProcessedGroups);
    }

    public abstract class DisposableObjectStore
    implements ObjectStore,
    Disposable {
    }
}

