/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing.forkjoin;

import io.qameta.allure.Description;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.routing.ForkJoinStrategy;
import org.mule.runtime.core.internal.routing.forkjoin.AbstractForkJoinStrategyTestCase;
import org.mule.runtime.core.internal.routing.forkjoin.CollectMapForkJoinStrategyFactory;

@Story(value="Collect Map")
public class CollectMapForkJoinStrategyTestCase
extends AbstractForkJoinStrategyTestCase {
    @Override
    protected ForkJoinStrategy createStrategy(ProcessingStrategy processingStrategy, int concurrency, boolean delayErrors, long timeout) {
        return new CollectMapForkJoinStrategyFactory().createForkJoinStrategy(processingStrategy, concurrency, delayErrors, timeout, this.scheduler, this.timeoutErrorType);
    }

    @Test
    @Description(value="This strategy waits for all routes to return and then collects results into a map where the key of each entry is the string representation of the index of the routing pair.")
    public void collectMap() throws Throwable {
        Message route1Result = Message.of((Object)1);
        Message route2Result = Message.of((Object)2);
        Message route3Result = Message.of((Object)3);
        ForkJoinStrategy.RoutingPair pair1 = this.createRoutingPair(route1Result);
        ForkJoinStrategy.RoutingPair pair2 = this.createRoutingPair(route2Result);
        ForkJoinStrategy.RoutingPair pair3 = this.createRoutingPair(route3Result);
        CoreEvent result = this.invokeStrategyBlocking(this.strategy, this.testEvent(), Arrays.asList(pair1, pair2, pair3));
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(Map.class));
        Map resultMap = (Map)result.getMessage().getPayload().getValue();
        Assert.assertThat(resultMap.entrySet(), (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat(resultMap.get("0"), (Matcher)CoreMatchers.is((Object)route1Result));
        Assert.assertThat(resultMap.get("1"), (Matcher)CoreMatchers.is((Object)route2Result));
        Assert.assertThat(resultMap.get("2"), (Matcher)CoreMatchers.is((Object)route3Result));
    }
}

