/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing.forkjoin;

import io.qameta.allure.Description;
import io.qameta.allure.Story;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.routing.ForkJoinStrategy;
import org.mule.runtime.core.internal.routing.forkjoin.AbstractForkJoinStrategyTestCase;
import org.mule.runtime.core.internal.routing.forkjoin.JoinOnlyForkJoinStrategyFactory;

@Story(value="Join Only")
public class JoinOnlyForkJoinStrategyTestCase
extends AbstractForkJoinStrategyTestCase {
    @Override
    protected ForkJoinStrategy createStrategy(ProcessingStrategy processingStrategy, int concurrency, boolean delayErrors, long timeout) {
        return new JoinOnlyForkJoinStrategyFactory().createForkJoinStrategy(processingStrategy, concurrency, delayErrors, timeout, this.scheduler, this.timeoutErrorType);
    }

    @Test
    @Description(value="This strategy waits for all routes to return and then returns the original event.")
    public void joinOnly() throws Throwable {
        CoreEvent original = this.testEvent();
        Processor processor1 = this.createProcessorSpy(Message.of((Object)1));
        Processor processor2 = this.createProcessorSpy(Message.of((Object)2));
        Processor processor3 = this.createProcessorSpy(Message.of((Object)3));
        ForkJoinStrategy.RoutingPair pair1 = this.createRoutingPair(processor1);
        ForkJoinStrategy.RoutingPair pair2 = this.createRoutingPair(processor2);
        ForkJoinStrategy.RoutingPair pair3 = this.createRoutingPair(processor3);
        CoreEvent result = this.invokeStrategyBlocking(this.strategy, original, Arrays.asList(pair1, pair2, pair3));
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)original));
        ((Processor)Mockito.verify((Object)processor1, (VerificationMode)Mockito.times((int)1))).process((CoreEvent)Matchers.any(CoreEvent.class));
        ((Processor)Mockito.verify((Object)processor2, (VerificationMode)Mockito.times((int)1))).process((CoreEvent)Matchers.any(CoreEvent.class));
        ((Processor)Mockito.verify((Object)processor2, (VerificationMode)Mockito.times((int)1))).process((CoreEvent)Matchers.any(CoreEvent.class));
    }
}

