/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.source.polling;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.source.scheduler.FixedFrequencyScheduler;
import org.mule.runtime.core.api.source.scheduler.PeriodicScheduler;
import org.mule.runtime.core.internal.source.scheduler.DefaultSchedulerMessageSource;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.SensingNullMessageProcessor;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSchedulerMessageSourceTestCase
extends AbstractMuleContextTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSchedulerMessageSourceTestCase.class);
    private DefaultSchedulerMessageSource schedulerMessageSource;

    protected Map<String, Object> getStartUpRegistryObjects() {
        return Collections.singletonMap("_muleConfigurationComponentLocator", this.componentLocator);
    }

    @Test
    public void simplePoll() throws Exception {
        DefaultSchedulerMessageSource schedulerMessageSource = this.createMessageSource();
        final SensingNullMessageProcessor flow = this.getSensingNullMessageProcessor();
        schedulerMessageSource.setListener((Processor)flow);
        schedulerMessageSource.setAnnotations(Collections.singletonMap(AbstractComponent.LOCATION_KEY, TEST_CONNECTOR_LOCATION));
        schedulerMessageSource.trigger();
        new PollingProber(5000L, 100L).check(new Probe(){

            public boolean isSatisfied() {
                return flow.event != null;
            }

            public String describeFailure() {
                return "flow event never set by the source flow";
            }
        });
    }

    @Test
    public void disposeScheduler() throws Exception {
        SchedulerService schedulerService = muleContext.getSchedulerService();
        Mockito.reset((Object[])new SchedulerService[]{schedulerService});
        AtomicReference pollScheduler = new AtomicReference();
        ((SchedulerService)Mockito.doAnswer(invocation -> {
            Scheduler scheduler = (Scheduler)invocation.callRealMethod();
            pollScheduler.set(scheduler);
            return scheduler;
        }).when((Object)schedulerService)).cpuLightScheduler();
        DefaultSchedulerMessageSource schedulerMessageSource = this.createMessageSource();
        ((SchedulerService)Mockito.verify((Object)schedulerService)).cpuLightScheduler();
        schedulerMessageSource.start();
        ((Scheduler)Mockito.verify(pollScheduler.get())).scheduleAtFixedRate((Runnable)Matchers.any(), Matchers.anyLong(), Matchers.anyLong(), (TimeUnit)((Object)Matchers.any()));
        schedulerMessageSource.stop();
        schedulerMessageSource.dispose();
        ((Scheduler)Mockito.verify(pollScheduler.get())).stop();
    }

    @After
    public void after() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.schedulerMessageSource);
        LifecycleUtils.disposeIfNeeded((Object)this.schedulerMessageSource, (Logger)LOGGER);
    }

    private DefaultSchedulerMessageSource createMessageSource() throws Exception {
        MuleTestUtils.createAndRegisterFlow((MuleContext)muleContext, (String)"appleFlow", (ConfigurationComponentLocator)this.componentLocator);
        this.schedulerMessageSource = new DefaultSchedulerMessageSource(muleContext, (PeriodicScheduler)this.scheduler(), false);
        this.schedulerMessageSource.setAnnotations(DefaultSchedulerMessageSourceTestCase.getAppleFlowComponentLocationAnnotations());
        this.schedulerMessageSource.initialise();
        return this.schedulerMessageSource;
    }

    private FixedFrequencyScheduler scheduler() {
        FixedFrequencyScheduler factory = new FixedFrequencyScheduler();
        factory.setFrequency(1000L);
        return factory;
    }
}

