/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming;

import io.qameta.allure.Feature;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.core.api.streaming.iterator.Consumer;
import org.mule.runtime.core.api.streaming.iterator.Producer;
import org.mule.runtime.core.internal.streaming.object.iterator.ClosedConsumerException;
import org.mule.runtime.core.internal.streaming.object.iterator.SimpleConsumer;
import org.mule.tck.size.SmallTest;

@SmallTest
@Feature(value="Streaming")
public class SimpleConsumerTestCase {
    private Producer<String> producer;
    private Consumer<String> consumer;
    private final Set<String> values = new HashSet<String>(Arrays.asList("apple", "banana", "kiwi"));

    @Before
    public void setUp() throws Exception {
        this.producer = new TestProducer();
        this.consumer = new SimpleConsumer(this.producer);
    }

    @Test
    public void happyPath() throws Exception {
        Assert.assertFalse((boolean)this.consumer.isConsumed());
        while (!this.consumer.isConsumed()) {
            Assert.assertTrue((boolean)this.values.contains(this.consumer.consume()));
        }
        Assert.assertTrue((boolean)this.consumer.isConsumed());
    }

    @Test(expected=ClosedConsumerException.class)
    public void closeEarly() throws Exception {
        Assert.assertFalse((boolean)this.consumer.isConsumed());
        this.consumer.consume();
        this.producer.close();
        Assert.assertTrue((boolean)this.consumer.isConsumed());
        Assert.assertNull((Object)this.consumer.consume());
    }

    @Test
    public void totalAvailable() {
        Assert.assertEquals((int)this.consumer.getSize(), (int)this.values.size());
    }

    @Test
    public void doubleClose() throws Exception {
        this.consumer.close();
        this.consumer.close();
    }

    private class TestProducer
    implements Producer<String> {
        private boolean closed = false;
        private final Iterator<String> iterator;

        private TestProducer() {
            this.iterator = SimpleConsumerTestCase.this.values.iterator();
        }

        public String produce() {
            if (this.closed) {
                return null;
            }
            String value = this.iterator.next();
            if (value == null) {
                try {
                    this.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return value;
        }

        public int getSize() {
            return SimpleConsumerTestCase.this.values.size();
        }

        public void close() throws IOException {
            this.closed = true;
        }
    }
}

