/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes;

import io.qameta.allure.Feature;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.internal.streaming.MemoryManager;
import org.mule.runtime.core.internal.streaming.bytes.MaxStreamingMemoryExceededException;
import org.mule.runtime.core.internal.streaming.bytes.PoolingByteBufferManager;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@Feature(value="Streaming")
public class PoolingByteBufferManagerTestCase
extends AbstractMuleTestCase {
    private ExecutorService allocateExecutor = Executors.newSingleThreadExecutor();
    private PoolingByteBufferManager bufferManager = new PoolingByteBufferManager(this.allocateExecutor);
    private static final int CAPACITY = 100;
    private static final int OTHER_CAPACITY = 101;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @After
    public void after() {
        this.bufferManager.dispose();
        this.allocateExecutor.shutdownNow();
    }

    @Test
    public void pooling() throws Exception {
        ByteBuffer buffer = this.bufferManager.allocate(100);
        this.bufferManager.deallocate(buffer);
        ByteBuffer newBuffer = this.bufferManager.allocate(100);
        Assert.assertThat((Object)buffer, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)newBuffer)));
    }

    @Test
    public void grow() throws Exception {
        ByteBuffer buffer = this.bufferManager.allocate(100);
        ByteBuffer newBuffer = this.bufferManager.allocate(100);
        Assert.assertThat((Object)buffer, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)newBuffer)));
    }

    @Test
    public void differentPoolsPerCapacity() throws Exception {
        ByteBuffer buffer = this.bufferManager.allocate(100);
        this.bufferManager.deallocate(buffer);
        ByteBuffer buffer2 = this.bufferManager.allocate(101);
        Assert.assertThat((Object)buffer, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)buffer2)));
        ByteBuffer buffer3 = this.bufferManager.allocate(101);
        Assert.assertThat((Object)buffer, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)buffer3)));
        Assert.assertThat((Object)buffer2, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)buffer3)));
        this.bufferManager.deallocate(buffer2);
        ByteBuffer buffer2Reborn = this.bufferManager.allocate(101);
        Assert.assertThat((Object)buffer2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)buffer2Reborn)));
    }

    @Test
    public void capacity() throws Exception {
        this.assertCapacity(100);
        this.assertCapacity(101);
    }

    @Test
    public void limitTotalMemory() throws Exception {
        long maxMemory = 40L;
        int bufferCapacity = Math.toIntExact(10L);
        long waitTimeoutMillis = TimeUnit.SECONDS.toMillis(2L);
        MemoryManager memoryManager = (MemoryManager)Mockito.mock(MemoryManager.class);
        Mockito.when((Object)memoryManager.getMaxMemory()).thenReturn((Object)40L);
        this.bufferManager.dispose();
        this.bufferManager = new PoolingByteBufferManager(this.allocateExecutor, memoryManager, waitTimeoutMillis);
        this.assertMemoryLimit(bufferCapacity, waitTimeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void limitTotalMemoryThroughSystemProperty() throws Exception {
        long maxMemory = 40L;
        int bufferCapacity = Math.toIntExact(10L);
        long waitTimeoutMillis = TimeUnit.SECONDS.toMillis(2L);
        MemoryManager memoryManager = (MemoryManager)Mockito.mock(MemoryManager.class);
        this.bufferManager.dispose();
        System.setProperty("mule.max.streaming.memory", String.valueOf(20L));
        try {
            this.bufferManager = new PoolingByteBufferManager(this.allocateExecutor, memoryManager, waitTimeoutMillis);
            this.assertMemoryLimit(bufferCapacity, waitTimeoutMillis);
            ((MemoryManager)Mockito.verify((Object)memoryManager, (VerificationMode)Mockito.never())).getMaxMemory();
        }
        finally {
            System.clearProperty("mule.max.streaming.memory");
        }
    }

    @Test
    public void invalidMemoryCapThroughSystemProperty() throws Exception {
        System.setProperty("mule.max.streaming.memory", "don't spend that much memory please");
        this.bufferManager.dispose();
        try {
            this.expectedException.expect(IllegalArgumentException.class);
            this.bufferManager = new PoolingByteBufferManager(this.allocateExecutor, (MemoryManager)Mockito.mock(MemoryManager.class), 10L);
        }
        finally {
            System.clearProperty("mule.max.streaming.memory");
        }
    }

    private void assertMemoryLimit(int bufferCapacity, long waitTimeoutMillis) throws InterruptedException {
        ByteBuffer buffer1 = this.bufferManager.allocate(bufferCapacity);
        ByteBuffer buffer2 = this.bufferManager.allocate(bufferCapacity);
        Assert.assertThat((Object)buffer1.capacity(), (Matcher)CoreMatchers.is((Object)bufferCapacity));
        Assert.assertThat((Object)buffer2.capacity(), (Matcher)CoreMatchers.is((Object)bufferCapacity));
        Latch latch = new Latch();
        Reference maxMemoryExhausted = new Reference((Object)false);
        new Thread(() -> {
            try {
                this.bufferManager.allocate(bufferCapacity);
                latch.release();
            }
            catch (Exception e) {
                maxMemoryExhausted.set((Object)(e.getCause() instanceof MaxStreamingMemoryExceededException));
            }
        }).start();
        Assert.assertThat((Object)latch.await(waitTimeoutMillis * 2L, TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)maxMemoryExhausted.get(), (Matcher)CoreMatchers.is((Object)true));
        this.bufferManager.deallocate(buffer1);
        Latch secondLatch = new Latch();
        new Thread(() -> {
            try {
                this.bufferManager.allocate(bufferCapacity);
                maxMemoryExhausted.set((Object)false);
            }
            finally {
                secondLatch.release();
            }
        }).start();
        Assert.assertThat((Object)secondLatch.await(waitTimeoutMillis, TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)maxMemoryExhausted.get(), (Matcher)CoreMatchers.is((Object)false));
    }

    private void assertCapacity(int capacity) {
        ByteBuffer buffer = this.bufferManager.allocate(capacity);
        try {
            Assert.assertThat((Object)buffer.capacity(), (Matcher)CoreMatchers.is((Object)capacity));
        }
        finally {
            this.bufferManager.deallocate(buffer);
        }
    }
}

