/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.object;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.mule.runtime.api.streaming.object.CursorIterator;
import org.mule.runtime.core.api.streaming.iterator.Consumer;
import org.mule.runtime.core.api.streaming.iterator.ConsumerStreamingIterator;
import org.mule.runtime.core.api.streaming.iterator.StreamingIterator;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public abstract class AbstractObjectStreamingTestCase
extends AbstractMuleContextTestCase {
    protected final List<Object> data;

    public AbstractObjectStreamingTestCase(int dataSize) {
        this.data = new ArrayList<Object>(dataSize);
        for (int i = 0; i < dataSize; ++i) {
            this.data.add(this.createDataInstance());
        }
    }

    protected Object createDataInstance() {
        return RandomStringUtils.randomAlphabetic((int)10);
    }

    protected <T> StreamingIterator<T> toStreamingIterator(List<T> data) {
        return new ConsumerStreamingIterator(new TestConsumer(data));
    }

    protected <T> void checkEquals(Collection<T> data, CursorIterator<T> cursor) {
        Assert.assertThat((Object)data.size(), (Matcher)CoreMatchers.is((Object)cursor.getSize()));
        int i = 0;
        for (T collectionItem : data) {
            Assert.assertThat((String)("Cursor exhausted at position " + i), (Object)cursor.hasNext(), (Matcher)CoreMatchers.is((Object)true));
            Object cursorItem = cursor.next();
            Assert.assertThat((String)("Unequal items at position " + i), (Object)cursorItem, (Matcher)CoreMatchers.equalTo(collectionItem));
            ++i;
        }
    }

    protected <T> void checkEquals(List<T> actual, List<T> expected) {
        Assert.assertThat((Object)actual.size(), (Matcher)CoreMatchers.is((Object)expected.size()));
        Assert.assertThat(actual, (Matcher)CoreMatchers.equalTo(expected));
    }

    protected <T> List<T> read(CursorIterator<T> cursor, int count) {
        ArrayList<Object> list = new ArrayList<Object>(count);
        for (int i = 0; cursor.hasNext() && i < count; ++i) {
            list.add(cursor.next());
        }
        return list;
    }

    private class TestConsumer<T>
    implements Consumer<T> {
        private final Iterator<T> delegate;
        private final int size;

        private TestConsumer(Collection<T> collection) {
            this.delegate = collection.iterator();
            this.size = collection.size();
        }

        public T consume() throws NoSuchElementException {
            return this.delegate.next();
        }

        public boolean isConsumed() {
            return !this.delegate.hasNext();
        }

        public void close() throws IOException {
        }

        public int getSize() {
            return this.size;
        }
    }
}

