/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.registry.MuleRegistry;
import org.mule.runtime.core.internal.transformer.DynamicDataTypeConversionResolver;
import org.mule.runtime.core.internal.transformer.builder.MockConverterBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DynamicDataTypeConverterResolverTestCase
extends AbstractMuleTestCase {
    private MuleContextWithRegistries muleContext = (MuleContextWithRegistries)Mockito.mock(MuleContextWithRegistries.class);
    private MuleRegistry muleRegistry = (MuleRegistry)Mockito.mock(MuleRegistry.class);

    @Test
    public void doesNotFailWhenThereIsNoDataTypeResolution() throws TransformerException {
        Mockito.when((Object)this.muleContext.getRegistry()).thenReturn((Object)this.muleRegistry);
        Mockito.when((Object)this.muleRegistry.lookupTransformer((DataType)Mockito.any(DataType.class), (DataType)Mockito.any(DataType.class))).thenReturn(null);
        DynamicDataTypeConversionResolver resolver = new DynamicDataTypeConversionResolver((MuleContext)this.muleContext);
        ArrayList<DataType> targetValues = new ArrayList<DataType>();
        targetValues.add(DataType.STRING);
        Transformer resolvedConverter = resolver.resolve(DataType.INPUT_STREAM, targetValues);
        Assert.assertEquals(null, (Object)resolvedConverter);
    }

    @Test
    public void findsExpectedConverter() throws TransformerException {
        Converter expectedConverter = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(DataType.BYTE_ARRAY)).to(DataType.STRING)).build();
        Mockito.when((Object)this.muleContext.getRegistry()).thenReturn((Object)this.muleRegistry);
        Mockito.when((Object)this.muleRegistry.lookupTransformer(DataType.BYTE_ARRAY, DataType.STRING)).thenReturn((Object)expectedConverter);
        DynamicDataTypeConversionResolver resolver = new DynamicDataTypeConversionResolver((MuleContext)this.muleContext);
        ArrayList<DataType> targetValues = new ArrayList<DataType>();
        targetValues.add(DataType.INPUT_STREAM);
        targetValues.add(DataType.STRING);
        Transformer resolvedConverter = resolver.resolve(DataType.BYTE_ARRAY, targetValues);
        Assert.assertEquals((Object)expectedConverter, (Object)resolvedConverter);
    }
}

