/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer;

import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.internal.transformer.expression.ExpressionArgument;
import org.mule.runtime.core.internal.transformer.expression.ExpressionTransformer;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.objectweb.asm.ClassWriter;

public class ExpressionTransformerTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testExpressionEvaluationClassLoaderEL() throws ClassNotFoundException, TransformerException {
        ExpressionTransformer transformer = new ExpressionTransformer();
        transformer.setMuleContext(muleContext);
        ExpressionArgument argument = new ExpressionArgument("test", "mel:payload is org.MyClass", false);
        argument.setMuleContext(muleContext);
        transformer.addArgument(argument);
        ClassUtils.withContextClassLoader((ClassLoader)new MyClassClassLoader(), () -> {
            try {
                transformer.initialise();
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
        });
        Assert.assertFalse((boolean)((Boolean)transformer.transform((Object)"test")));
    }

    @Test
    public void testNullPayloadIsConsideredAsNullResultEL() throws Exception {
        ExpressionTransformer transformer = new ExpressionTransformer();
        transformer.setMuleContext(muleContext);
        transformer.setReturnSourceIfNull(true);
        ExpressionArgument argument = new ExpressionArgument("test", "null", true);
        argument.setMuleContext(muleContext);
        transformer.addArgument(argument);
        Object result = transformer.transformMessage(this.testEvent(), null);
        Assert.assertTrue((boolean)(result instanceof InternalMessage));
        InternalMessage transformedMessage = (InternalMessage)result;
        Assert.assertEquals((Object)"test", (Object)transformedMessage.getPayload().getValue());
    }

    class MyClassClassLoader
    extends ClassLoader {
        MyClassClassLoader() {
        }

        @Override
        protected Class<?> findClass(String className) throws ClassNotFoundException {
            if (className.equals("org.MyClass")) {
                ClassWriter cw = new ClassWriter(2);
                cw.visit(49, 1, "org/MyClass", null, "java/lang/Object", null);
                return this.defineClass(className, cw.toByteArray(), 0, cw.toByteArray().length);
            }
            return super.findClass(className);
        }
    }
}

