/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer;

import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.registry.MuleRegistry;
import org.mule.runtime.core.internal.transformer.AbstractDiscoverableTransformer;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.tck.testmodels.fruit.RedApple;

public class TransformDiscoveryTestCase
extends AbstractMuleContextTestCase {
    protected void doSetUp() throws Exception {
        ((MuleContextWithRegistries)muleContext).getRegistry().registerTransformer((Transformer)new StringToApple());
        ((MuleContextWithRegistries)muleContext).getRegistry().registerTransformer((Transformer)new StringToOrange());
    }

    @Test
    public void testSimpleDiscovery() throws Exception {
        MuleRegistry registry = ((MuleContextWithRegistries)muleContext).getRegistry();
        Transformer t = registry.lookupTransformer(DataType.STRING, DataType.fromType(Apple.class));
        Assert.assertNotNull((Object)t);
        Assert.assertEquals(StringToApple.class, t.getClass());
        t = registry.lookupTransformer(DataType.STRING, DataType.fromType(Orange.class));
        Assert.assertNotNull((Object)t);
        Assert.assertEquals(StringToOrange.class, t.getClass());
        try {
            registry.lookupTransformer(DataType.STRING, DataType.fromType(Banana.class));
            Assert.fail((String)"There is no transformer to go from String to Banana");
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        registry.registerTransformer((Transformer)new StringToRedApple());
        t = registry.lookupTransformer(DataType.STRING, DataType.fromType(RedApple.class));
        Assert.assertNotNull((Object)t);
        Assert.assertEquals(StringToRedApple.class, t.getClass());
    }

    protected class StringToOrange
    extends AbstractDiscoverableTransformer {
        public StringToOrange() {
            this.setReturnDataType(DataType.fromType(Orange.class));
        }

        protected Object doTransform(Object src, Charset encoding) throws TransformerException {
            return new Orange();
        }
    }

    protected class StringToRedApple
    extends AbstractDiscoverableTransformer {
        public StringToRedApple() {
            this.setReturnDataType(DataType.fromType(RedApple.class));
            this.setPriorityWeighting(10);
        }

        protected Object doTransform(Object src, Charset encoding) throws TransformerException {
            return new RedApple();
        }
    }

    protected class StringToApple
    extends AbstractDiscoverableTransformer {
        public StringToApple() {
            this.setReturnDataType(DataType.fromType(Apple.class));
        }

        protected Object doTransform(Object src, Charset encoding) throws TransformerException {
            return new Apple();
        }
    }
}

