/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer;

import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.transformer.AbstractDiscoverableTransformer;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.Orange;

@SmallTest
public class TransformerResolutionTestCase
extends AbstractMuleContextTestCase {
    public static final DataType FRUIT_DATA_TYPE = DataType.fromType(Fruit.class);
    public static final DataType ORANGE_DATA_TYPE = DataType.fromType(Orange.class);
    public static final DataType APPLE_DATA_TYPE = DataType.fromType(Apple.class);

    @Test
    public void resolvesMultipleApplicableTransformers() throws MuleException {
        ((MuleContextWithRegistries)muleContext).getRegistry().registerTransformer((Transformer)new StringToOrange());
        ((MuleContextWithRegistries)muleContext).getRegistry().registerTransformer((Transformer)new StringToApple());
        ((MuleContextWithRegistries)muleContext).getRegistry().registerTransformer((Transformer)new StringToFruit());
        try {
            Transformer transformer = ((MuleContextWithRegistries)muleContext).getRegistry().lookupTransformer(DataType.STRING, FRUIT_DATA_TYPE);
            Assert.assertTrue((String)String.format("Expected a %s transformer but got %s", StringToFruit.class.getName(), transformer.getClass().getName()), (boolean)(transformer instanceof StringToFruit));
        }
        catch (TransformerException e) {
            Assert.fail((String)"Unable to properly resolve transformer");
        }
    }

    protected class StringToApple
    extends AbstractStringToFruit {
        public StringToApple() {
            this.setReturnDataType(APPLE_DATA_TYPE);
        }
    }

    protected class StringToOrange
    extends AbstractStringToFruit {
        public StringToOrange() {
            this.setReturnDataType(ORANGE_DATA_TYPE);
        }
    }

    protected class StringToFruit
    extends AbstractStringToFruit {
        public StringToFruit() {
            this.setReturnDataType(FRUIT_DATA_TYPE);
        }
    }

    protected class AbstractStringToFruit
    extends AbstractDiscoverableTransformer {
        public AbstractStringToFruit() {
            this.registerSourceType(DataType.STRING);
        }

        protected Object doTransform(Object src, Charset encoding) throws TransformerException {
            return new Orange();
        }
    }
}

