/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.encryption;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import org.junit.Assert;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.security.CryptoFailureException;
import org.mule.runtime.core.api.security.EncryptionStrategy;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.internal.security.PasswordBasedEncryptionStrategy;
import org.mule.runtime.core.internal.transformer.encryption.DecryptionTransformer;
import org.mule.runtime.core.internal.transformer.encryption.EncryptionTransformer;
import org.mule.tck.core.transformer.AbstractTransformerTestCase;

public class EncryptionTransformerTestCase
extends AbstractTransformerTestCase {
    private static final String TEST_DATA = "the quick brown fox jumped over the lazy dog the quick brown fox jumped over the lazy dog the quick brown fox jumped over the lazy dog";
    private PasswordBasedEncryptionStrategy strat;

    protected void doSetUp() throws Exception {
        this.strat = new PasswordBasedEncryptionStrategy();
        this.strat.setPassword("mule");
        this.strat.initialise();
    }

    public Object getResultData() {
        try {
            return new ByteArrayInputStream(this.strat.encrypt(TEST_DATA.getBytes(), null));
        }
        catch (CryptoFailureException e) {
            Assert.fail((String)e.getMessage());
            return null;
        }
    }

    public Object getTestData() {
        return new ByteArrayInputStream(TEST_DATA.getBytes());
    }

    public Transformer getTransformer() {
        EncryptionTransformer transformer = new EncryptionTransformer();
        transformer.setStrategy((EncryptionStrategy)this.strat);
        try {
            transformer.initialise();
        }
        catch (InitialisationException e) {
            Assert.fail((String)e.getMessage());
        }
        return transformer;
    }

    public Transformer getRoundTripTransformer() {
        DecryptionTransformer transformer = new DecryptionTransformer();
        transformer.setStrategy((EncryptionStrategy)this.strat);
        try {
            transformer.initialise();
        }
        catch (InitialisationException e) {
            Assert.fail((String)e.getMessage());
        }
        return transformer;
    }

    public boolean compareResults(Object src, Object result) {
        if (src == null && result == null) {
            return true;
        }
        if (src == null || result == null) {
            return false;
        }
        if (src instanceof byte[] && result instanceof byte[]) {
            return Arrays.equals((byte[])src, (byte[])result);
        }
        return super.compareResults(src, result);
    }
}

