/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.graph;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.internal.transformer.ResolverException;
import org.mule.runtime.core.internal.transformer.builder.MockConverterBuilder;
import org.mule.runtime.core.internal.transformer.graph.AbstractTransformationGraphTestCase;
import org.mule.runtime.core.internal.transformer.graph.NameConverterFilter;
import org.mule.tck.size.SmallTest;

@SmallTest
public class NameTransformerFilterTestCase
extends AbstractTransformationGraphTestCase {
    private NameConverterFilter filter = new NameConverterFilter();

    @Test
    public void filtersEmptyList() throws ResolverException {
        ArrayList availableConverters = new ArrayList();
        List converters = this.filter.filter(availableConverters, UNUSED_DATA_TYPE, UNUSED_DATA_TYPE);
        junit.framework.Assert.assertEquals((int)0, (int)converters.size());
    }

    @Test
    public void filtersEqualName() throws ResolverException {
        Converter xmlToString = ((MockConverterBuilder)new MockConverterBuilder().named("xmlToString")).build();
        ArrayList<Converter> availableConverters = new ArrayList<Converter>();
        availableConverters.add(xmlToString);
        availableConverters.add(xmlToString);
        List transformers = this.filter.filter(availableConverters, UNUSED_DATA_TYPE, UNUSED_DATA_TYPE);
        junit.framework.Assert.assertEquals((int)2, (int)transformers.size());
        junit.framework.Assert.assertEquals((Object)xmlToString, transformers.get(0));
        junit.framework.Assert.assertEquals((Object)xmlToString, transformers.get(1));
    }

    @Test
    public void filtersDifferentNameWithBetterTransformerFist() throws ResolverException {
        Converter xmlToString = ((MockConverterBuilder)new MockConverterBuilder().named("xmlToString")).build();
        Converter stringToJson = ((MockConverterBuilder)new MockConverterBuilder().named("stringToJson")).build();
        ArrayList<Converter> availableConverters = new ArrayList<Converter>();
        availableConverters.add(stringToJson);
        availableConverters.add(xmlToString);
        List transformers = this.filter.filter(availableConverters, UNUSED_DATA_TYPE, UNUSED_DATA_TYPE);
        junit.framework.Assert.assertEquals((int)1, (int)transformers.size());
        Assert.assertTrue((boolean)transformers.contains(stringToJson));
    }

    @Test
    public void filtersDifferentNameWithBetterTransformerLast() throws ResolverException {
        Converter xmlToString = ((MockConverterBuilder)new MockConverterBuilder().named("xmlToString")).build();
        Converter stringToJson = ((MockConverterBuilder)new MockConverterBuilder().named("stringToJson")).build();
        ArrayList<Converter> availableConverters = new ArrayList<Converter>();
        availableConverters.add(xmlToString);
        availableConverters.add(stringToJson);
        List transformers = this.filter.filter(availableConverters, UNUSED_DATA_TYPE, UNUSED_DATA_TYPE);
        junit.framework.Assert.assertEquals((int)1, (int)transformers.size());
        Assert.assertTrue((boolean)transformers.contains(stringToJson));
    }
}

