/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.graph;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.internal.transformer.ResolverException;
import org.mule.runtime.core.internal.transformer.builder.MockConverterBuilder;
import org.mule.runtime.core.internal.transformer.graph.AbstractTransformationGraphTestCase;
import org.mule.runtime.core.internal.transformer.graph.PriorityWeightingConverterFilter;
import org.mule.tck.size.SmallTest;

@SmallTest
public class PriorityWeightingConverterFilterTestCase
extends AbstractTransformationGraphTestCase {
    private PriorityWeightingConverterFilter filter = new PriorityWeightingConverterFilter();

    @Test
    public void filtersEmptyList() throws ResolverException {
        ArrayList availableConverters = new ArrayList();
        List converters = this.filter.filter(availableConverters, XML_DATA_TYPE, JSON_DATA_TYPE);
        Assert.assertEquals((int)0, (int)converters.size());
    }

    @Test
    public void filtersSameWeight() throws ResolverException {
        Converter xmlToInputStream = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToInputStream")).from(XML_DATA_TYPE)).to(INPUT_STREAM_DATA_TYPE)).weighting(1)).build();
        Converter xmlToString = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToString")).from(XML_DATA_TYPE)).to(STRING_DATA_TYPE)).weighting(1)).build();
        ArrayList<Converter> availableConverters = new ArrayList<Converter>();
        availableConverters.add(xmlToInputStream);
        availableConverters.add(xmlToString);
        List converters = this.filter.filter(availableConverters, XML_DATA_TYPE, JSON_DATA_TYPE);
        Assert.assertEquals((int)2, (int)converters.size());
        Assert.assertTrue((boolean)converters.contains(xmlToInputStream));
        Assert.assertTrue((boolean)converters.contains(xmlToString));
    }

    @Test
    public void filtersSameLengthDifferentWeightsAddingBetterTransformerFirst() throws ResolverException {
        Converter xmlToInputStream = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToInputStream")).from(XML_DATA_TYPE)).to(INPUT_STREAM_DATA_TYPE)).weighting(2)).build();
        Converter xmlToString = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToString")).from(XML_DATA_TYPE)).to(STRING_DATA_TYPE)).weighting(1)).build();
        ArrayList<Converter> availableConverters = new ArrayList<Converter>();
        availableConverters.add(xmlToInputStream);
        availableConverters.add(xmlToString);
        List converters = this.filter.filter(availableConverters, XML_DATA_TYPE, JSON_DATA_TYPE);
        Assert.assertEquals((int)1, (int)converters.size());
        Assert.assertEquals((Object)xmlToInputStream, converters.get(0));
    }

    @Test
    public void filtersSameLengthDifferentWeightsAddingBetterTransformerLast() throws ResolverException {
        Converter xmlToInputStream = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToInputStream")).from(XML_DATA_TYPE)).to(INPUT_STREAM_DATA_TYPE)).weighting(2)).build();
        Converter xmlToString = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToString")).from(XML_DATA_TYPE)).to(STRING_DATA_TYPE)).weighting(1)).build();
        ArrayList<Converter> availableConverters = new ArrayList<Converter>();
        availableConverters.add(xmlToString);
        availableConverters.add(xmlToInputStream);
        List converters = this.filter.filter(availableConverters, XML_DATA_TYPE, JSON_DATA_TYPE);
        Assert.assertEquals((int)1, (int)converters.size());
        Assert.assertEquals((Object)xmlToInputStream, converters.get(0));
    }
}

