/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.graph;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.internal.transformer.ResolverException;
import org.mule.runtime.core.internal.transformer.builder.MockConverterBuilder;
import org.mule.runtime.core.internal.transformer.graph.AbstractTransformationGraphTestCase;
import org.mule.runtime.core.internal.transformer.graph.TransformationLengthConverterFilter;
import org.mule.runtime.core.privileged.transformer.CompositeConverter;
import org.mule.tck.size.SmallTest;

@SmallTest
public class ShortestTransformationLengthTransformerFilterTestCase
extends AbstractTransformationGraphTestCase {
    private TransformationLengthConverterFilter filter = new TransformationLengthConverterFilter();

    @Test
    public void filtersEmptyList() throws ResolverException {
        ArrayList availableConverters = new ArrayList();
        List converters = this.filter.filter(availableConverters, UNUSED_DATA_TYPE, UNUSED_DATA_TYPE);
        Assert.assertEquals((int)0, (int)converters.size());
    }

    @Test
    public void filtersEqualLength() throws ResolverException {
        Converter xmlToString = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToString")).from(XML_DATA_TYPE)).to(STRING_DATA_TYPE)).build();
        Converter xmlToJson = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToJson")).from(XML_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        ArrayList<Converter> availableConverters = new ArrayList<Converter>();
        availableConverters.add(xmlToString);
        availableConverters.add(xmlToJson);
        List transformers = this.filter.filter(availableConverters, UNUSED_DATA_TYPE, UNUSED_DATA_TYPE);
        Assert.assertEquals((int)2, (int)transformers.size());
        Assert.assertTrue((boolean)transformers.contains(xmlToString));
        Assert.assertTrue((boolean)transformers.contains(xmlToJson));
    }

    @Test
    public void filtersDifferentLengthWithBetterTrasnformerFist() throws ResolverException {
        Converter xmlToString = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToString")).from(XML_DATA_TYPE)).to(STRING_DATA_TYPE)).build();
        Converter stringToJson = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("stringToJson")).from(STRING_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        ArrayList<Object> availableConverters = new ArrayList<Object>();
        availableConverters.add(xmlToString);
        CompositeConverter compositeConverter = new CompositeConverter(new Converter[]{xmlToString, stringToJson});
        availableConverters.add(compositeConverter);
        List transformers = this.filter.filter(availableConverters, UNUSED_DATA_TYPE, UNUSED_DATA_TYPE);
        Assert.assertEquals((int)1, (int)transformers.size());
        Assert.assertEquals((Object)xmlToString, transformers.get(0));
    }

    @Test
    public void filtersDifferentLengthWithBetterTransformerLast() throws ResolverException {
        Converter xmlToString = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToString")).from(XML_DATA_TYPE)).to(STRING_DATA_TYPE)).build();
        Converter stringToJson = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("stringToJson")).from(STRING_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        ArrayList<Object> availableConverters = new ArrayList<Object>();
        CompositeConverter compositeConverter = new CompositeConverter(new Converter[]{xmlToString, stringToJson});
        availableConverters.add(compositeConverter);
        availableConverters.add(xmlToString);
        List transformers = this.filter.filter(availableConverters, UNUSED_DATA_TYPE, UNUSED_DATA_TYPE);
        Assert.assertEquals((int)1, (int)transformers.size());
        Assert.assertEquals((Object)xmlToString, transformers.get(0));
    }
}

