/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.internal.transformer.ResolverException;
import org.mule.runtime.core.internal.transformer.builder.MockConverterBuilder;
import org.mule.runtime.core.internal.transformer.graph.AbstractTransformationGraphTestCase;
import org.mule.runtime.core.internal.transformer.graph.SynchronizedTransformationGraph;
import org.mule.runtime.core.internal.transformer.graph.TransformationGraphLookupStrategy;
import org.mule.runtime.core.internal.transformer.graph.TransformationGraphTestCase;

public class SynchronizedTransformationGraphTestCase
extends TransformationGraphTestCase {
    private static int CONCURRENCY_TEST_SIZE = 1000;
    private static int MAX_TIMEOUT_SECONDS = 20;

    @Test
    public void modifyGraphWhileResolvingTransformer() throws ResolverException, InterruptedException {
        final Converter xmlToJson = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(XML_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        final Converter inputStreamToXml = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(INPUT_STREAM_DATA_TYPE)).to(XML_DATA_TYPE)).build();
        final SynchronizedTransformationGraph graph = new SynchronizedTransformationGraph();
        final TransformationGraphLookupStrategy lookupStrategyTransformation = new TransformationGraphLookupStrategy(graph);
        Runnable addTransformer = new Runnable(){

            @Override
            public void run() {
                graph.addConverter(xmlToJson);
                graph.addConverter(inputStreamToXml);
            }
        };
        Runnable resolveTransformer = new Runnable(){

            @Override
            public void run() {
                lookupStrategyTransformation.lookupConverters(AbstractTransformationGraphTestCase.INPUT_STREAM_DATA_TYPE, AbstractTransformationGraphTestCase.JSON_DATA_TYPE);
            }
        };
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        for (int i = 0; i < CONCURRENCY_TEST_SIZE; ++i) {
            runnables.add(addTransformer);
            runnables.add(resolveTransformer);
        }
        SynchronizedTransformationGraphTestCase.assertConcurrent("Modify transformers while resolving it", runnables, MAX_TIMEOUT_SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertConcurrent(String message, List<? extends Runnable> runnables, int maxTimeoutSeconds) throws InterruptedException {
        int numThreads = runnables.size();
        final List exceptions = Collections.synchronizedList(new ArrayList());
        ExecutorService threadPool = Executors.newFixedThreadPool(numThreads);
        try {
            final CountDownLatch allExecutorThreadsReady = new CountDownLatch(numThreads);
            final CountDownLatch afterInitBlocker = new CountDownLatch(1);
            final CountDownLatch allDone = new CountDownLatch(numThreads);
            for (final Runnable runnable : runnables) {
                threadPool.submit(new Runnable(){

                    @Override
                    public void run() {
                        allExecutorThreadsReady.countDown();
                        try {
                            afterInitBlocker.await();
                            runnable.run();
                        }
                        catch (Throwable e) {
                            exceptions.add(e);
                            e.printStackTrace();
                        }
                        finally {
                            allDone.countDown();
                        }
                    }
                });
            }
            Assert.assertTrue((String)"Timeout initializing threads! Perform long lasting initializations before passing runnables to assertConcurrent", (boolean)allExecutorThreadsReady.await(runnables.size() * 10, TimeUnit.MILLISECONDS));
            afterInitBlocker.countDown();
            Assert.assertTrue((String)(message + " timeout! More than" + maxTimeoutSeconds + "seconds"), (boolean)allDone.await(maxTimeoutSeconds, TimeUnit.HOURS));
        }
        finally {
            threadPool.shutdownNow();
        }
        Assert.assertTrue((String)(message + "failed with exception(s)" + exceptions), (boolean)exceptions.isEmpty());
    }
}

