/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.graph;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.internal.transformer.builder.MockConverterBuilder;
import org.mule.runtime.core.internal.transformer.graph.AbstractTransformationGraphTestCase;
import org.mule.runtime.core.internal.transformer.graph.SynchronizedTransformationGraph;
import org.mule.runtime.core.internal.transformer.graph.TransformationGraphLookupStrategy;
import org.mule.runtime.core.privileged.transformer.CompositeConverter;
import org.mule.tck.size.SmallTest;

@SmallTest
public class TransformationGraphLookupStrategyTestCase
extends AbstractTransformationGraphTestCase {
    private SynchronizedTransformationGraph graph = new SynchronizedTransformationGraph();
    private TransformationGraphLookupStrategy lookupStrategyTransformation = new TransformationGraphLookupStrategy(this.graph);

    @Test
    public void lookupTransformersNoSourceInGraph() throws Exception {
        Converter inputStreamToXml = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(INPUT_STREAM_DATA_TYPE)).to(XML_DATA_TYPE)).build();
        this.graph.addConverter(inputStreamToXml);
        List converters = this.lookupStrategyTransformation.lookupConverters(JSON_DATA_TYPE, INPUT_STREAM_DATA_TYPE);
        junit.framework.Assert.assertEquals((int)0, (int)converters.size());
    }

    @Test
    public void lookupTransformersNoTargetInGraph() throws Exception {
        Converter inputStreamToXml = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(INPUT_STREAM_DATA_TYPE)).to(XML_DATA_TYPE)).build();
        this.graph.addConverter(inputStreamToXml);
        List converters = this.lookupStrategyTransformation.lookupConverters(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        junit.framework.Assert.assertEquals((int)0, (int)converters.size());
    }

    @Test
    public void findsDirectTransformation() throws Exception {
        Converter inputStreamToXml = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(INPUT_STREAM_DATA_TYPE)).to(XML_DATA_TYPE)).build();
        this.graph.addConverter(inputStreamToXml);
        List converters = this.lookupStrategyTransformation.lookupConverters(INPUT_STREAM_DATA_TYPE, XML_DATA_TYPE);
        junit.framework.Assert.assertEquals((int)1, (int)converters.size());
        junit.framework.Assert.assertEquals((Object)inputStreamToXml, converters.get(0));
    }

    @Test
    public void findsDirectTransformationWhileChangingGraph() throws Exception {
        Converter inputStreamToXml = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(INPUT_STREAM_DATA_TYPE)).to(XML_DATA_TYPE)).build();
        this.graph.addConverter(inputStreamToXml);
        List converters = this.lookupStrategyTransformation.lookupConverters(INPUT_STREAM_DATA_TYPE, XML_DATA_TYPE);
        MatcherAssert.assertThat((Object)converters, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(converters.get(0), (Matcher)Matchers.is((Object)inputStreamToXml));
    }

    @Test
    public void findsMultipleDirectTransformations() throws Exception {
        Converter inputStreamToXml = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(INPUT_STREAM_DATA_TYPE)).to(XML_DATA_TYPE)).build();
        this.graph.addConverter(inputStreamToXml);
        Converter betterInputStreamToXml = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(INPUT_STREAM_DATA_TYPE)).to(XML_DATA_TYPE)).build();
        this.graph.addConverter(betterInputStreamToXml);
        List converters = this.lookupStrategyTransformation.lookupConverters(INPUT_STREAM_DATA_TYPE, XML_DATA_TYPE);
        junit.framework.Assert.assertEquals((int)2, (int)converters.size());
        Assert.assertTrue((boolean)converters.contains(inputStreamToXml));
        Assert.assertTrue((boolean)converters.contains(betterInputStreamToXml));
    }

    @Test
    public void findsCompositeConverter() throws Exception {
        Converter inputStreamToString = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("inputStreamToString")).from(INPUT_STREAM_DATA_TYPE)).to(STRING_DATA_TYPE)).build();
        this.graph.addConverter(inputStreamToString);
        Converter stringToJson = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("stringToJson")).from(STRING_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        this.graph.addConverter(stringToJson);
        List converters = this.lookupStrategyTransformation.lookupConverters(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        junit.framework.Assert.assertEquals((int)1, (int)converters.size());
        this.assertContainsCompositeTransformer(converters, inputStreamToString, stringToJson);
    }

    @Test
    public void findsMultipleCompositeConvertersWithMultipleEdgesFromSource() throws Exception {
        Converter inputStreamToString = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("inputStreamToString")).from(INPUT_STREAM_DATA_TYPE)).to(STRING_DATA_TYPE)).build();
        this.graph.addConverter(inputStreamToString);
        Converter inputStreamToJson = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("inputStreamToJson")).from(INPUT_STREAM_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        this.graph.addConverter(inputStreamToJson);
        Converter jsonToXml = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("jsonToXml")).from(JSON_DATA_TYPE)).to(XML_DATA_TYPE)).build();
        this.graph.addConverter(jsonToXml);
        Converter jsonToString = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("jsonToString")).from(JSON_DATA_TYPE)).to(STRING_DATA_TYPE)).build();
        this.graph.addConverter(jsonToString);
        Converter stringToXml = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("stringToXml")).from(STRING_DATA_TYPE)).to(XML_DATA_TYPE)).build();
        this.graph.addConverter(stringToXml);
        Converter stringToJson = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("stringToJson")).from(STRING_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        this.graph.addConverter(stringToJson);
        List converters = this.lookupStrategyTransformation.lookupConverters(INPUT_STREAM_DATA_TYPE, XML_DATA_TYPE);
        junit.framework.Assert.assertEquals((int)4, (int)converters.size());
        this.assertContainsCompositeTransformer(converters, inputStreamToString, stringToXml);
        this.assertContainsCompositeTransformer(converters, inputStreamToJson, jsonToXml);
        this.assertContainsCompositeTransformer(converters, inputStreamToString, stringToJson, jsonToXml);
    }

    @Test
    public void transformerWithNoCharsetDataTypeAsSourceFoundEvenWhenSpecified() throws Exception {
        Converter utf16ToJson = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(DataType.builder((DataType)UTF_16_DATA_TYPE).charset((String)null).build())).to(JSON_DATA_TYPE)).build();
        this.graph.addConverter(utf16ToJson);
        List converters = this.lookupStrategyTransformation.lookupConverters(UTF_16_DATA_TYPE, JSON_DATA_TYPE);
        MatcherAssert.assertThat((Object)converters, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)converters, (Matcher)Matchers.contains((Object[])new Converter[]{utf16ToJson}));
    }

    @Test
    public void transformerWithNoCharsetDataTypeAsTargetNotFoundSinceIsMoreSpecific() throws Exception {
        Converter jsonToUtf16 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(JSON_DATA_TYPE)).to(DataType.builder((DataType)UTF_16_DATA_TYPE).charset((String)null).build())).build();
        this.graph.addConverter(jsonToUtf16);
        List converters = this.lookupStrategyTransformation.lookupConverters(JSON_DATA_TYPE, UTF_16_DATA_TYPE);
        MatcherAssert.assertThat((Object)converters, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void compatibleConverterShouldBeReturnedEvenIfTargetDataTypeDoesNotExist() throws Exception {
        Converter jsonToTextString = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("jsonToTextString")).from(DataType.JSON_STRING)).to(DataType.TEXT_STRING)).build();
        this.graph.addConverter(jsonToTextString);
        List converters = this.lookupStrategyTransformation.lookupConverters(DataType.JSON_STRING, DataType.STRING);
        MatcherAssert.assertThat((Object)converters, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((Converter)converters.get(0)).getName(), (Matcher)Matchers.is((Object)"jsonToTextString"));
    }

    @Test
    public void compatibleConverterShouldBeReturnedEvenIfTSourceDataTypeDoesNotExist() throws Exception {
        Converter xmlToTextString = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("textStringToXML")).from(XML_DATA_TYPE)).to(DataType.TEXT_STRING)).build();
        this.graph.addConverter(xmlToTextString);
        List converters = this.lookupStrategyTransformation.lookupConverters(XML_DATA_TYPE, DataType.STRING);
        MatcherAssert.assertThat((Object)converters, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((Converter)converters.get(0)).getName(), (Matcher)Matchers.is((Object)"textStringToXML"));
    }

    private void assertContainsCompositeTransformer(List<Converter> converters, Converter ... composedConverters) {
        for (Converter converter : converters) {
            CompositeConverter compositeConverter;
            if (!(converter instanceof CompositeConverter) || (compositeConverter = (CompositeConverter)converter).getConverters().size() != composedConverters.length) continue;
            boolean matches = true;
            for (int i = 0; i < composedConverters.length - 1; ++i) {
                if (composedConverters[i] == compositeConverter.getConverters().get(i)) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return;
        }
        junit.framework.Assert.fail((String)("Converter list does not contain a composite converter with: " + composedConverters));
    }
}

